/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.authority;

import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.authority.CouponAuthority;

public class RemoteCouponAuthority
implements CouponAuthority {
    private CouponAuthority remoteAuth;
    private static RemoteCouponAuthority instance;

    public static RemoteCouponAuthority getInstance() {
        return instance;
    }

    public static void init() {
        if (instance == null) {
            instance = new RemoteCouponAuthority();
        }
    }

    private RemoteCouponAuthority() {
        this.resolve();
    }

    private synchronized boolean resolve() {
        if (this.remoteAuth == null) {
            try {
                this.remoteAuth = (CouponAuthority)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "CouponAuthRemote", 11100);
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Cannot retrieve Coupon authority from ServerMate", (Throwable)e);
            }
            catch (NotBoundException e) {
                OrderMate.LOG.error("Cannot retrieve Coupon authority from ServerMate, Not shared?");
            }
        }
        return this.remoteAuth != null;
    }

    @Override
    public CouponTransaction requestRedeemCoupon(CouponTransaction txn) {
        if (this.resolve()) {
            try {
                this.remoteAuth.requestRedeemCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot communicate with Remote Coupon Authority", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "Cannot communicate with Remote Coupon Authority");
            }
        } else {
            txn.setStatus(CouponTransaction.Status.Denied, "Cannot handle redemption of coupon, Remote Coupon Authority cannot be contacted");
            OrderMate.LOG.warn("Cannot handle redemption of coupon, Remote Coupon Authority cannot be contacted");
        }
        return txn;
    }

    @Override
    public CouponTransaction requestUnredeemCoupon(CouponTransaction txn) {
        if (this.resolve()) {
            try {
                this.remoteAuth.requestUnredeemCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot communicate with Remote Coupon Authority", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "Cannot communicate with Remote Coupon Authority");
            }
        } else {
            txn.setStatus(CouponTransaction.Status.Denied, "Cannot handle unredemption of coupon, Remote Coupon Authority cannot be contacted");
            OrderMate.LOG.warn("Cannot handle unredemption of coupon, Remote Coupon Authority cannot be contacted");
        }
        return txn;
    }

    @Override
    public CouponTransaction requestActivateCoupon(CouponTransaction txn) {
        if (this.resolve()) {
            try {
                this.remoteAuth.requestActivateCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot communicate with Remote Coupon Authority", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "Cannot communicate with Remote Coupon Authority");
            }
        } else {
            txn.setStatus(CouponTransaction.Status.Denied, "Cannot activate coupon, Remote Coupon Authority cannot be contacted");
            OrderMate.LOG.warn("Cannot activate coupon, Remote Coupon Authority cannot be contacted");
        }
        return txn;
    }

    @Override
    public CouponTransaction revalidateCoupon(CouponTransaction txn) throws RemoteException {
        if (this.resolve()) {
            try {
                this.remoteAuth.requestActivateCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot communicate with Remote Coupon Authority", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "Cannot communicate with Remote Coupon Authority");
            }
        } else {
            txn.setStatus(CouponTransaction.Status.Denied, "Cannot revalidate a coupon, Remote Coupon Authority cannot be contacted");
            OrderMate.LOG.warn("Cannot revalidate a coupon, Remote Coupon Authority cannot be contacted");
        }
        return txn;
    }
}

