/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.drivertracking;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import ordermate.database.integration.drivertracking.DriverTrackingType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.users.User;

@Entity
@Table(name="config_driver_tracking")
public class DriverTrackingConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private boolean enabled;
    private DriverTrackingType integrationType;
    private String label;
    private Reference<WebserviceIntegrationConfig> webConfig;

    @Deprecated
    public DriverTrackingConfig() {
        this.webConfig = this.createReference(DriverTrackingConfig.Properties.WEB_CONFIG);
    }

    public DriverTrackingConfig(DriverTrackingType type) {
        this.webConfig = this.createReference(DriverTrackingConfig.Properties.WEB_CONFIG);
        this.integrationType = type;
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    protected void setLabel(String value) {
        this.label = value;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="integration_type")
    public DriverTrackingType getIntegrationType() {
        return this.integrationType;
    }

    protected void setIntegrationType(DriverTrackingType type) {
        this.integrationType = type;
    }

    @OneToOne(targetEntity=WebserviceIntegrationConfig.class)
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebConfig() {
        return this.webConfig.get();
    }

    public void setWebConfig(WebserviceIntegrationConfig value) {
        this.webConfig.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webConfig.saveChild();
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.setEnabled(false);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.getLabel() == null ? "<No Label Set>" : this.getLabel();
    }

    public static DriverTrackingConfig getDriverTrackingConfig(DriverTrackingType type) {
        return PersistenceManager.getObject(DriverTrackingConfig.class, Query.select(DriverTrackingConfig.class).equals(DriverTrackingConfig.Properties.INTEGRATION_TYPE, (Object)type).toString());
    }

    public static List<User> getActiveDriverTrackingUsers() {
        return PersistenceManager.getObjectList(User.class, Query.select(User.class).not().isNull(User.Properties.DRIVER_TRACKING).linkUsing(DriverTrackingConfig.Properties.ID, User.Properties.DRIVER_TRACKING).equals(DriverTrackingConfig.Properties.ENABLED, 1.0).toString());
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<DriverTrackingType> INTEGRATION_TYPE;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEB_CONFIG;
    }
}

