/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.exportsales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.StringUtils;
import java.util.Date;
import ordermate.database.integration.exportsales.SalesExporterType;

public class ExportSalesIntegration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private boolean enabled = false;
    private String subdomain;
    private String token = null;
    private Date lastSalesExport = null;
    private Date lastTimesheetExport = null;
    private int operationalUnit;
    private int location;
    private SalesExporterType exporterType = SalesExporterType.Deputy;
    private boolean includeTax = false;

    public ExportSalesIntegration() {
        this.subdomain = this.exporterType.getDefaultSubdomain();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String value) {
        if (!StringUtils.isEmpty(value)) {
            this.subdomain = value;
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String yourToken) {
        this.token = yourToken;
    }

    public Date getLastSalesExport() {
        return this.lastSalesExport;
    }

    public void setLastSalesExport(Date value) {
        this.lastSalesExport = value;
    }

    public Date getLastTimesheetExport() {
        return this.lastTimesheetExport;
    }

    public void setLastTimesheetExport(Date value) {
        this.lastTimesheetExport = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.setEnabled(false);
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public int getOperationalUnit() {
        return this.operationalUnit;
    }

    public void setOperationalUnit(int value) {
        this.operationalUnit = value;
    }

    public SalesExporterType getExporterType() {
        return this.exporterType;
    }

    public void setExporterType(SalesExporterType type) {
        this.exporterType = type;
    }

    public boolean isIncludeTax() {
        return this.includeTax;
    }

    public void setIncludeTax(boolean value) {
        this.includeTax = value;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<String> SUBDOMAIN;
        public PropertiedObject.Property<String> TOKEN;
        public PropertiedObject.Property<Date> LAST_SALES_EXPORT;
        public PropertiedObject.Property<Date> LAST_TIMESHEET_EXPORT;
        public PropertiedObject.Property<Integer> OPERATIONAL_UNIT;
        public PropertiedObject.Property<Integer> LOCATION;
        public PropertiedObject.Property<SalesExporterType> EXPORTER_TYPE;
        public PropertiedObject.Property<Boolean> INCLUDE_TAX;
    }
}

