/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.exportsales;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.OperationalUnitItem;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.database.integration.exportsales.Tanda.TandaOperationalUnitUtil;
import ordermate.database.integration.exportsales.deputy.DeputyOperationalUnitUtil;
import ordermate.database.inventory.InventoryCategory;

public class SalesExportItem
extends PersistentObject
implements Saveable,
Displayable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private Long externalLocationID;
    private String terminals;
    private String categories;
    private String salesLocations;

    public static List<SalesExportItem> getAllExportFilters() {
        return PersistenceManager.getObjectList(SalesExportItem.class, Query.select(SalesExportItem.class).active(SalesExportItem.class).toString());
    }

    public static List<SalesExportItem> getAllExportFiltersIncDeleted() {
        return PersistenceManager.getObjectList(SalesExportItem.class, Query.select(SalesExportItem.class).toString());
    }

    public static boolean isDuplicateSectionsSent(SalesExportItem item) {
        List<SalesExportItem> filters = SalesExportItem.getAllExportFilters();
        for (SalesExportItem filter : filters) {
            boolean hasSalesLocation = false;
            boolean hasCommonTerminal = false;
            boolean hasCommonCategory = false;
            if (item.getID() != null && item.getID().equals(filter.getID())) continue;
            List<String> terminalIDs = null;
            List<String> CategoryIDs = null;
            List<String> salesLocationIDs = null;
            if (StringUtils.isEmpty(filter.getTerminals())) {
                hasCommonTerminal = true;
            } else {
                terminalIDs = Arrays.asList(filter.getTerminals().split("\\s*,\\s*"));
                for (String term : terminalIDs) {
                    hasCommonTerminal = hasCommonTerminal || item.terminalIsInList(term, true);
                }
            }
            if (StringUtils.isEmpty(filter.getCategories())) {
                hasCommonCategory = true;
            } else {
                CategoryIDs = Arrays.asList(filter.getCategories().split("\\s*,\\s*"));
                for (String cate : CategoryIDs) {
                    hasCommonCategory = hasCommonCategory || item.categoryIsInList(cate, true);
                }
            }
            if (StringUtils.isEmpty(filter.getSalesLocations())) {
                hasSalesLocation = true;
            } else {
                salesLocationIDs = Arrays.asList(filter.getSalesLocations().split("\\s*,\\s*"));
                for (String salesLocation : salesLocationIDs) {
                    hasSalesLocation = hasSalesLocation || item.salesLocationIsInList(salesLocation, true);
                }
            }
            if (!hasCommonTerminal || !hasCommonCategory || !hasSalesLocation) continue;
            return true;
        }
        return false;
    }

    public static List<OperationalUnitItem> getOperationalIDListFromThirdParty() {
        ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
        SalesExporterType salesExporterType = integration.getExporterType();
        if (salesExporterType.equals((Object)SalesExporterType.Deputy)) {
            return DeputyOperationalUnitUtil.getOperationalIDListFromDeputy();
        }
        if (salesExporterType.equals((Object)SalesExporterType.Tanda)) {
            return TandaOperationalUnitUtil.getOperationalIDListFromTanda();
        }
        return null;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public String getSystemState() {
        return this.systemState;
    }

    public void setExternalLocationID(Long externalLocationID) {
        this.externalLocationID = externalLocationID;
    }

    public Long getExternalLocationID() {
        return this.externalLocationID;
    }

    public void setTerminals(String terminals) {
        this.terminals = terminals;
    }

    public String getTerminals() {
        return this.terminals;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getCategories() {
        return this.categories;
    }

    public boolean terminalIsInList(Terminal term, boolean defaultVal) {
        if (term == null) {
            return false;
        }
        return this.terminalIsInList(term.getID().toString(), defaultVal);
    }

    public boolean terminalIsInList(String term, boolean defaultVal) {
        String terminalsStr = this.getTerminals();
        if (StringUtils.isEmpty(terminalsStr)) {
            return defaultVal;
        }
        List<String> terminalIDs = Arrays.asList(terminalsStr.split("\\s*,\\s*"));
        return terminalIDs.contains(term);
    }

    public boolean categoryIsInList(InventoryCategory cate, boolean defaultVal) {
        if (cate == null) {
            return false;
        }
        return this.categoryIsInList(cate.getID().toString(), defaultVal);
    }

    public boolean categoryIsInList(String cate, boolean defaultVal) {
        String categoryStr = this.getCategories();
        if (StringUtils.isEmpty(categoryStr)) {
            return defaultVal;
        }
        List<String> categoryIDs = Arrays.asList(categoryStr.split("\\s*,\\s*"));
        return categoryIDs.contains(cate);
    }

    public boolean salesLocationIsInList(SalesLocation salesLocation, boolean defaultVal) {
        if (salesLocation == null) {
            return false;
        }
        return this.salesLocationIsInList(salesLocation.getID().toString(), defaultVal);
    }

    public boolean salesLocationIsInList(String salesLocation, boolean defaultVal) {
        String salesLocationStr = this.getSalesLocations();
        if (StringUtils.isEmpty(salesLocationStr)) {
            return defaultVal;
        }
        List<String> salesLocationIDs = Arrays.asList(salesLocationStr.split("\\s*,\\s*"));
        return salesLocationIDs.contains(salesLocation);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public String getLabel() {
        return "Sales " + this.getSystemState() + " " + this.externalLocationID;
    }

    public static String getTerminalNameListString(String terminalsStr) {
        if (StringUtils.isEmpty(terminalsStr)) {
            return null;
        }
        List<String> terminalIDs = Arrays.asList(terminalsStr.split("\\s*,\\s*"));
        List<Terminal> terminals = PersistenceManager.getObjectList(Terminal.class, Query.select(Terminal.class).wherePropertyIn(Terminal.Properties.ID, terminalIDs).toString());
        if (terminals == null || terminals.isEmpty()) {
            return "All";
        }
        String terminalNameStr = StringUtils.mergeToStringWithSeparator(terminals, ",", new Stringifier<Terminal>(){

            @Override
            public String stringify(Terminal object) {
                return object.getLabel().toString();
            }
        });
        return terminalNameStr;
    }

    public static String getCategoryNameListString(String categoriesStr) {
        if (StringUtils.isEmpty(categoriesStr)) {
            return null;
        }
        List<String> categoryIDs = Arrays.asList(categoriesStr.split("\\s*,\\s*"));
        List<InventoryCategory> categories = PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).wherePropertyIn(InventoryCategory.Properties.ID, categoryIDs).toString());
        if (categories == null || categories.isEmpty()) {
            return "All";
        }
        String inventoryCategoriesStr = StringUtils.mergeToStringWithSeparator(categories, ",", new Stringifier<InventoryCategory>(){

            @Override
            public String stringify(InventoryCategory object) {
                return object.getLabel().toString();
            }
        });
        return inventoryCategoriesStr;
    }

    public static String getSalesLocationNameListString(String salesLocationStr) {
        if (StringUtils.isEmpty(salesLocationStr)) {
            return null;
        }
        List<String> salesLocationIDs = Arrays.asList(salesLocationStr.split("\\s*,\\s*"));
        List<SalesLocation> salesLocations = PersistenceManager.getObjectList(SalesLocation.class, Query.select(SalesLocation.class).wherePropertyIn(SalesLocation.Properties.ID, salesLocationIDs).toString());
        if (salesLocations == null || salesLocations.isEmpty()) {
            return "All";
        }
        String salesLocationsNameStr = StringUtils.mergeToStringWithSeparator(salesLocations, ",", new Stringifier<SalesLocation>(){

            @Override
            public String stringify(SalesLocation object) {
                return object.getLabel().toString();
            }
        });
        return salesLocationsNameStr;
    }

    public String getSalesLocations() {
        return this.salesLocations;
    }

    public void setSalesLocations(String salesLocations) {
        this.salesLocations = salesLocations;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<Long> EXTERNAL_LOCATION_ID;
        public PropertiedObject.Property<String> TERMINALS;
        public PropertiedObject.Property<String> CATEGORIES;
        public PropertiedObject.Property<String> SALES_LOCATIONS;
    }
}

