/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.exportsales.Tanda;

import au.com.ordermate.util.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.OperationalUnitItem;
import ordermate.database.integration.exportsales.Tanda.TandaDataStream;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class TandaOperationalUnitUtil {
    private static final int TIMEOUT = 5000;
    private static String preamble = "https://";
    private static String SUBDOMAIN = "my.tanda.co/";
    private static String tandaContext = "api/v2/";
    private static final String LOCATIONS = "locations";
    private static final String DATASTREAMS = "datastreams";
    private static final boolean platform = false;
    private static final boolean showBusinessHours = false;
    private static final long updateAfter = 1451570400L;

    public static List<OperationalUnitItem> getOperationalIDListFromTanda() {
        ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
        String token = integration.getToken();
        ArrayList<OperationalUnitItem> operationalUnitItems = new ArrayList<OperationalUnitItem>();
        OperationalUnitItem allValue = new OperationalUnitItem();
        allValue.setOperationalUnitName("All Areas");
        allValue.setId(0L);
        operationalUnitItems.add(allValue);
        String BASE_URL = preamble + (StringUtils.isEmpty(integration.getSubdomain()) ? SUBDOMAIN : integration.getSubdomain()) + tandaContext + DATASTREAMS;
        String url = String.format("%s?updated_after=%d&platform=%b&show_business_hours=%b", BASE_URL, 1451570400L, false, false);
        WebResource resource = new RestHelper().getSSLWebResource(url, new PassthroughX509TrustManager(), 5000, 5000, "TLSv1.2");
        WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("Bearer " + token)).type("application/json")).accept(new String[]{"application/json"});
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            OrderMate.LOG.warn("Fetch Datastreams List from Tanda failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
            return operationalUnitItems;
        }
        String responseJSON = (String)response.getEntity(String.class);
        ObjectMapper mapper = new ObjectMapper();
        List opIds = null;
        try {
            opIds = (List)mapper.readValue(responseJSON, (TypeReference)new TypeReference<List<TandaDataStream>>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
        if (opIds == null) {
            return operationalUnitItems;
        }
        for (TandaDataStream tandaDataStream : opIds) {
            OperationalUnitItem operationalUnitItem = new OperationalUnitItem();
            operationalUnitItem.setId(tandaDataStream.getId());
            operationalUnitItem.setOperationalUnitName(tandaDataStream.getName());
            operationalUnitItems.add(operationalUnitItem);
        }
        return operationalUnitItems;
    }
}

