/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.exportsales.deputy;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.OperationalUnitItem;
import ordermate.database.integration.exportsales.deputy.DeputyOperationalUnitItem;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class DeputyOperationalUnitUtil {
    public static List<OperationalUnitItem> getOperationalIDListFromDeputy() {
        ArrayList<DeputyOperationalUnitItem> deputyOpIdsList = new ArrayList<DeputyOperationalUnitItem>();
        ArrayList<OperationalUnitItem> opUnitItemList = new ArrayList<OperationalUnitItem>();
        DeputyOperationalUnitItem allValue = new DeputyOperationalUnitItem();
        allValue.setOperationalUnitName("All Areas");
        allValue.setID(0L);
        deputyOpIdsList.add(allValue);
        RestHelper rest = new RestHelper();
        Integer TIMEOUT = 5000;
        ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
        String uri = "https://" + integration.getSubdomain() + ".deputy.com/api/v1/resource/OperationalUnit";
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        try {
            boolean fine;
            WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("OAuth " + integration.getToken())).header("dp-meta-option", (Object)"none")).type("application/json")).accept(new String[]{"application/json"});
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Export of Sales Data to Deputy failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            List opIds = (List)mapper.readValue(responseJSON, (TypeReference)new TypeReference<List<DeputyOperationalUnitItem>>(){});
            for (DeputyOperationalUnitItem op : opIds) {
                if (!op.getActive()) continue;
                deputyOpIdsList.add(op);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
        for (DeputyOperationalUnitItem deputyOperationalUnitItem : deputyOpIdsList) {
            OperationalUnitItem operationalUnitItem = new OperationalUnitItem();
            operationalUnitItem.setId(deputyOperationalUnitItem.getID());
            operationalUnitItem.setOperationalUnitName(deputyOperationalUnitItem.getOperationalUnitName());
            opUnitItemList.add(operationalUnitItem);
        }
        return opUnitItemList;
    }
}

