/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.giftvoucher;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.giftvoucher.GiftVoucherConfigurationGLAccountLink;
import ordermate.database.integration.giftvoucher.GiftVoucherCreationStrategy;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.integration.giftvoucher.VoucherPrintingStrategy;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_gift_voucher")
public class GiftVoucherConfiguration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private GiftVoucherIntegrationType integrationType;
    private GiftVoucherCreationStrategy creationStrategy;
    private String label;
    private String lastAuthId;
    private Reference<WebserviceIntegrationConfig> webConfig;
    private int uuidLength;
    private int timeout;
    private boolean autoGen;
    private int autoGenSeed;
    private String lastVoucherId;
    private String prefix;
    private VoucherPrintingStrategy printing;
    private Integer defaultExpiryPeriod;
    private boolean bonusEnabled;
    private Double bonusRatio;
    private Double bonusMax;
    private Double bonusMin;
    private PersistentWriteableList<GiftVoucherConfigurationGLAccountLink> glLinks;

    @Deprecated
    public GiftVoucherConfiguration() {
        this.webConfig = this.createReference(GiftVoucherConfiguration.Properties.WEB_CONFIG);
        this.timeout = 10;
        this.autoGen = false;
        this.autoGenSeed = -1;
        this.printing = VoucherPrintingStrategy.Never;
        this.defaultExpiryPeriod = 1095;
        this.glLinks = (PersistentWriteableList)this.createList(GiftVoucherConfiguration.Properties.GL_LINKS);
    }

    public GiftVoucherConfiguration(GiftVoucherIntegrationType type) {
        this.webConfig = this.createReference(GiftVoucherConfiguration.Properties.WEB_CONFIG);
        this.timeout = 10;
        this.autoGen = false;
        this.autoGenSeed = -1;
        this.printing = VoucherPrintingStrategy.Never;
        this.defaultExpiryPeriod = 1095;
        this.glLinks = (PersistentWriteableList)this.createList(GiftVoucherConfiguration.Properties.GL_LINKS);
        this.label = type.name();
        this.uuidLength = 20;
        this.integrationType = type;
        this.prefix = type.name();
        this.creationStrategy = GiftVoucherCreationStrategy.NEVER;
        this.setWebConfig(new WebserviceIntegrationConfig());
        this.autoGenSeed = (int)(2.147483647E9 * Math.random());
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @Column(name="auto_gen")
    public boolean isAutoGen() {
        return this.autoGen;
    }

    public void setAutoGen(boolean value) {
        this.autoGen = value;
    }

    @Column(name="auto_gen_seed")
    public int getAutoGenSeed() {
        return this.autoGenSeed;
    }

    protected void setAutoGenSeed(int value) {
        if (this.autoGenSeed < 0) {
            this.autoGenSeed = value;
        }
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
        if (this.getWebConfig() != null) {
            this.getWebConfig().setDescription("Voucher:" + this.getLabel());
        }
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="integration_type")
    public GiftVoucherIntegrationType getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(GiftVoucherIntegrationType type) {
        this.integrationType = type;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="creation_strategy")
    public GiftVoucherCreationStrategy getCreationStrategy() {
        return this.creationStrategy;
    }

    public void setCreationStrategy(GiftVoucherCreationStrategy newStrategy) {
        if (newStrategy != null) {
            this.creationStrategy = newStrategy;
        }
    }

    @OneToOne(targetEntity=WebserviceIntegrationConfig.class)
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebConfig() {
        if (this.webConfig.isNull() && this.integrationType.equals((Object)GiftVoucherIntegrationType.Hive)) {
            this.webConfig.set(new WebserviceIntegrationConfig());
            this.webConfig.get().setDescription("Voucher:" + this.getLabel());
        }
        return this.webConfig.get();
    }

    protected void setWebConfig(WebserviceIntegrationConfig yourConfig) {
        this.webConfig.set(yourConfig);
    }

    @Column(name="last_request_id")
    public String getLastAuthId() {
        return this.lastAuthId;
    }

    public void setLastAuthId(String value) {
        this.lastAuthId = value;
    }

    @Column(name="last_voucher_id")
    public String getLastVoucherId() {
        return this.lastVoucherId;
    }

    public void setLastVoucherId(String value) {
        this.lastVoucherId = value;
    }

    @Column(name="uuid_length")
    public int getUuidLength() {
        return this.uuidLength;
    }

    public void setUuidLength(int length) {
        this.uuidLength = length;
    }

    @Column(name="timeout")
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    @Column(name="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    @Column(name="docket_printing")
    @Enumerated(value=EnumType.STRING)
    public VoucherPrintingStrategy getPrinting() {
        return this.printing;
    }

    public void setPrinting(VoucherPrintingStrategy value) {
        this.printing = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webConfig.saveChild();
        PersistenceManager.save(this);
        this.createGLCodeLinkIfNotExists();
        this.glLinks.saveChild();
    }

    @Override
    public void delete() {
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
        this.webConfig.deleteChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="default_expiry_period")
    public Integer getDefaultExpiryPeriod() {
        return this.defaultExpiryPeriod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefaultExpiryPeriod(Integer defaultPeriod) {
        if (defaultPeriod != null) {
            if (defaultPeriod < 0) throw new IllegalStateException("Default Expiry Period Can not be less than 0");
            this.defaultExpiryPeriod = defaultPeriod;
            return;
        } else {
            this.defaultExpiryPeriod = defaultPeriod;
        }
    }

    @Transient
    public List<GiftVoucherConfigurationGLAccountLink> getGlLinks() {
        return this.glLinks.getUnmodifiable();
    }

    protected void setGlLinks(List<GiftVoucherConfigurationGLAccountLink> links) {
        this.glLinks.set(links);
    }

    private void createGLCodeLinkIfNotExists() {
        if (this.glLinks.isEmpty()) {
            this.glLinks.add(new GiftVoucherConfigurationGLAccountLink(this, GiftVoucherTransaction.VoucherTransactionType.TOPUP));
            this.glLinks.add(new GiftVoucherConfigurationGLAccountLink(this, GiftVoucherTransaction.VoucherTransactionType.REDEEM));
        }
    }

    @Override
    public String toString() {
        return this.getLabel() == null ? "<No Label Set>" : this.getLabel();
    }

    @Column(name="bonus_enabled")
    public boolean isBonusEnabled() {
        return this.bonusEnabled;
    }

    public void setBonusEnabled(boolean bonusEnabled) {
        this.bonusEnabled = bonusEnabled;
    }

    @Column(name="bonus_ratio")
    public Double getBonusRatio() {
        return this.bonusRatio;
    }

    public void setBonusRatio(Double bonusRatio) {
        this.bonusRatio = bonusRatio;
    }

    @Column(name="bonus_max")
    public Double getBonusMax() {
        return this.bonusMax;
    }

    public void setBonusMax(Double bonusMax) {
        this.bonusMax = bonusMax;
    }

    @Column(name="bonus_min")
    public Double getBonusMin() {
        return this.bonusMin;
    }

    public void setBonusMin(Double bonusMin) {
        this.bonusMin = bonusMin;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<GiftVoucherIntegrationType> INTEGRATION_TYPE;
        public PropertiedObject.Property<GiftVoucherCreationStrategy> CREATION_STRATEGY;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEB_CONFIG;
        public PropertiedObject.Property<Integer> UUID_LENGTH;
        public PropertiedObject.Property<Integer> TIMEOUT;
        public PropertiedObject.Property<String> LAST_AUTH_ID;
        public PropertiedObject.Property AUTO_GEN;
        public PropertiedObject.Property AUTO_GEN_SEED;
        public PropertiedObject.Property<String> LAST_VOUCHER_ID;
        public PropertiedObject.Property<String> PREFIX;
        public PropertiedObject.Property<Integer> DEFAULT_EXPIRY_PERIOD;
        public PropertiedObject.Property<VoucherPrintingStrategy> PRINTING;
        public PropertiedObject.Property<GiftVoucherConfigurationGLAccountLink> GL_LINKS;
        public PropertiedObject.Property<Boolean> BONUS_ENABLED;
        public PropertiedObject.Property<Double> BONUS_RATIO;
        public PropertiedObject.Property<Double> BONUS_MIN;
        public PropertiedObject.Property<Double> BONUS_MAX;
    }
}

