/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.labour;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Date;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;

public class LabourIntegration
extends PersistentObject
implements Saveable {
    private static final String DEFAULT_WEBSERVICE_URL = "https://go.zuusworkforce.com/systems/ordermate/";
    private static Reference<LabourIntegration> instance = new LocalCachedReference<LabourIntegration>(new QueryReference<LabourIntegration>(LabourIntegration.class, Query.select(LabourIntegration.class)));
    public static final Props Properties = new Props();
    private boolean active = false;
    private String cronSchedule;
    private String extId = "0";
    private Reference<WebserviceIntegrationConfig> webserviceConfig;
    private Date lastPull;
    private String lastResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabourIntegration getInstance() {
        LabourIntegration integration = instance.get();
        if (integration != null) return integration;
        Class<LabourIntegration> clazz = LabourIntegration.class;
        synchronized (LabourIntegration.class) {
            integration = instance.get();
            if (integration != null) return integration;
            integration = new LabourIntegration();
            integration.makeDefaultWebservice();
            integration.save();
            instance.set(integration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return integration;
        }
    }

    @Deprecated
    public LabourIntegration() {
        this.webserviceConfig = this.createReference(LabourIntegration.Properties.WEBSERVICE_CONFIG);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setCronSchedule(String value) {
        this.cronSchedule = value;
    }

    public Date getLastPull() {
        return this.lastPull;
    }

    public void setLastPull(Date value) {
        this.lastPull = value;
    }

    public String getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(String value) {
        this.lastResult = value;
    }

    public WebserviceIntegrationConfig getWebserviceConfig() {
        if (this.webserviceConfig.isNull()) {
            this.makeDefaultWebservice();
        }
        return this.webserviceConfig.get();
    }

    public void setWebserviceConfig(WebserviceIntegrationConfig value) {
        if (value != null) {
            this.webserviceConfig.set(value);
        }
    }

    private void makeDefaultWebservice() {
        WebserviceIntegrationConfig webConfig = new WebserviceIntegrationConfig();
        webConfig.setUrl(DEFAULT_WEBSERVICE_URL);
        webConfig.setPassword("nopassword");
        webConfig.setUsername("nousername");
        this.webserviceConfig.set(webConfig);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webserviceConfig.saveChild();
        PersistenceManager.save(this);
        instance.collapse();
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property ACTIVE;
        public PropertiedObject.Property<String> CRON_SCHEDULE;
        public PropertiedObject.Property<String> EXT_ID;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEBSERVICE_CONFIG;
        public PropertiedObject.Property<Date> LAST_PULL;
        public PropertiedObject.Property<String> LAST_RESULT;
    }
}

