/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.labour;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.departments.Department;
import ordermate.integration.jaxb.webservice.labour.LabourVerification;

@Entity
@Table(name="report_labour")
public class LabourSummaryReport
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Date reportDate;
    private double totalHours;
    private double totalCost;
    private LabourVerification verified;
    private Reference<Department> department;

    @Deprecated
    public LabourSummaryReport() {
        this.department = this.createReference(LabourSummaryReport.Properties.DEPARTMENT);
    }

    public LabourSummaryReport(Date date, Department dept, double hours, double cost, LabourVerification verification) {
        this.department = this.createReference(LabourSummaryReport.Properties.DEPARTMENT);
        this.reportDate = date;
        this.totalHours = hours;
        this.totalCost = cost;
        this.setDepartment(dept);
        this.verified = verification;
    }

    @Column(name="report_date")
    @Temporal(value=TemporalType.DATE)
    public Date getReportDate() {
        return this.reportDate;
    }

    protected void setReportDate(Date value) {
        this.reportDate = value;
    }

    @ManyToOne(targetEntity=Department.class)
    @JoinColumn(name="fk_config_department")
    public Department getDepartment() {
        return this.department.get();
    }

    protected void setDepartment(Department value) {
        this.department.set(value);
    }

    @Column(name="total_hours")
    public double getTotalHours() {
        return this.totalHours;
    }

    public void setTotalHours(double value) {
        this.totalHours = value;
    }

    @Column(name="total_cost")
    public double getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(double value) {
        this.totalCost = value;
    }

    @Column(name="verified")
    @Enumerated(value=EnumType.STRING)
    public LabourVerification getVerified() {
        return this.verified;
    }

    public void setVerified(LabourVerification value) {
        this.verified = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Date> REPORT_DATE;
        public PropertiedObject.Property TOTAL_HOURS;
        public PropertiedObject.Property TOTAL_COST;
        public PropertiedObject.Property<Department> DEPARTMENT;
        public PropertiedObject.Property<LabourVerification> VERIFIED;
    }
}

