/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.online;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;

public enum OnlineAccountSource {
    MENU_LOG("menulog"),
    I_TAKEAWAY("itakeaway"),
    EAT_NOW("eatnow"),
    MENU_MATE("menumate"),
    OPEN_ORDER("openorder");

    private final String sourceName;
    public static final Map<String, OnlineAccountSource> register;

    private OnlineAccountSource(String source) {
        this.sourceName = source;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public static OnlineAccountSource getForName(String name) {
        OnlineAccountSource toReturn = register.get(name);
        return toReturn;
    }

    public String toString() {
        return this.sourceName;
    }

    static {
        register = PersistentEnumeration.buildRegister(OnlineAccountSource.values());
    }
}

