/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.online;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryProfileHelper;

public class OnlineIntegrationConfig
extends PersistentObject
implements Saveable {
    private static final String DEFAULT_LABEL = "Default";
    public static final String GLOBAL_ORDERMATE = "OrderMate Online";
    public static final String GLOBAL_DEF_PWORD = "37SquidInk10";
    public static final String INTERNET_PREPAYMENT = "Internet Prepayment";
    public static final Props Properties = new Props();
    private static LocalCachedReference<OnlineIntegrationConfig> defaultInstance = new LocalCachedReference<OnlineIntegrationConfig>(new QueryReference<OnlineIntegrationConfig>(OnlineIntegrationConfig.class, Query.select(OnlineIntegrationConfig.class).equals(OnlineIntegrationConfig.Properties.LABEL, "Default")));
    private static Map<String, OnlineIntegrationConfig> providerMap = new HashMap<String, OnlineIntegrationConfig>();
    private Reference<InventoryProfile> inventoryProfile;
    private Reference<AbstractDebtor> payOffDebtor;
    private Reference<Terminal> terminal;
    private Reference<FinanceUnit> payOffFinanceUnit;
    private Reference<CashDrawer> cashDrawer;
    private String label;
    private boolean playSound;
    private String fileWatcherPath;
    private PrintingStrategy printingStrategy;
    private int paypalConnectionTimeout;
    private int paypalReadTimeout;
    private MenuComplianceVersion menuComplianceVersion;
    private boolean importRequiredWarning;
    private Date lastMenuImportTime;
    private Date lastOrderTime;
    private PrePaymentMethod prePaymentMethod;

    public static OnlineIntegrationConfig getDefaultInstance() {
        OnlineIntegrationConfig config = defaultInstance.get();
        if (config == null) {
            config = new OnlineIntegrationConfig(DEFAULT_LABEL);
            config.setInventoryProfile(InventoryProfileHelper.getInstance().getFirstProfile());
            config.setPrePaymentMethod(PrePaymentMethod.ADD_PAYMENT_TYPE);
            config.setPrintingStrategy(PrintingStrategy.ALWAYS);
            defaultInstance.set(config);
            config.save();
            defaultInstance.collapse();
        }
        return config;
    }

    public static void collapseDefaultReference() {
        if (defaultInstance.isExpanded()) {
            defaultInstance.collapse();
        }
    }

    @Deprecated
    public OnlineIntegrationConfig() {
        this.inventoryProfile = this.createReference(OnlineIntegrationConfig.Properties.INVENTORY_PROFILE);
        this.payOffDebtor = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_DEBTOR);
        this.terminal = this.createReference(OnlineIntegrationConfig.Properties.TERMINAL);
        this.payOffFinanceUnit = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_FINANCE_UNIT);
        this.cashDrawer = this.createReference(OnlineIntegrationConfig.Properties.CASH_DRAWER);
        this.fileWatcherPath = "";
        this.printingStrategy = PrintingStrategy.PAID;
        this.menuComplianceVersion = MenuComplianceVersion.Vers1_1;
        this.importRequiredWarning = true;
        this.prePaymentMethod = PrePaymentMethod.AUTO_PAY_TO_DEBTOR;
    }

    public OnlineIntegrationConfig(String label) {
        this.inventoryProfile = this.createReference(OnlineIntegrationConfig.Properties.INVENTORY_PROFILE);
        this.payOffDebtor = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_DEBTOR);
        this.terminal = this.createReference(OnlineIntegrationConfig.Properties.TERMINAL);
        this.payOffFinanceUnit = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_FINANCE_UNIT);
        this.cashDrawer = this.createReference(OnlineIntegrationConfig.Properties.CASH_DRAWER);
        this.fileWatcherPath = "";
        this.printingStrategy = PrintingStrategy.PAID;
        this.menuComplianceVersion = MenuComplianceVersion.Vers1_1;
        this.importRequiredWarning = true;
        this.prePaymentMethod = PrePaymentMethod.AUTO_PAY_TO_DEBTOR;
        this.setLabel(label);
    }

    public OnlineIntegrationConfig(String label, OnlineIntegrationConfig toClone) {
        this.inventoryProfile = this.createReference(OnlineIntegrationConfig.Properties.INVENTORY_PROFILE);
        this.payOffDebtor = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_DEBTOR);
        this.terminal = this.createReference(OnlineIntegrationConfig.Properties.TERMINAL);
        this.payOffFinanceUnit = this.createReference(OnlineIntegrationConfig.Properties.PAY_OFF_FINANCE_UNIT);
        this.cashDrawer = this.createReference(OnlineIntegrationConfig.Properties.CASH_DRAWER);
        this.fileWatcherPath = "";
        this.printingStrategy = PrintingStrategy.PAID;
        this.menuComplianceVersion = MenuComplianceVersion.Vers1_1;
        this.importRequiredWarning = true;
        this.prePaymentMethod = PrePaymentMethod.AUTO_PAY_TO_DEBTOR;
        this.setLabel(label);
        this.setFileWatcherPath(toClone.getFileWatcherPath());
        this.setInventoryProfile(toClone.getInventoryProfile());
        this.setPayOffDebtor(toClone.getPayOffDebtor());
        this.setPrePaymentMethod(toClone.getPrePaymentMethod());
        this.setPlaySound(toClone.isPlaySound());
        this.setTerminal(toClone.getTerminal());
        this.setMenuComplianceVersion(toClone.getMenuComplianceVersion());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public InventoryProfile getInventoryProfile() {
        return this.inventoryProfile.get();
    }

    public void setInventoryProfile(InventoryProfile profile) {
        this.inventoryProfile.set(profile);
    }

    public AbstractDebtor getPayOffDebtor() {
        return this.payOffDebtor.get();
    }

    public void setPayOffDebtor(AbstractDebtor debtor) {
        this.payOffDebtor.set(debtor);
    }

    public FinanceUnit getPayOffFinanceUnit() {
        return this.payOffFinanceUnit.get();
    }

    public void setPayOffFinanceUnit(FinanceUnit unit) {
        this.payOffFinanceUnit.set(unit);
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer drawer) {
        this.cashDrawer.set(drawer);
    }

    public String getFileWatcherPath() {
        return this.fileWatcherPath;
    }

    public void setFileWatcherPath(String path) {
        this.fileWatcherPath = path;
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal term) {
        this.terminal.set(term);
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean value) {
        this.playSound = value;
    }

    public boolean isImportRequiredWarning() {
        return this.importRequiredWarning;
    }

    public void setImportRequiredWarning(boolean value) {
        this.importRequiredWarning = value;
    }

    public Date getLastMenuImportTime() {
        return this.lastMenuImportTime;
    }

    public void setLastMenuImportTime(Date value) {
        this.lastMenuImportTime = value;
    }

    public Date getLastOrderTime() {
        return this.lastOrderTime;
    }

    public void setLastOrderTime(Date value) {
        this.lastOrderTime = value;
    }

    @Override
    public void delete() {
        if (DEFAULT_LABEL.equals(this.label)) {
            return;
        }
        PersistenceManager.delete(this);
        providerMap.clear();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        if (this.equals(OnlineIntegrationConfig.getDefaultInstance())) {
            defaultInstance.clearCache();
        }
        providerMap.clear();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public PrePaymentMethod getPrePaymentMethod() {
        return this.prePaymentMethod;
    }

    public void setPrePaymentMethod(PrePaymentMethod value) {
        this.prePaymentMethod = value;
    }

    protected static void clearInstance() {
        defaultInstance.collapse();
        providerMap.clear();
    }

    public void setPaypalConnectionTimeout(int paypalConnectionTimeout) {
        this.paypalConnectionTimeout = paypalConnectionTimeout;
    }

    public int getPaypalConnectionTimeout() {
        return this.paypalConnectionTimeout;
    }

    public void setPaypalReadTimeout(int paypalReadTimeout) {
        this.paypalReadTimeout = paypalReadTimeout;
    }

    public int getPaypalReadTimeout() {
        return this.paypalReadTimeout;
    }

    public PrintingStrategy getPrintingStrategy() {
        return this.printingStrategy;
    }

    public void setPrintingStrategy(PrintingStrategy stratagem) {
        if (stratagem != null) {
            this.printingStrategy = stratagem;
        }
    }

    public static OnlineIntegrationConfig getConfigFor(String source) {
        if (source == null || source.isEmpty()) {
            return OnlineIntegrationConfig.getDefaultInstance();
        }
        if (!providerMap.containsKey(source)) {
            OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigWithoutCache(source);
            if (config != null) {
                providerMap.put(source, config);
            } else {
                providerMap.put(source, OnlineIntegrationConfig.getDefaultInstance());
            }
        }
        return providerMap.get(source);
    }

    public static OnlineIntegrationConfig getConfigWithoutCache(String source) {
        return PersistenceManager.getObject(OnlineIntegrationConfig.class, Query.select(OnlineIntegrationConfig.class).equals(OnlineIntegrationConfig.Properties.LABEL, source).toString());
    }

    public static OnlineIntegrationConfig getHungryHungryConfig() {
        return OnlineIntegrationConfig.getConfigWithoutCache(GLOBAL_ORDERMATE);
    }

    public MenuComplianceVersion getMenuComplianceVersion() {
        return this.menuComplianceVersion;
    }

    public void setMenuComplianceVersion(MenuComplianceVersion menuComplianceVersion) {
        this.menuComplianceVersion = menuComplianceVersion;
    }

    public static String validateInactiveIPDebtor() {
        String warning;
        ObjectQuery select = Query.select(AbstractDebtor.class).equals(AbstractDebtor.Properties.LABEL, INTERNET_PREPAYMENT).orderBy(AbstractDebtor.Properties.SYSTEM_STATE).limit(1);
        AbstractDebtor defaultDebtor = PersistenceManager.getObject(AbstractDebtor.class, select.toString(), null);
        if (defaultDebtor == null) {
            warning = "there is no Internet Prepayment Debtor account, it will be created automatically";
        } else {
            if (defaultDebtor.isActive()) {
                return null;
            }
            warning = "there is a deleted Internet Prepayment Debtor Account, it will be actived as default account ";
        }
        return warning;
    }

    public static enum MenuComplianceVersion {
        Vers1_1(1.1),
        Vers1_2(1.2);

        private final Double version;
        private static final String Version_1_1 = "1.1";
        private static final String Version_1_2 = "1.2";

        private MenuComplianceVersion(Double vers) {
            this.version = vers;
        }

        public String toString() {
            switch (this) {
                case Vers1_1: {
                    return Version_1_1;
                }
                case Vers1_2: {
                    return Version_1_2;
                }
            }
            return super.toString();
        }

        public String getDescription() {
            switch (this) {
                case Vers1_1: {
                    return "Initial version";
                }
                case Vers1_2: {
                    return "The attributes of advanced combo types are added into online menu export xml file";
                }
            }
            return super.toString();
        }

        public Double getVersion() {
            return this.version;
        }
    }

    public static enum PrintingStrategy {
        ALWAYS("Always Print"),
        PAID("Print When Paid"),
        ON_ETA_SET("Print On ETA Set");

        private String label;
        public static final Map<String, PrintingStrategy> register;

        private PrintingStrategy(String newLabel) {
            this.label = newLabel;
        }

        public String getLabel() {
            return this.label;
        }

        static {
            register = PersistentEnumeration.buildRegister(PrintingStrategy.values());
        }
    }

    public static enum PrePaymentMethod {
        AUTO_PAY_TO_DEBTOR,
        ADD_PAYMENT_TYPE;

        private static final String AUTO_PAY_TO_DEBTOR_STR = "Auto Pay To Debtor";
        private static final String ADD_PAYMENT_TYPE_STR = "Auto Add Payment Type";

        public String toString() {
            switch (this) {
                case AUTO_PAY_TO_DEBTOR: {
                    return AUTO_PAY_TO_DEBTOR_STR;
                }
                case ADD_PAYMENT_TYPE: {
                    return ADD_PAYMENT_TYPE_STR;
                }
            }
            return super.toString();
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<InventoryProfile> INVENTORY_PROFILE;
        public PropertiedObject.Property<AbstractDebtor> PAY_OFF_DEBTOR;
        public PropertiedObject.Property<FinanceUnit> PAY_OFF_FINANCE_UNIT;
        public PropertiedObject.Property<String> FILE_WATCHER_PATH;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property PLAY_SOUND;
        public PropertiedObject.Property<PrePaymentMethod> PRE_PAYMENT_METHOD;
        public PropertiedObject.Property<PrintingStrategy> PRINTING_STRATEGY;
        public PropertiedObject.Property PAYPAL_CONNECTION_TIMEOUT;
        public PropertiedObject.Property PAYPAL_READ_TIMEOUT;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<MenuComplianceVersion> MENU_COMPLIANCE_VERSION;
        public PropertiedObject.Property<Boolean> IMPORT_REQUIRED_WARNING;
        public PropertiedObject.Property<Date> LAST_MENU_IMPORT_TIME;
        public PropertiedObject.Property<Date> LAST_ORDER_TIME;
    }
}

