/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.online;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.sales.AccountType;

public class OnlineIntegrationETA
extends PersistentObject
implements Saveable {
    public static final String GLOBAL_ETA_NAME = "Global";
    public static final Props Properties = new Props();
    private AccountType accountType;
    private int defaultETA;
    private int currentETA;
    private EtaMode ETAMode = EtaMode.ALWAYS_ASK;

    public static OnlineIntegrationETA getGlobalETAConfig() {
        OnlineIntegrationETA eta = PersistenceManager.getObject(OnlineIntegrationETA.class, Query.select(OnlineIntegrationETA.class).equals(OnlineIntegrationETA.Properties.ACCOUNT_TYPE, AccountType.allType).toString());
        if (eta == null) {
            eta = new OnlineIntegrationETA();
            eta.accountType = AccountType.allType;
            eta.defaultETA = 30;
            eta.currentETA = 30;
            eta.save();
        }
        return eta;
    }

    public static OnlineIntegrationETA getETAForAccountType(AccountType accountType) {
        OnlineIntegrationETA eta = PersistenceManager.getObject(OnlineIntegrationETA.class, Query.select(OnlineIntegrationETA.class).equals(OnlineIntegrationETA.Properties.ACCOUNT_TYPE, accountType).toString());
        if (eta != null) {
            return eta;
        }
        return OnlineIntegrationETA.getGlobalETAConfig();
    }

    public static List<OnlineIntegrationETA> getAllETAs() {
        return PersistenceManager.getObjectList(OnlineIntegrationETA.class, Query.select(OnlineIntegrationETA.class).toString());
    }

    public OnlineIntegrationETA() {
    }

    public OnlineIntegrationETA(AccountType accountType, int defaultETA, int currentETA, EtaMode ETAMode) {
        this.setAccountType(accountType);
        this.setDefaultETA(defaultETA);
        this.setCurrentETA(currentETA);
        this.setETAMode(ETAMode);
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        if (this.isGlobalConfig()) {
            if (!AccountType.allType.equals(accountType)) {
                throw new UnsupportedOperationException("Cannot set the Account Type of the Default ETA Config");
            }
        } else if (AccountType.allType.equals(accountType)) {
            throw new UnsupportedOperationException("Can only set Account Type to All for the Default ETA Config");
        }
        this.accountType = accountType;
    }

    public int getDefaultETA() {
        return this.defaultETA;
    }

    public void setDefaultETA(int defaultETA) {
        if (defaultETA >= 0) {
            this.defaultETA = defaultETA;
        }
    }

    public int getCurrentETA() {
        return this.currentETA;
    }

    public void setCurrentETA(int currentETA) {
        if (currentETA >= 0) {
            this.currentETA = currentETA;
        }
    }

    public EtaMode getETAMode() {
        return this.ETAMode;
    }

    public void setETAMode(EtaMode ETAMode) {
        if (ETAMode != null) {
            this.ETAMode = ETAMode;
        }
    }

    public Date calculateETA(Integer minutes) {
        int difference = minutes == null ? this.getCurrentETA() : minutes.intValue();
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.add(12, difference);
        return cal.getTime();
    }

    public boolean isGlobalConfig() {
        return AccountType.allType.equals(this.accountType);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        if (this.isGlobalConfig()) {
            throw new UnsupportedOperationException("Cannot delete Default ETA Config");
        }
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        if (this.isGlobalConfig()) {
            return "Global ETA";
        }
        if (this.accountType != null) {
            return this.accountType.getLabel() + " ETA";
        }
        return "New ETA";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AccountType> ACCOUNT_TYPE;
        public PropertiedObject.Property<Integer> DEFAULT_ETA;
        public PropertiedObject.Property<Integer> CURRENT_ETA;
        public PropertiedObject.Property<EtaMode> ETA_MODE;
    }
}

