/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.online;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_menulog")
@AccessType(value="property")
public class PrintOnlyOnlineTerminalConfiguration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private static final LocalCacheListManager<PrintOnlyOnlineTerminalConfiguration> configurations = new LocalCacheListManager<PrintOnlyOnlineTerminalConfiguration>(Query.createQueryList(PrintOnlyOnlineTerminalConfiguration.class, Query.select(PrintOnlyOnlineTerminalConfiguration.class).active(PrintOnlyOnlineTerminalConfiguration.class)));
    private Reference<Terminal> terminal;
    private String filePath;
    private Reference<VirtualPrinter> virtualPrinter;
    private int menulogHeight;
    private String systemState;

    public static List<PrintOnlyOnlineTerminalConfiguration> getConfigurations() {
        return configurations.getList();
    }

    public static PrintOnlyOnlineTerminalConfiguration getConfiguration(Terminal terminal) {
        ObjectQuery query = Query.select(PrintOnlyOnlineTerminalConfiguration.class).equals(PrintOnlyOnlineTerminalConfiguration.Properties.TERMINAL, terminal.getID());
        return PersistenceManager.getObject(PrintOnlyOnlineTerminalConfiguration.class, query.toString(), new Object[0]);
    }

    public PrintOnlyOnlineTerminalConfiguration() {
        this.terminal = this.createReference(PrintOnlyOnlineTerminalConfiguration.Properties.TERMINAL);
        this.virtualPrinter = this.createReference(PrintOnlyOnlineTerminalConfiguration.Properties.VIRTUAL_PRINTER);
        this.systemState = "ACTIVE";
    }

    public PrintOnlyOnlineTerminalConfiguration(Terminal theTerminal, VirtualPrinter thePrinter, String theFilePath, int theMenulogHeight) {
        this.terminal = this.createReference(PrintOnlyOnlineTerminalConfiguration.Properties.TERMINAL);
        this.virtualPrinter = this.createReference(PrintOnlyOnlineTerminalConfiguration.Properties.VIRTUAL_PRINTER);
        this.systemState = "ACTIVE";
        this.setTerminal(theTerminal);
        this.setVirtualPrinter(thePrinter);
        this.filePath = theFilePath;
        this.menulogHeight = theMenulogHeight;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Column(name="file_path")
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String theFilePath) {
        this.filePath = theFilePath;
    }

    public void setVirtualPrinter(VirtualPrinter thePrinter) {
        this.virtualPrinter.set(thePrinter);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_virtual")
    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setTerminal(Terminal theTerminal) {
        if (theTerminal == null) {
            throw new NullPointerException("The terminal cannot be null");
        }
        if (!"WaiterMate".equals(theTerminal.getTerminalType())) {
            throw new IllegalStateException("The terminal should be WaiterMateTerminal");
        }
        this.terminal.set(theTerminal);
    }

    @Column(name="menulog_height")
    public int getMenulogHeight() {
        return this.menulogHeight;
    }

    public void setMenulogHeight(int theMenulogHeight) {
        this.menulogHeight = theMenulogHeight;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String theSystemState) {
        this.systemState = theSystemState;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property FILE_PATH;
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property MENULOG_HEIGHT;
        public PropertiedObject.Property SYSTEM_STATE;
    }
}

