/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.piggy;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;

@Entity
@Table(name="config_integration_piggy")
public class PiggyConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    public static final String CLOUD_PROPERTY_SERVICE = "Cloud Property Integration Service";
    private boolean enabled;
    private String label;
    private Reference<WebserviceIntegrationConfig> webConfig;
    private Reference<DebtorGroup> debtorGroup;
    private Date lastPushDate;

    @Deprecated
    public PiggyConfig() {
        this.webConfig = this.createReference(PiggyConfig.Properties.WEB_CONFIG);
        this.debtorGroup = this.createReference(PiggyConfig.Properties.DEBTOR_GROUP);
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Column(name="last_push_date")
    @Temporal(value=TemporalType.DATE)
    public Date getLastPushDate() {
        return this.lastPushDate;
    }

    public void setLastPushDate(Date date) {
        this.lastPushDate = date;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    protected void setLabel(String value) {
        this.label = value;
    }

    @OneToOne(targetEntity=WebserviceIntegrationConfig.class)
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebConfig() {
        return this.webConfig.get();
    }

    public void setWebConfig(WebserviceIntegrationConfig value) {
        this.webConfig.set(value);
    }

    @OneToOne(targetEntity=DebtorGroup.class)
    @JoinColumn(name="fk_debtor_group")
    public DebtorGroup getDebtorGroup() {
        return this.debtorGroup.get();
    }

    public void setDebtorGroup(DebtorGroup debtorGroup) {
        this.debtorGroup.set(debtorGroup);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webConfig.saveChild();
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.setEnabled(false);
        this.save();
    }

    public static PiggyConfig getConfig() {
        return PersistenceManager.getObject(PiggyConfig.class, Query.select(PiggyConfig.class).equals(PiggyConfig.Properties.LABEL, CLOUD_PROPERTY_SERVICE).toString());
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEB_CONFIG;
        public PropertiedObject.Property<DebtorGroup> DEBTOR_GROUP;
        public PropertiedObject.Property<Date> LAST_PUSH_DATE;
    }
}

