/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.webpayment;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.image.ImageFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.sales.Customer;

@Entity
@Table(name="config_integration_web_customer")
public class WebPaymentCustomer
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private String extId;
    private String extCustId;
    private Date createDate;
    private Date updateDate;
    private Date expireDate;
    private boolean checkedIn = false;
    private String imageUrl;
    private Reference<WebPaymentLocation> location;
    private Reference<Customer> customer;
    private Reference<ConfigSmallImage> image;

    @Deprecated
    public WebPaymentCustomer() {
        this.location = this.createReference(WebPaymentCustomer.Properties.LOCATION);
        this.customer = this.createReference(WebPaymentCustomer.Properties.CUSTOMER);
        this.image = this.createReference(WebPaymentCustomer.Properties.IMAGE);
    }

    public WebPaymentCustomer(WebPaymentLocation yourLocation, String custLabel, String tabExtId, String custExtId) {
        this.location = this.createReference(WebPaymentCustomer.Properties.LOCATION);
        this.customer = this.createReference(WebPaymentCustomer.Properties.CUSTOMER);
        this.image = this.createReference(WebPaymentCustomer.Properties.IMAGE);
        this.label = custLabel;
        this.extId = tabExtId;
        this.extCustId = custExtId;
        this.setLocation(yourLocation);
        ConfigSmallImage smallImage = new ConfigSmallImage(custLabel);
        smallImage.setFormat(ImageFormat.JPG);
        smallImage.setDescription("Image for " + custLabel);
        this.setImage(smallImage);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    protected void setExtId(String value) {
        this.extId = value;
    }

    @Column(name="ext_cust_id")
    public String getExtCustId() {
        return this.extCustId;
    }

    protected void setExtCustId(String value) {
        this.extCustId = value;
    }

    @Column(name="checked_in")
    public boolean isCheckedIn() {
        return this.checkedIn;
    }

    public void setCheckedIn(boolean value) {
        this.checkedIn = value;
    }

    @Transient
    public boolean isExpired() {
        if (this.expireDate == null) {
            return true;
        }
        if (new Date().after(this.expireDate)) {
            this.setCheckedIn(false);
            return true;
        }
        return false;
    }

    @Column(name="create_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date value) {
        this.createDate = value;
    }

    @Column(name="update_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date value) {
        this.updateDate = value;
    }

    @Column(name="expire_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date value) {
        this.expireDate = value;
    }

    @Column(name="image_url")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String value) {
        this.imageUrl = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer value) {
        this.customer.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_image_small")
    public ConfigSmallImage getImage() {
        return this.image.get();
    }

    protected void setImage(ConfigSmallImage value) {
        this.image.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_web_location")
    public WebPaymentLocation getLocation() {
        return this.location.get();
    }

    protected void setLocation(WebPaymentLocation value) {
        this.location.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.image.isPersistent()) {
            this.image.saveChild();
        }
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.image.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> EXT_ID;
        public PropertiedObject.Property<String> EXT_CUST_ID;
        public PropertiedObject.Property<Date> CREATE_DATE;
        public PropertiedObject.Property<Date> UPDATE_DATE;
        public PropertiedObject.Property<Date> EXPIRE_DATE;
        public PropertiedObject.Property<Boolean> CHECKED_IN;
        public PropertiedObject.Property<String> IMAGE_URL;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<ConfigSmallImage> IMAGE;
        public PropertiedObject.Property<WebPaymentLocation> LOCATION;
    }
}

