/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.webpayment;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.sales.CustomerCategory;
import ordermate.integration.paypal.PayPalTool;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_integration_web_payment")
public class WebPaymentIntegration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private WebPaymentType type;
    private String label;
    private String merchantId = "";
    private String merchantEmail = "";
    private String accessToken;
    private String refreshToken;
    private Date expiryDate;
    private String authCode;
    private String appId;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Reference<WebserviceIntegrationConfig> webserviceConfig;
    private PersistentWriteableList<WebPaymentLocation> locations;
    private Reference<CustomerCategory> defaultCustomerCategory;

    @Deprecated
    public WebPaymentIntegration() {
        this.webserviceConfig = this.createReference(WebPaymentIntegration.Properties.WEBSERVICE_CONFIG);
        this.locations = this.createWriteableList(WebPaymentIntegration.Properties.LOCATIONS);
        this.defaultCustomerCategory = this.createReference(WebPaymentIntegration.Properties.DEFAULT_CUSTOMER_CATEGORY);
    }

    public WebPaymentIntegration(WebPaymentType theType) {
        this.webserviceConfig = this.createReference(WebPaymentIntegration.Properties.WEBSERVICE_CONFIG);
        this.locations = this.createWriteableList(WebPaymentIntegration.Properties.LOCATIONS);
        this.defaultCustomerCategory = this.createReference(WebPaymentIntegration.Properties.DEFAULT_CUSTOMER_CATEGORY);
        if (theType == null) {
            throw new IllegalArgumentException("WebPaymentIntegration must have a type");
        }
        this.type = theType;
        this.label = this.type.name() + " Payments";
        WebserviceIntegrationConfig config = new WebserviceIntegrationConfig();
        if (WebPaymentType.PayPal.equals((Object)theType)) {
            PayPalTool tool = new PayPalTool();
            tool.configureWebServiceDefaults(config);
            this.setAppId("5ec13bbbeba369a3134b16e609ebde55");
        }
        this.webserviceConfig.set(config);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null) {
            this.label = value;
        }
    }

    @Column(name="integration_type")
    @Enumerated(value=EnumType.STRING)
    public WebPaymentType getType() {
        return this.type;
    }

    protected void setType(WebPaymentType theType) {
        this.type = theType;
    }

    @Column(name="merchant_id")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String value) {
        this.merchantId = value == null ? "" : value;
    }

    @Column(name="merchant_email")
    public String getMerchantEmail() {
        return this.merchantEmail;
    }

    public void setMerchantEmail(String value) {
        this.merchantEmail = value == null ? "" : value;
    }

    @Column(name="system_state")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        if (SystemState.ACTIVE_STATE.equals(value) || SystemState.INACTIVE_STATE.equals(value)) {
            this.systemState = value;
        }
    }

    @Column(name="app_id")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String value) {
        this.appId = value;
    }

    @Column(name="auth_code")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String value) {
        this.authCode = value;
    }

    @OneToMany(mappedBy="integration", targetEntity=WebPaymentLocation.class)
    public List<WebPaymentLocation> getLocations() {
        return this.locations.getUnmodifiable();
    }

    public void setLocations(List<WebPaymentLocation> values) {
        this.locations = this.locations.clone();
        this.locations.set(values);
    }

    public void addLocation(WebPaymentLocation location) {
        if (!this.equals(location.getIntegration())) {
            throw new IllegalStateException("Cannot add a location to this integration if it doesn't belong.");
        }
        this.locations.add(location);
    }

    public void removeLocation(WebPaymentLocation location) {
        this.locations.remove(location);
    }

    @Column(name="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void clearTokenData() {
        this.setAccessToken(null);
        this.setRefreshToken(null);
        this.setExpiryDate(null);
    }

    @Column(name="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Column(name="expiry_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebserviceConfig() {
        return this.webserviceConfig.get();
    }

    protected void setWebserviceConfig(WebserviceIntegrationConfig config) {
        this.webserviceConfig.set(config);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webserviceConfig.saveChild();
        PersistenceManager.save(this);
        this.locations.saveChild();
    }

    @Override
    public void delete() {
        this.locations.deleteChild();
        this.webserviceConfig.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.label != null ? this.label : "<No Label>";
    }

    public static boolean isWebPaymentIntegrationEnabled(WebPaymentType type) {
        WebPaymentIntegration integration = PersistenceManager.getObject(WebPaymentIntegration.class, Query.select(WebPaymentIntegration.class).equals(WebPaymentIntegration.Properties.TYPE, (Object)type).active(WebPaymentIntegration.class).toString());
        return integration != null;
    }

    public static WebPaymentIntegration createWebPaymentIntegration(WebPaymentType type) {
        WebPaymentIntegration integration = new WebPaymentIntegration(type);
        integration.save();
        return integration;
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_customer_category")
    public CustomerCategory getDefaultCustomerCategory() {
        if (this.defaultCustomerCategory.get() != null) {
            return this.defaultCustomerCategory.get();
        }
        return CustomerCategory.getDefaultCategory();
    }

    public void setDefaultCustomerCategory(CustomerCategory category) {
        this.defaultCustomerCategory.set(category);
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WebPaymentType> TYPE;
        public PropertiedObject.Property<String> MERCHANT_ID;
        public PropertiedObject.Property<String> MERCHANT_EMAIL;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<String> AUTH_CODE;
        public PropertiedObject.Property<String> APP_ID;
        public PropertiedObject.Property<String> ACCESS_TOKEN;
        public PropertiedObject.Property<String> REFRESH_TOKEN;
        public PropertiedObject.Property<Date> EXPIRY_DATE;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEBSERVICE_CONFIG;
        public PropertiedObject.Property<WebPaymentLocation> LOCATIONS;
        public PropertiedObject.Property<CustomerCategory> DEFAULT_CUSTOMER_CATEGORY;
    }
}

