/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.webpayment;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.MathsUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.misc.BusinessInfo;

@Entity
@Table(name="config_integration_web_location")
public class WebPaymentLocation
extends PersistentObject
implements SaveableChild {
    public static final long MIN_UPDATE_INTERVAL = 10000L;
    public static final long MAX_UPDATE_INTERVAL = 300000L;
    public static final Props Properties = new Props();
    private Reference<WebPaymentIntegration> integration;
    private String label;
    private String internalLabel;
    private String phone;
    private String message;
    private String extId;
    private String address;
    private ExtensionType extensionType;
    private String extensionUrl;
    private Long omStoreId;
    private boolean available;
    private Date createdDate;
    private Date updatedDate;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private Long updateInterval;

    @Deprecated
    public WebPaymentLocation() {
        this.integration = this.createReference(WebPaymentLocation.Properties.INTEGRATION);
        this.extensionType = ExtensionType.CheckIn;
        this.updateInterval = 52000L;
    }

    public WebPaymentLocation(WebPaymentIntegration payment) {
        this.integration = this.createReference(WebPaymentLocation.Properties.INTEGRATION);
        this.extensionType = ExtensionType.CheckIn;
        this.updateInterval = 52000L;
        this.integration.set(payment);
        this.label = payment.getLabel();
        this.internalLabel = payment.getLabel();
        this.phone = BusinessInfo.getInstance().getPhone();
        this.message = "";
        this.extId = null;
        this.address = null;
        this.available = false;
        this.createdDate = null;
        this.updatedDate = null;
        this.latitude = null;
        this.longitude = null;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="internal_label")
    public String getInternalLabel() {
        return this.internalLabel;
    }

    public void setInternalLabel(String value) {
        this.internalLabel = value;
    }

    @Column(name="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    @Column(name="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    @Column(name="phone")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String value) {
        this.phone = value;
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    @Column(name="available")
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean value) {
        this.available = value;
    }

    @Column(name="created_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date value) {
        this.createdDate = value;
    }

    @Column(name="updated_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date value) {
        this.updatedDate = value;
    }

    @Column(name="longitude")
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLongitude(BigDecimal value) {
        this.longitude = value;
    }

    @Column(name="latitude")
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public void setLatitude(BigDecimal value) {
        this.latitude = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_web_payment")
    public WebPaymentIntegration getIntegration() {
        return this.integration.get();
    }

    public void setIntegration(WebPaymentIntegration value) {
        this.integration.set(value);
    }

    @Column(name="extension_type")
    @Enumerated(value=EnumType.STRING)
    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    public void setExtensionType(ExtensionType extensionType) {
        this.extensionType = extensionType;
    }

    @Column(name="extension_url")
    public String getExtensionUrl() {
        return this.extensionUrl;
    }

    public void setExtensionUrl(String extensionUrl) {
        this.extensionUrl = extensionUrl;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Transient
    public boolean isPayTableOpen() {
        return ExtensionType.CheckInAndPayAtTable.equals((Object)this.extensionType) || ExtensionType.PayAtTable.equals((Object)this.extensionType);
    }

    @Column(name="update_interval")
    public Long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(Long updateInterval) {
        this.updateInterval = MathsUtils.clamp(updateInterval, 300000L, 10000L);
    }

    @Column(name="om_store_id")
    public Long getOmStoreId() {
        return this.omStoreId;
    }

    public void setOmStoreId(Long value) {
        this.omStoreId = value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> INTERNAL_LABEL;
        public PropertiedObject.Property<String> PHONE;
        public PropertiedObject.Property<String> MESSAGE;
        public PropertiedObject.Property<String> EXT_ID;
        public PropertiedObject.Property<String> ADDRESS;
        public PropertiedObject.Property AVAILABLE;
        public PropertiedObject.Property<ExtensionType> EXTENSION_TYPE;
        public PersistentObject.DerivedProperty<Boolean> PAY_TABLE_OPEN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)WebPaymentLocation.class), "payTableOpen");
        public PropertiedObject.Property<Long> OM_STORE_ID;
        public PropertiedObject.Property<String> EXTENSION_URL;
        public PropertiedObject.Property<Date> CREATED_DATE;
        public PropertiedObject.Property<Date> UPDATED_DATE;
        public PropertiedObject.Property<BigDecimal> LATITUDE;
        public PropertiedObject.Property<BigDecimal> LONGITUDE;
        public PropertiedObject.Property<Long> UPDATE_INTERVAL;
        public PropertiedObject.Property<WebPaymentIntegration> INTEGRATION;
    }

    public static enum ExtensionType {
        CheckIn,
        PayAtTable,
        CheckInAndPayAtTable;

        public static final Map<String, ExtensionType> register;

        static {
            register = PersistentEnumeration.buildRegister(ExtensionType.values());
        }
    }
}

