/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.internationalization;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_internationalization")
@AccessType(value="property")
public class ConfigInternationalization
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String name;
    private String localeLanguage;
    private String localeMoney;
    private String localeStates;
    private boolean active;
    private String systemState = "ACTIVE";
    private static LocalCacheListManager<ConfigInternationalization> allInternationalizationsListCache = new LocalCacheListManager<ConfigInternationalization>(Query.createQueryList(ConfigInternationalization.class, Query.select(ConfigInternationalization.class)));
    @Transient
    private boolean isUpdating;

    public static final List<ConfigInternationalization> getAllInternationalizations() {
        return allInternationalizationsListCache.getList();
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="locale_language")
    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    @Column(name="locale_money")
    public String getLocaleMoney() {
        return this.localeMoney;
    }

    public void setLocaleMoney(String localeMoney) {
        this.localeMoney = localeMoney;
    }

    public void setLocaleStates(String localeStates) {
        this.localeStates = localeStates;
    }

    @Column(name="locale_states")
    public String getLocaleStates() {
        return this.localeStates;
    }

    @Column(name="active")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public void save(boolean validateOthers) {
        this.isUpdating = !validateOthers;
        try {
            this.save();
        }
        finally {
            this.isUpdating = false;
        }
    }

    @Override
    public void save() {
        if (this.isActive()) {
            this.validateOtherLocaleSettings(this);
        }
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOtherLocaleSettings(ConfigInternationalization currentLocale) {
        if (this.isUpdating) {
            return;
        }
        try {
            this.isUpdating = true;
            for (ConfigInternationalization locale : PersistenceManager.getObjectList(ConfigInternationalization.class, Query.select(ConfigInternationalization.class).toString())) {
                if (locale.equals(currentLocale) || !locale.isActive()) continue;
                locale.setActive(false);
                locale.save();
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    public static void clearCaches() {
        allInternationalizationsListCache.clearCache();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> LOCALE_LANGUAGE;
        public PropertiedObject.Property<String> LOCALE_MONEY;
        public PropertiedObject.Property<String> LOCALE_STATES;
        public PropertiedObject.Property<Boolean> ACTIVE;
        public PropertiedObject.Property<String> SYSTEM_STATE;
    }
}

