/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.util.image.IconLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.sales.AccountType;

class CacheMenuTask
extends AbstractTask {
    private int numGroupsDownload;
    private Terminal cacheTerminal;

    public CacheMenuTask(int numGroups, Terminal newCacheTerminal) {
        this.cacheTerminal = newCacheTerminal;
        this.numGroupsDownload = numGroups;
    }

    @Override
    public int getTotalSubTasks() {
        return this.numGroupsDownload;
    }

    @Override
    public String getName() {
        return "Downloading Menu";
    }

    @Override
    public Icon getIcon() {
        return IconLoader.get("/ordermate/images/DownloadMenu.png");
    }

    private void preloadCompressedOnServer() throws Exception {
        HashMap<InventoryProfile, List<InventoryGroup>> newCache = new HashMap<InventoryProfile, List<InventoryGroup>>();
        Map<InventoryProfile, List<InventoryItem>> newQuickItemCache = new HashMap<InventoryProfile, List<InventoryItem>>();
        List<AccountType> accountTypes = this.cacheTerminal.getSupportedAccountTypes();
        InventoryProfileHelper.getInstance().cacheTerminalProfiles(this.cacheTerminal);
        HashSet<InventoryProfile> profiles = new HashSet<InventoryProfile>();
        for (AccountType type : accountTypes) {
            InventoryProfile profile = InventoryProfileHelper.getInstance().getProfile(type, this.cacheTerminal);
            if (profile == null) continue;
            profiles.add(profile);
        }
        for (InventoryProfile profile : profiles) {
            newQuickItemCache = this.cacheQuickSaleItems(newQuickItemCache, profile);
            List profileGroups = PersistenceManager.getServerConnection().runSync(CacheMenuTask.preloadGroups(profile, profile.isInventoryGroupsPreloaded()));
            newCache.put(profile, profileGroups);
            this.emitProgress();
        }
        InventoryProfileHelper.getInstance().updateCache(newQuickItemCache, newCache, this.cacheTerminal.getLocation());
    }

    @Deprecated
    private void preloadLoadNoCompression() {
        HashMap<InventoryProfile, List<InventoryGroup>> newCache = new HashMap<InventoryProfile, List<InventoryGroup>>();
        Map<InventoryProfile, List<InventoryItem>> newQuickItemCache = new HashMap<InventoryProfile, List<InventoryItem>>();
        List<AccountType> accountTypes = this.cacheTerminal.getSupportedAccountTypes();
        InventoryProfileHelper.getInstance().cacheTerminalProfiles(this.cacheTerminal);
        HashSet<InventoryProfile> profiles = new HashSet<InventoryProfile>();
        for (AccountType type : accountTypes) {
            InventoryProfile profile = InventoryProfileHelper.getInstance().getProfile(type, this.cacheTerminal);
            if (profile == null) continue;
            profiles.add(profile);
        }
        for (InventoryProfile profile : profiles) {
            newQuickItemCache = this.cacheQuickSaleItems(newQuickItemCache, profile);
            List<InventoryGroup> groups = PersistenceManager.getObjectList(InventoryGroup.class, "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.FK_inventory_profile = ? AND inventory_group.FK_inventory_group IS NULL AND inventory_group.system_state = 'ACTIVE' ORDER BY inventory_group.sequence", new Object[]{profile.getID()});
            ArrayList<InventoryGroup> profileGroups = new ArrayList<InventoryGroup>(groups.size());
            newCache.put(profile, profileGroups);
            for (InventoryGroup group : groups) {
                try {
                    group = PersistenceManager.preload(group);
                    CacheMenuTask.expandItems(group);
                    this.emitProgress();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("An error occurred preloading : " + group + ", aborting preload and attempting to continue.", (Throwable)ex);
                }
                profileGroups.add(group);
            }
        }
        InventoryProfileHelper.getInstance().updateCache(newQuickItemCache, newCache, this.cacheTerminal.getLocation());
    }

    @Override
    protected void performTask() throws Exception {
        long start = System.currentTimeMillis();
        if (Config.isConfigSetup() && Config.getBooleanValue("oldSkoolPreload")) {
            this.preloadLoadNoCompression();
        } else {
            this.preloadCompressedOnServer();
        }
        long end = System.currentTimeMillis();
        OrderMate.LOG.info("Cache menu duration : " + (end - start) + "ms");
    }

    private static Executable<List> preloadGroups(InventoryProfile prof, final boolean skipPreloadingInventoryGroups) {
        final Long id = prof.getID();
        if (!prof.isInventoryGroupsPreloaded()) {
            prof.setInventoryGroupsPreloaded(true);
        }
        return new Executable<List>(){

            @Override
            public List execute() {
                List<InventoryGroup> groups = PersistenceManager.getObjectList(InventoryGroup.class, "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.FK_inventory_profile = ? AND inventory_group.FK_inventory_group IS NULL AND inventory_group.system_state = 'ACTIVE' ORDER BY inventory_group.sequence", new Object[]{id});
                ArrayList<InventoryGroup> profileGroups = new ArrayList<InventoryGroup>();
                for (InventoryGroup group : groups) {
                    try {
                        if (!skipPreloadingInventoryGroups) {
                            group = PersistenceManager.preload(group);
                            CacheMenuTask.expandItems(group);
                        }
                        profileGroups.add(group);
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.warn("Exception preloading group", (Throwable)ex);
                    }
                }
                try {
                    return profileGroups;
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Error preloading groups, could not serialize", (Throwable)ex);
                    return null;
                }
            }
        };
    }

    private static void expandItems(InventoryGroup toProcess) {
        for (InventoryGroup subGroup : toProcess.getSubGroups()) {
            CacheMenuTask.expandItems(subGroup);
        }
        for (InventoryItem item : toProcess.getItems()) {
            if (item.getIcon() != null && !item.getIcon().isEmpty()) {
                try {
                    IconLoader.get(item.getIcon());
                }
                catch (IconLoader.IconNotFoundException infe) {
                    OrderMate.LOG.warn("Icon not found in preload " + item.getIcon(), (Throwable)infe);
                }
            }
            CacheManager.getInstance().cacheFreshObject(item);
            for (InventoryItemUnit unit : item.getUnits()) {
                unit.getItem();
                CacheManager.getInstance().cacheFreshObject(unit);
            }
        }
    }

    private Map<InventoryProfile, List<InventoryItem>> cacheQuickSaleItems(Map<InventoryProfile, List<InventoryItem>> newCache, InventoryProfile profile) {
        List<InventoryItem> quickItems = InventoryProfileHelper.getInstance().getQuickSaleItems(profile);
        for (InventoryItem nextItem : quickItems) {
            nextItem.getUnits();
        }
        newCache.put(profile, quickItems);
        return newCache;
    }
}

