/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.sales.AccountType;

@Entity
@Table(name="config_display_profile")
public class ConfigDisplayProfile
extends PersistentObject
implements Saveable {
    public static final String QUERY_GET_ALL_DISPLAYS = "SELECT * FROM config_display_profile WHERE system_state = 'ACTIVE' ORDER BY ID";
    public static final Props Properties = new Props();
    private String displayName;
    private String accountType = AccountType.allType.getType();
    private String systemState = "ACTIVE";
    private Reference<InventoryProfile> inventoryProfile;
    private Reference<TerminalLocation> terminalLocation;

    public ConfigDisplayProfile() {
        this.inventoryProfile = this.createReference(ConfigDisplayProfile.Properties.INVENTORY_PROFILE);
        this.terminalLocation = this.createReference(ConfigDisplayProfile.Properties.TERMINAL_LOCATION);
    }

    @Column(name="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Column(name="account_type")
    public String getAccountType() {
        if (AccountType.allType.getType().equals(this.accountType)) {
            return AccountType.allType.getLabel();
        }
        for (AccountType accType : AccountType.getTypes()) {
            if (!accType.getType().equals(this.accountType)) continue;
            return accType.getLabel();
        }
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        if (accountType.equals(AccountType.allType.getLabel())) {
            this.accountType = AccountType.allType.getType();
        } else {
            for (AccountType accType : AccountType.getTypes()) {
                if (!accType.getLabel().equals(accountType)) continue;
                this.accountType = accType.getType();
                return;
            }
            this.accountType = accountType;
        }
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_profile")
    public InventoryProfile getInventoryProfile() {
        return this.inventoryProfile.get();
    }

    public void setInventoryProfile(InventoryProfile inventoryProfile) {
        this.inventoryProfile.set(inventoryProfile);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getTerminalLocation() {
        return this.terminalLocation.get();
    }

    public void setTerminalLocation(TerminalLocation terminalLocation) {
        this.terminalLocation.set(terminalLocation);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<ConfigDisplayProfile> getAllDisplays() {
        return PersistenceManager.getObjectList(ConfigDisplayProfile.class, QUERY_GET_ALL_DISPLAYS, null);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> DISPLAY_NAME;
        public PropertiedObject.Property<String> ACCOUNT_TYPE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<InventoryProfile> INVENTORY_PROFILE;
        public PropertiedObject.Property<TerminalLocation> TERMINAL_LOCATION;
    }
}

