/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.config.Quantity;
import ordermate.database.finance.CostedItem;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.queries.inventory.InventoryAddQueries;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_add")
@AccessType(value="property")
public class InventoryAdd
extends Modification
implements SaveableChild,
ExportableObject,
StockLinkable<StockUsageAddLink>,
CostedItem {
    public static final Props Properties = new Props();
    private int sequence = 0;
    private String systemState = "ACTIVE";
    private Reference<InventoryAddGroup> addGroup;
    private PersistentWriteableList<StockUsageAddLink> stockUsageLinks;
    private ModificationSize modSize;
    private Long masterId;
    private boolean availableOnline;

    public InventoryAdd() {
        this.addGroup = this.createReference(InventoryAdd.Properties.ADD_GROUP);
        this.stockUsageLinks = this.createWriteableList(InventoryAdd.Properties.STOCK_USAGE_LINKS);
        this.availableOnline = true;
    }

    public InventoryAdd(InventoryAdd toCopy) {
        super(toCopy);
        this.addGroup = this.createReference(InventoryAdd.Properties.ADD_GROUP);
        this.stockUsageLinks = this.createWriteableList(InventoryAdd.Properties.STOCK_USAGE_LINKS);
        this.setLabel(toCopy.getLabel());
        this.setBackgroundColor(toCopy.getBackgroundColor());
        this.setForegroundColor(toCopy.getForegroundColor());
        this.setSequence(toCopy.getSequence());
        this.setPrice(toCopy.getPrice());
        this.setAvailableOnline(toCopy.isAvailableOnline());
        for (Pair<StockItem, Quantity> usage : toCopy.getStockUsage()) {
            this.setStockUsage(usage.getKey(), usage.getValue());
        }
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_add_group")
    public InventoryAddGroup getAddGroup() {
        return this.addGroup.get();
    }

    public void setAddGroup(InventoryAddGroup group) {
        this.addGroup.set(group);
    }

    @Transient
    public List<StockUsageAddLink> getStockUsageLinks() {
        return this.stockUsageLinks.getUnmodifiable();
    }

    public void setSystemState(String value) {
        this.systemState = value;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Override
    @Transient
    public ModificationSize getModificationSize() {
        if (this.modSize == null) {
            this.modSize = ModificationSize.getDefaultSize();
        }
        return this.modSize;
    }

    @Override
    public void setModificationSize(ModificationSize newModSize) {
        this.modSize = newModSize;
    }

    public static InventoryAdd getInventoryAdd(String name, InventoryItemSize size) {
        return PersistenceManager.getObject(InventoryAdd.class, InventoryAddQueries.QUERY_GET_BY_NAME_SIZE.toString(), new Object[]{name, size.getID()});
    }

    @Override
    public void deleteChild() {
        this.setSystemState("DELETED");
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.modSize == null) {
            this.modSize = ModificationSize.getDefaultSize();
        }
        PersistenceManager.saveChild(this);
        this.stockUsageLinks.saveChild();
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public void setStockUsage(List stockUsage) {
        this.stockUsageLinks = this.stockUsageLinks.clone();
        this.stockUsageLinks.set(stockUsage);
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        return StockLinkable.StockLinkableHelper.getOnHandCost(null, this, false);
    }

    @Override
    @Transient
    public Price getIngredientCostIncTax() {
        Price costInc = Price.ZERO_DOLLAR;
        for (StockLink stockLink : this.getStockLinks()) {
            costInc = costInc.add(new Price(stockLink.calculateStockItemLinkCost(null, true, true), 1.0E-6));
        }
        return costInc;
    }

    @Override
    public void clearStockUsage() {
        this.stockUsageLinks.clear();
    }

    @Transient
    public boolean isProfitable() {
        double cost = this.getIngredientCostExTax().doubleValue();
        double sales = this.getModificationPrice().doubleValue();
        return cost == 0.0 || cost < sales;
    }

    @Override
    @Transient
    public List<StockUsageAddLink> getStockLinks() {
        return this.stockUsageLinks.getUnmodifiable();
    }

    @Transient
    public List<Pair<StockItem, Quantity>> getStockUsage() {
        return StockLinkable.StockLinkableHelper.getStockUsage(this);
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount) {
        this.setStockUsage(item, amount, false, false);
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount, boolean isFixedQty, boolean isRemoveable) {
        if (StockLinkable.StockLinkableHelper.updateExistingStockUsage(this, item, amount)) {
            return;
        }
        StockUsageAddLink stockAddUsage = new StockUsageAddLink(item, this, amount);
        stockAddUsage.setFixedQuantity(isFixedQty);
        this.stockUsageLinks.add(stockAddUsage);
    }

    @Override
    public boolean removeStockLink(StockLink link) {
        return this.stockUsageLinks.remove(link);
    }

    @Override
    public void collapseStockLinks() {
        this.stockUsageLinks.collapseUnsafe();
    }

    @Column(name="available_online")
    public boolean isAvailableOnline() {
        return this.availableOnline;
    }

    public void setAvailableOnline(boolean availableOnline) {
        this.availableOnline = availableOnline;
    }

    public static class Props
    extends Modification.Props {
        public PropertiedObject.Property<InventoryAddGroup> ADD_GROUP;
        public PropertiedObject.Property<StockUsageAddLink> STOCK_USAGE_LINKS;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property AVAILABLE_ONLINE;
    }
}

