/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.ModificationGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_add_group")
@AccessType(value="property")
public class InventoryAddGroup
extends ModificationGroup
implements Inventory {
    public static final Props Properties = new Props();
    private PersistentWriteableList<InventoryAdd> adds;

    public InventoryAddGroup() {
        this.adds = (PersistentWriteableList)this.createList(InventoryAddGroup.Properties.ADDS);
    }

    @Override
    @Transient
    public List<InventoryAdd> getModifications() {
        return this.adds.getUnmodifiable();
    }

    @Override
    public void save() {
        super.save();
        this.adds.saveChild();
    }

    public static InventoryAddGroup findModificationGroup(String groupName, InventoryItemSize size) {
        String sql = Query.select(InventoryAddGroup.class).active(InventoryAddGroup.class).equals(InventoryAddGroup.Properties.LABEL, groupName).equals(InventoryAddGroup.Properties.SIZE, size.getID()).toString();
        return PersistenceManager.getObject(InventoryAddGroup.class, sql, new Object[0]);
    }

    public static List<InventoryAddGroup> getAllAddGroups() {
        String sql = Query.select(InventoryAddGroup.class).active(InventoryAddGroup.class).toString();
        return PersistenceManager.getObjectList(InventoryAddGroup.class, sql, new Object[0]);
    }

    @Override
    public String toString() {
        String size = null;
        if (this.getSize() != null) {
            size = !this.getSize().getShortName().isEmpty() ? this.getSize().getShortName() : this.getSize().getLabel();
        }
        if (size != null) {
            return this.getLabel() + "(" + size + ")";
        }
        return this.getLabel();
    }

    @OneToMany(mappedBy="addGroup", targetEntity=InventoryAdd.class, cascade={CascadeType.ALL})
    @Where(clause="system_state = 'ACTIVE'")
    protected List<InventoryAdd> getAdds() {
        return this.adds;
    }

    protected void setAdds(List<InventoryAdd> newAdds) {
        this.adds = this.adds.clone();
        this.adds.set(newAdds);
    }

    public void addInventoryAdd(InventoryAdd add) {
        if (add != null) {
            if (this.adds.contains(add)) {
                this.adds.remove(add);
            }
            this.adds.add(add);
        }
    }

    public void removeInventoryAdd(InventoryAdd toRemove) {
        this.adds.remove(toRemove);
    }

    @Override
    public void delete() {
        super.delete();
        this.adds.deleteChild();
    }

    public static class Props
    extends ModificationGroup.Props {
        public PropertiedObject.Property<InventoryAdd> ADDS;
    }
}

