/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.InventoryItemUnitBarcodeLink;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.inventory.InventoryBarcodeQueries;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_item_unit_barcodes")
@AccessType(value="property")
public class InventoryBarcode
extends PersistentObject
implements Saveable,
Displayable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private String barcode = "";
    private PersistentWriteableList<InventoryItemUnitBarcodeLink> itemUnitLinks;

    public InventoryBarcode() {
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryBarcode.Properties.ITEM_UNIT_LINKS);
    }

    public InventoryBarcode(String newBarcode) {
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryBarcode.Properties.ITEM_UNIT_LINKS);
        this.barcode = newBarcode;
    }

    public static InventoryBarcode getBarcode(String barcode) {
        return InventoryBarcodeQueries.getBarcode(barcode);
    }

    @Column(name="barcode")
    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String newBarcode) {
        this.barcode = newBarcode;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Transient
    public List<InventoryItemUnit> getItemUnits() {
        ArrayList<InventoryItemUnit> units = new ArrayList<InventoryItemUnit>(this.getItemUnitLinks().size());
        for (InventoryItemUnitBarcodeLink link : this.getItemUnitLinks()) {
            units.add(link.getItemUnit());
        }
        return units;
    }

    @OneToMany(mappedBy="barcode", targetEntity=InventoryItemUnitBarcodeLink.class)
    protected List<InventoryItemUnitBarcodeLink> getItemUnitLinks() {
        return this.itemUnitLinks;
    }

    protected void setItemUnitLinks(List<InventoryItemUnitBarcodeLink> itemUnitLinks) {
        this.itemUnitLinks = this.itemUnitLinks.clone();
        this.itemUnitLinks.set(itemUnitLinks);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return null;
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getBarcode();
    }

    public boolean matches(String code) {
        return this.getBarcode().equalsIgnoreCase(code);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property BARCODE;
        public PropertiedObject.Property<InventoryItemUnitBarcodeLink> ITEM_UNIT_LINKS;
    }
}

