/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.Inventory;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExportManager;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="inventory_category")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryCategory
extends PersistentDisplayableObject
implements Saveable,
GLAccountCode,
Inventory,
ExportableObject,
Sequenced {
    public static final Props Properties = new Props();
    private String externalID;
    private String systemState;
    private int sequence;
    private boolean keyCategory;
    private Long masterId;
    private Reference<GLAccount> glAccount;
    private static InventoryCategory defaultCategory;
    private static final String NOT_ALLOCATED_CATEGORY = "Not allocated";

    public InventoryCategory() {
        this.glAccount = this.createReference(InventoryCategory.Properties.GL_ACCOUNT);
        this.systemState = "ACTIVE";
    }

    public InventoryCategory(String name) {
        this.glAccount = this.createReference(InventoryCategory.Properties.GL_ACCOUNT);
        this.systemState = "ACTIVE";
        this.setLabel(name);
    }

    @Transient
    public String getName() {
        return this.getLabel();
    }

    public void setName(String name) {
        this.setLabel(name);
    }

    @Column(name="external_id")
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public boolean isDeleted() {
        return this.systemState.equals("DELETED");
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
        OfficeMateEventLog.logDeleteMenuCategory(User.getSystemUser(), this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        OfficeMateEventLog.logCreateMenuCategory(User.getSystemUser(), this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<InventoryCategory> getAllCategories() {
        return PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).active(InventoryCategory.class).orderBy(InventoryCategory.Properties.SEQUENCE).orderBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.ID).toString(), null);
    }

    public static List<InventoryCategory> getAllCategoriesIncDeleted() {
        return PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).orderBy(InventoryCategory.Properties.SEQUENCE).orderBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.ID).toString(), null);
    }

    public static List<InventoryCategory> getKeyCategories() {
        return PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).active(InventoryCategory.class).equals(InventoryCategory.Properties.KEY_CATEGORY, "1").toString());
    }

    public static InventoryCategory getCategoryForName(String name) {
        return PersistenceManager.getObject(InventoryCategory.class, "SELECT * FROM inventory_category WHERE system_state = 'ACTIVE' AND Name = ? ", new Object[]{name});
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_acc_gl_account")
    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    public void setGlAccount(GLAccount glAccount) {
        this.glAccount.set(glAccount);
    }

    @Override
    @Transient
    public String getGlAccountCode() {
        if (this.glAccount == null || this.glAccount.get() == null || this.glAccount.get().getGlCode().equalsIgnoreCase("")) {
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode().getGlCode();
        }
        return this.glAccount.get().getGlCode();
    }

    protected void setExternalID(String extID) {
        this.externalID = extID;
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    @Column(name="key_category")
    public boolean isKeyCategory() {
        return this.keyCategory;
    }

    public void setKeyCategory(boolean isKeyCategory) {
        this.keyCategory = isKeyCategory;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Transient
    public static InventoryCategory getDefaultCategory() {
        if (defaultCategory == null && (defaultCategory = PersistenceManager.getObject(InventoryCategory.class, Query.select(InventoryCategory.class).wherePropertyLike(InventoryCategory.Properties.LABEL, NOT_ALLOCATED_CATEGORY).limit(1).toString())) == null) {
            defaultCategory = new InventoryCategory("(Not allocated)");
            defaultCategory.save();
        }
        return defaultCategory;
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property EXTERNAL_ID;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property KEY_CATEGORY;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

