/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.Modification;

@Entity
@DiscriminatorValue(value="Option")
public class InventoryDefaultOption
extends InventoryDefaultMod {
    public static final Props Properties = new Props();
    private Reference<InventoryOption> option;

    public InventoryDefaultOption() {
        this.option = this.createReference(InventoryDefaultOption.Properties.OPTION);
    }

    public InventoryDefaultOption(InventoryItemUnit yourUnit, InventoryOption yourOption) {
        super(yourUnit);
        this.option = this.createReference(InventoryDefaultOption.Properties.OPTION);
        this.setOption(yourOption);
    }

    @ManyToOne
    @JoinColumn(name="fk_modification")
    public InventoryOption getOption() {
        return this.option.get();
    }

    public void setOption(InventoryOption value) {
        this.option.set(value);
    }

    @Override
    @Transient
    public Modification getDefaultMod() {
        return this.getOption();
    }

    @Override
    public String toString() {
        return this.getOption() == null ? "No Option" : this.getOption().toString();
    }

    public static class Props
    extends InventoryDefaultMod.Props {
        public PropertiedObject.Property<InventoryOption> OPTION;
    }
}

