/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.guicore.TreeNodeSupport;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.tree.TreeNode;
import ordermate.OrderMate;
import ordermate.database.Sequenced;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroupTriggerLink;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.stock.StockArea;
import ordermate.database.users.PermissionGroup;
import ordermate.integration.finance.AccountingExportManager;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_group")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryGroup
extends PersistentDisplayableObject
implements Saveable,
GLAccountCode,
Inventory,
TriggerActivated,
TreeNode,
ExportableObject {
    public static final Props Properties = new Props();
    private static final TreeNodeSupport treeNodeSupport = new TreeNodeSupport(InventoryGroup.Properties.PARENT_GROUP, InventoryGroup.Properties.SUB_GROUPS);
    private PersistentWriteableList<InventoryItem> menuItems;
    private PersistentList<InventoryItem> allItems;
    private PersistentWriteableList<InventoryGroup> subGroups;
    private PersistentWriteableList<InventoryCombo> combos;
    private Reference<InventoryCategory> defaultCategory;
    private Reference<InventoryGroup> parentGroup;
    private Reference<InventoryProfile> profile;
    private Reference<PermissionGroup> permissionGroup;
    private String externalID;
    private String systemState;
    private Reference<GLAccount> glAccount;
    private PersistentWriteableList<DecrementStockArea> decrementStock;
    private Integer sequence;
    private PersistentWriteableList<InventoryGroupTriggerLink> triggerLinks;
    private TriggerActivationStrategy triggerActivationStrategy;
    private transient InventoryGroup root;
    private Long masterId;

    public InventoryGroup() {
        this.menuItems = (PersistentWriteableList)this.createList(InventoryGroup.Properties.MENU_ITEMS);
        this.allItems = this.createList(InventoryGroup.Properties.ALL_ITEMS);
        this.subGroups = (PersistentWriteableList)this.createList(InventoryGroup.Properties.SUB_GROUPS);
        this.combos = (PersistentWriteableList)this.createList(InventoryGroup.Properties.COMBOS);
        this.defaultCategory = this.createReference(InventoryGroup.Properties.DEFAULT_CATEGORY);
        this.parentGroup = this.createReference(InventoryGroup.Properties.PARENT_GROUP);
        this.profile = this.createReference(InventoryGroup.Properties.PROFILE);
        this.permissionGroup = this.createReference(InventoryGroup.Properties.PERMISSION_GROUP);
        this.systemState = "ACTIVE";
        this.glAccount = this.createReference(InventoryGroup.Properties.GL_ACCOUNT);
        this.decrementStock = (PersistentWriteableList)this.createList(InventoryGroup.Properties.DECREMENT_STOCK);
        this.sequence = 0;
        this.triggerLinks = (PersistentWriteableList)this.createList(InventoryGroup.Properties.TRIGGER_LINKS);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    }

    public InventoryGroup(InventoryGroup toCopy, InventoryProfile profileToCopyInto) {
        super(toCopy);
        this.menuItems = (PersistentWriteableList)this.createList(InventoryGroup.Properties.MENU_ITEMS);
        this.allItems = this.createList(InventoryGroup.Properties.ALL_ITEMS);
        this.subGroups = (PersistentWriteableList)this.createList(InventoryGroup.Properties.SUB_GROUPS);
        this.combos = (PersistentWriteableList)this.createList(InventoryGroup.Properties.COMBOS);
        this.defaultCategory = this.createReference(InventoryGroup.Properties.DEFAULT_CATEGORY);
        this.parentGroup = this.createReference(InventoryGroup.Properties.PARENT_GROUP);
        this.profile = this.createReference(InventoryGroup.Properties.PROFILE);
        this.permissionGroup = this.createReference(InventoryGroup.Properties.PERMISSION_GROUP);
        this.systemState = "ACTIVE";
        this.glAccount = this.createReference(InventoryGroup.Properties.GL_ACCOUNT);
        this.decrementStock = (PersistentWriteableList)this.createList(InventoryGroup.Properties.DECREMENT_STOCK);
        this.sequence = 0;
        this.triggerLinks = (PersistentWriteableList)this.createList(InventoryGroup.Properties.TRIGGER_LINKS);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.externalID = toCopy.externalID;
        this.sequence = toCopy.sequence;
        this.systemState = toCopy.systemState;
        this.glAccount = toCopy.glAccount;
        this.defaultCategory = toCopy.defaultCategory;
        this.profile.set(profileToCopyInto);
        this.permissionGroup.set(toCopy.permissionGroup.get());
        for (InventoryItem item : toCopy.menuItems) {
            this.menuItems.add(new InventoryItem(item));
        }
        for (InventoryCombo combo : toCopy.combos) {
            InventoryCombo copy = combo.copy(profileToCopyInto);
            this.combos.add(copy);
        }
    }

    @Transient
    public String getUserVisibleLabel() {
        return "Menu Section";
    }

    @Transient
    public List<InventoryItem> getItems() {
        return this.menuItems.getUnmodifiable();
    }

    public void addItem(InventoryItem toAdd) {
        if (toAdd != null) {
            this.menuItems.add(toAdd);
        }
    }

    @OneToMany(mappedBy="menuGroup", targetEntity=InventoryItem.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<InventoryItem> getAllItems() {
        return this.allItems.getUnmodifiable();
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_profile")
    public InventoryProfile getProfile() {
        return this.profile.get();
    }

    public void setProfile(InventoryProfile newProfile) {
        this.profile.set(newProfile);
    }

    @Column(name="external_id")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String extID) {
        this.externalID = extID;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        return 0;
    }

    public void setSequence(int theSequence) {
        this.sequence = theSequence;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public boolean isActive() {
        return "ACTIVE".equals(this.systemState);
    }

    public void setActive(boolean active) {
        this.systemState = active ? "ACTIVE" : "INACTIVE";
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_acc_gl_account")
    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    @Override
    @Transient
    public String getGlAccountCode() {
        if (this.glAccount.get() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().getGlAccountCode();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode().getGlCode();
        }
        return this.glAccount.get().getGlCode();
    }

    @Transient
    public GLAccount getGlAccountOrDefault() {
        if (this.glAccount.get() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().getGlAccountOrDefault();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode();
        }
        return this.glAccount.get();
    }

    @Transient
    public GLAccount getMYOBAccount() {
        if (this.glAccount.get() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().getMYOBAccount();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeAccount();
        }
        return this.glAccount.get();
    }

    public void setGlAccount(GLAccount glAccount) {
        this.glAccount.set(glAccount);
    }

    public synchronized List<InventoryItem> getItems(InventoryItemPortion portion, InventoryItemSize size) {
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        for (InventoryItem item : this.menuItems) {
            boolean found = false;
            Iterator<InventoryItemUnit> subIterator = item.getUnits().iterator();
            while (subIterator.hasNext() && !found) {
                InventoryItemUnit unit = subIterator.next();
                if (!unit.getPortion().equals(portion) || !unit.getSize().equals(size)) continue;
                items.add(item);
                found = true;
            }
        }
        return items;
    }

    public boolean hasCombos() {
        return !this.combos.isEmpty();
    }

    public boolean hasItems() {
        return !this.allItems.isEmpty();
    }

    public boolean hasContent() {
        return this.hasItems() || this.hasCombos();
    }

    @OneToMany(mappedBy="menuGroup", targetEntity=InventoryCombo.class, fetch=FetchType.LAZY)
    @Where(clause="system_state = 'ACTIVE'")
    public List<InventoryCombo> getCombos() {
        return this.combos.getUnmodifiable();
    }

    public void addCombo(InventoryCombo combo) {
        if (combo != null) {
            this.combos.add(combo);
        }
    }

    public Collection<InventoryCombo> getActiveCombos(TriggerActivationContext context) {
        return TriggerActivationHelper.getActive(this.getCombos(), context);
    }

    @Transient
    public InventoryGroup getRootGroup() {
        if (this.root == null) {
            this.root = this;
            while (this.root.getParentGroup() != null) {
                this.root = this.root.getParentGroup();
            }
        }
        return this.root;
    }

    @Transient
    public List<InventoryGroup> getParentGroups() {
        ArrayList<InventoryGroup> retValue = new ArrayList<InventoryGroup>();
        InventoryGroup group = this;
        while (group.getParentGroup() != null) {
            group = group.getParentGroup();
            retValue.add(group);
        }
        return retValue;
    }

    public boolean isParent(InventoryGroup aGroup) {
        InventoryGroup group = aGroup;
        while (group.getParentGroup() != null) {
            if (!(group = group.getParentGroup()).equals(this)) continue;
            return true;
        }
        return false;
    }

    @OneToMany(mappedBy="parentGroup", targetEntity=InventoryGroup.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Where(clause="system_state = 'ACTIVE'")
    public List<InventoryGroup> getSubGroups() {
        return this.subGroups.getUnmodifiable();
    }

    public Collection getActiveSubgroups(TriggerActivationContext context) {
        return TriggerActivationHelper.getActive(this.getSubGroups(), context);
    }

    public void addSubGroup(InventoryGroup groupToAdd) {
        if (groupToAdd != null) {
            this.subGroups.add(groupToAdd);
        }
    }

    @Transient
    public List<InventoryGroup> getAvailableSubGroups() {
        ArrayList<String> states = new ArrayList<String>();
        states.add("INACTIVE");
        states.add("ACTIVE");
        String sql = Query.select(InventoryGroup.class).wherePropertyIn(InventoryGroup.Properties.SYSTEM_STATE, states).equals(InventoryGroup.Properties.PARENT_GROUP, this.getID()).orderBy(InventoryGroup.Properties.SEQUENCE).toString();
        return PersistenceManager.getObjectList(InventoryGroup.class, sql, null);
    }

    @Transient
    public List<InventoryGroup> getRecursiveSubGroups() {
        ArrayList<InventoryGroup> allSubGroups = new ArrayList<InventoryGroup>();
        for (InventoryGroup group : this.getSubGroups()) {
            allSubGroups.add(group);
            allSubGroups.addAll(group.getRecursiveSubGroups());
        }
        return allSubGroups;
    }

    @Transient
    public List<InventoryItem> getRecursiveItems() {
        ArrayList<InventoryItem> allTheItems = new ArrayList<InventoryItem>();
        allTheItems.addAll(this.getItems());
        for (InventoryGroup group : this.getRecursiveSubGroups()) {
            allTheItems.addAll(group.getItems());
        }
        return allTheItems;
    }

    public boolean hasSubGroups() {
        return this.subGroups.size() > 0;
    }

    @Transient
    public boolean isTopLevelGroup() {
        return this.getParentGroup() == null;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getParentGroup() {
        return this.parentGroup.get();
    }

    public void setParentGroup(InventoryGroup parent) {
        this.parentGroup.set(parent);
    }

    @Transient
    public int getDepth() {
        if (this.isTopLevelGroup()) {
            return 0;
        }
        return this.getParentGroup().getDepth() + 1;
    }

    public List<StockArea> getDecrementStockAreasForAllItems(Terminal terminal) {
        HashSet<StockArea> stockAreas = new HashSet<StockArea>();
        Stack<InventoryGroup> groups = new Stack<InventoryGroup>();
        groups.push(this);
        while (!groups.isEmpty()) {
            InventoryGroup group = (InventoryGroup)groups.pop();
            for (InventoryItem item : group.getItems()) {
                stockAreas.add(item.getDecrementStockArea(terminal));
            }
            Iterator<InventoryGroup> iterator = group.getSubGroups().iterator();
            while (iterator.hasNext()) {
                groups.push(iterator.next());
            }
        }
        return new ArrayList<StockArea>(stockAreas);
    }

    @Transient
    public List getCategoriesForAllItems() {
        HashSet<InventoryCategory> categories = new HashSet<InventoryCategory>();
        Stack<InventoryGroup> groups = new Stack<InventoryGroup>();
        groups.push(this);
        while (!groups.isEmpty()) {
            InventoryGroup group = (InventoryGroup)groups.pop();
            for (InventoryItem item : group.getItems()) {
                categories.add(item.getCategory());
            }
            Iterator<InventoryGroup> iterator = group.getSubGroups().iterator();
            while (iterator.hasNext()) {
                groups.push(iterator.next());
            }
        }
        return new ArrayList(categories);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_category")
    public InventoryCategory getDefaultCategory() {
        return this.defaultCategory.get();
    }

    public void setDefaultCategory(InventoryCategory category) {
        this.defaultCategory.set(category);
    }

    public void setCategoryForAllItems(InventoryCategory category) {
        this.setDefaultCategory(category);
        Stack<InventoryGroup> groups = new Stack<InventoryGroup>();
        groups.push(this);
        while (!groups.isEmpty()) {
            InventoryGroup group = (InventoryGroup)groups.pop();
            for (InventoryItem item : group.getItems()) {
                item.setCategory(category);
                item.save();
            }
            Iterator<InventoryGroup> iterator = group.getSubGroups().iterator();
            while (iterator.hasNext()) {
                groups.push(iterator.next());
            }
        }
    }

    public StockArea getDefaultDecrementStockArea(Terminal terminal) {
        if (terminal == null) {
            OrderMate.LOG.error("Null terminal passed to determine the default decrement stock area.");
            if (this.decrementStock.isEmpty()) {
                List<StockArea> areas = StockArea.getStockAreas();
                if (areas.size() > 0) {
                    return areas.get(0);
                }
                OrderMate.LOG.warn("No Stock Areas can be found in the system.");
                return null;
            }
            return ((DecrementStockArea)this.decrementStock.get(0)).getStockArea();
        }
        StockArea area = null;
        for (DecrementStockArea dec : this.decrementStock) {
            if (!terminal.equals(dec.getTerminal())) continue;
            return dec.getStockArea();
        }
        if (area == null) {
            area = terminal.getStockArea();
        }
        return area;
    }

    public void setDefaultDecrementStockArea(Terminal terminal, StockArea area) {
        ArrayList<DecrementStockArea> toRemove = new ArrayList<DecrementStockArea>(this.decrementStock.size());
        boolean alreadyExisting = false;
        for (DecrementStockArea decrementStockArea : this.decrementStock) {
            if (!terminal.equals(decrementStockArea.getTerminal())) continue;
            if (area == null || !decrementStockArea.getStockArea().equals(area)) {
                toRemove.add(decrementStockArea);
            }
            if (!decrementStockArea.getStockArea().equals(area)) continue;
            alreadyExisting = true;
        }
        this.decrementStock.removeAll(toRemove);
        if (!alreadyExisting && area != null) {
            DecrementStockArea dec = new DecrementStockArea(this, area, terminal);
            this.decrementStock.add(dec);
        }
        this.setSubgroupDecrementStockArea(terminal, area);
        this.removeAllItemDecStockAreaLinks(terminal);
    }

    private void setSubgroupDecrementStockArea(Terminal terminal, StockArea area) {
        for (InventoryGroup subGroup : this.getSubGroups()) {
            subGroup.setDecrementStockAreaForAllItems(terminal, area);
        }
    }

    private void removeAllItemDecStockAreaLinks(Terminal terminal) {
        for (InventoryItem item : this.getAllItems()) {
            item.setDefaultDecrementStockArea(terminal, null);
            item.save();
        }
    }

    public void setDefaultDecrementStockArea(StockArea area) {
        for (Terminal terminal : Terminal.getAllTerminalsExceptServer()) {
            this.setDefaultDecrementStockArea(terminal, area);
        }
    }

    @Transient
    public List<DecrementStockArea> getDecrementStockAreas() {
        return this.decrementStock.getUnmodifiable();
    }

    public void setDecrementStockAreaForAllItems(Terminal terminal, StockArea area) {
        this.setDefaultDecrementStockArea(terminal, area);
    }

    public void setDecrementStockAreaForAllItems(StockArea area) {
        List<Terminal> allTerminals = Terminal.getAllTerminalsExceptServer();
        for (Terminal terminal : allTerminals) {
            this.setDecrementStockAreaForAllItems(terminal, area);
        }
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Transient
    public String getLabelFull() {
        if (this.getParentGroup() == null) {
            return this.getLabel();
        }
        return this.getParentGroup().getLabelFull() + "/" + this.getLabel();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        for (InventoryGroup grp : this.subGroups) {
            grp.delete();
        }
        for (InventoryItem item : this.menuItems) {
            item.delete();
        }
        for (InventoryCombo combo : this.combos) {
            combo.delete();
        }
        this.decrementStock.deleteChild();
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.subGroups.hasChildChanged() || this.menuItems.hasChildChanged();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        DefaultTrigger dftTrigger;
        PersistenceManager.save(this);
        this.subGroups.saveChild();
        this.menuItems.saveChild();
        this.combos.saveChild();
        this.decrementStock.saveChild();
        if (this.triggerLinks.isEmpty() && (dftTrigger = AbstractTrigger.getDefaultTriggerIfExists()) != null) {
            this.addTrigger(dftTrigger);
        }
        this.triggerLinks.saveChild();
    }

    public static InventoryGroup findInventoryGroup(InventoryProfile profile, String name) {
        return PersistenceManager.getObject(InventoryGroup.class, "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.system_state = 'ACTIVE' AND inventory_group.name = ? AND inventory_group.FK_inventory_profile = ?", new Object[]{name, profile.getID()});
    }

    public static InventoryGroup parseInventoryGroup(String name, InventoryProfile profile) {
        InventoryGroup upperGroup = null;
        StringTokenizer st = new StringTokenizer(name, "/\\");
        while (st.hasMoreTokens()) {
            String group = st.nextToken().trim();
            InventoryGroup invGroup = InventoryGroup.findInventoryGroup(profile, group);
            if (invGroup == null) {
                invGroup = new InventoryGroup();
                invGroup.setLabel(group);
                invGroup.setProfile(profile);
                invGroup.addTrigger(AbstractTrigger.getDefaultTriggerIfExists());
            }
            if (upperGroup != null && !upperGroup.getSubGroups().contains(invGroup)) {
                upperGroup.addSubGroup(invGroup);
            }
            upperGroup = invGroup;
        }
        return upperGroup;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger triggerToAdd) {
        if (triggerToAdd == null) {
            throw new IllegalArgumentException("Cannot add a null trigger to the group " + this);
        }
        if (!this.getTriggers().contains(triggerToAdd)) {
            InventoryGroupTriggerLink link = new InventoryGroupTriggerLink(triggerToAdd, this);
            this.triggerLinks.add(link);
            return link;
        }
        return null;
    }

    @Override
    public boolean removeTrigger(AbstractTrigger triggerToRemove) {
        boolean removed = false;
        Iterator iter = this.triggerLinks.iterator();
        while (iter.hasNext()) {
            InventoryGroupTriggerLink link = (InventoryGroupTriggerLink)iter.next();
            if (!link.getTrigger().equals(triggerToRemove)) continue;
            link.deleteChild();
            iter.remove();
            removed = true;
        }
        return removed;
    }

    @OneToMany(mappedBy="inventoryGroup", targetEntity=InventoryGroupTriggerLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<InventoryGroupTriggerLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    public void setTriggerLinks(List<InventoryGroupTriggerLink> linksList) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(linksList);
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation_strategy")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        assert (this.triggerActivationStrategy != null) : "Trigger activation strategy should not be null";
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy newStrategy) {
        assert (newStrategy != null) : "Strategy should not be null";
        this.triggerActivationStrategy = newStrategy;
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggerSet = new ArrayList<AbstractTrigger>();
        for (InventoryGroupTriggerLink link : this.triggerLinks) {
            triggerSet.add(link.getTrigger());
        }
        return new ArrayList<AbstractTrigger>(triggerSet);
    }

    public void setTriggers(List newTriggers) {
        Object[] allLinks = this.triggerLinks.toArray();
        for (int i = 0; i < allLinks.length; ++i) {
            this.removeTrigger(((InventoryGroupTriggerLink)allLinks[i]).getTrigger());
        }
        Iterator it = newTriggers.iterator();
        while (it.hasNext()) {
            this.addTrigger((AbstractTrigger)it.next());
        }
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.getTriggerActivationStrategy().isActive(this, context);
    }

    public int compareTo(Object arg0) {
        return Sequenced.SequenceComparator.getInst().compare(this, arg0);
    }

    public boolean isAncestorOf(InventoryGroup menuGroup) {
        return menuGroup != null && menuGroup.getParentGroups().contains(this);
    }

    public Enumeration children() {
        return treeNodeSupport.children(this);
    }

    @Override
    @Transient
    public boolean getAllowsChildren() {
        return treeNodeSupport.getAllowsChildren();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return treeNodeSupport.getChildAt(this, childIndex);
    }

    @Override
    @Transient
    public int getChildCount() {
        return treeNodeSupport.getChildCount(this);
    }

    @Override
    public int getIndex(TreeNode node) {
        return treeNodeSupport.getIndex(this, node);
    }

    @Override
    @Transient
    public TreeNode getParent() {
        return treeNodeSupport.getParent(this);
    }

    @Override
    @Transient
    public boolean isLeaf() {
        return treeNodeSupport.isLeaf(this);
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_background")
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_foreground")
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    @Override
    @Column(name="icon")
    public String getIcon() {
        return super.getIcon();
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="fk_config_permission_group")
    public PermissionGroup getPermissionGroup() {
        return this.permissionGroup.get();
    }

    public void setPermissionGroup(PermissionGroup group) {
        this.permissionGroup.set(group);
    }

    public boolean canModify(PermissionGroup toTest) {
        if (toTest == null) {
            return false;
        }
        if (this.getPermissionGroup() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().canModify(toTest);
            }
            return true;
        }
        return this.getPermissionGroup().getLevel() <= toTest.getLevel();
    }

    @Override
    public void setBackgroundColor(Color newBackgroundColor) {
        super.setBackgroundColor(newBackgroundColor);
    }

    @Override
    public void setForegroundColor(Color newForegroundColor) {
        super.setForegroundColor(newForegroundColor);
    }

    @Override
    public void setIcon(String newIcon) {
        super.setIcon(newIcon);
    }

    protected void setAllItems(List<InventoryItem> newItems) {
        this.allItems = this.allItems.clone();
        this.allItems.set(newItems);
    }

    protected void setCombos(List<InventoryCombo> newCombos) {
        this.combos = this.combos.clone();
        this.combos.set(newCombos);
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    protected void setSubGroups(List<InventoryGroup> newSubGroups) {
        this.subGroups = this.subGroups.clone();
        this.subGroups.set(newSubGroups);
    }

    @OneToMany(mappedBy="menuGroup", targetEntity=InventoryItem.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Where(clause="system_state = 'ACTIVE'")
    protected List<InventoryItem> getMenuItems() {
        return this.menuItems;
    }

    protected void setMenuItems(List<InventoryItem> newMenuItems) {
        this.menuItems = this.menuItems.clone();
        this.menuItems.set(newMenuItems);
    }

    @Transient
    protected List<DecrementStockArea> getDecrementStock() {
        return this.decrementStock;
    }

    protected void setDecrementStock(List<DecrementStockArea> newDecrementStock) {
        this.decrementStock = this.decrementStock.clone();
        this.decrementStock.set(newDecrementStock);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Transient
    public List<InventoryItemUnit> getItemUnits() {
        ArrayList<InventoryItemUnit> units = new ArrayList<InventoryItemUnit>();
        for (InventoryItem invItem : this.getItems()) {
            units.addAll(invItem.getUnits());
        }
        return units;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<InventoryItem> MENU_ITEMS;
        public PropertiedObject.Property<InventoryGroup> SUB_GROUPS;
        public PropertiedObject.Property<InventoryCategory> DEFAULT_CATEGORY;
        public PropertiedObject.Property<InventoryGroup> PARENT_GROUP;
        public PropertiedObject.Property<InventoryProfile> PROFILE;
        public PropertiedObject.Property EXTERNAL_ID;
        public PropertiedObject.Property<InventoryCombo> COMBOS;
        public PropertiedObject.Property<InventoryItem> ALL_ITEMS;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property<DecrementStockArea> DECREMENT_STOCK;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<InventoryGroupTriggerLink> TRIGGER_LINKS;
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<PermissionGroup> PERMISSION_GROUP;
        public PropertiedObject.Property MASTER_ID;
    }
}

