/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.AbstractTriggerLink;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_group_trigger_link")
@AccessType(value="property")
public class InventoryGroupTriggerLink
extends AbstractTriggerLink
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryGroup> inventoryGroup;

    @Override
    @Transient
    protected PropertiedObject.Property<AbstractTrigger> getTriggerProperty() {
        return InventoryGroupTriggerLink.Properties.TRIGGER;
    }

    public InventoryGroupTriggerLink() {
        this.inventoryGroup = this.createReference(InventoryGroupTriggerLink.Properties.INVENTORY_GROUP);
    }

    public InventoryGroupTriggerLink(AbstractTrigger trig, InventoryGroup group) {
        super(trig);
        this.inventoryGroup = this.createReference(InventoryGroupTriggerLink.Properties.INVENTORY_GROUP);
        this.setInventoryGroup(group);
    }

    public void setInventoryGroup(InventoryGroup newGroup) {
        this.inventoryGroup.set(newGroup);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    @Override
    public void saveChild() {
        if (!this.getInventoryGroup().isPersistent()) {
            throw new IllegalStateException("Price Inventory Group must be persisted before saving this link");
        }
        PersistenceManager.saveChild(this);
    }

    public static class Props
    extends AbstractTriggerLink.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<AbstractTrigger> TRIGGER;
    }
}

