/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageModLink;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_ingredients")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryIngredients
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private double quantity;
    private Reference<MeasureUnitContainer> measureUnitContainer;
    private Reference<StockInventoryUsageLink> stockInventoryUsageLink;
    private Reference<StockUsageModLink> stockInventoryModLink;
    private Reference<StockItem> stockItem;
    private Long masterId;
    private SystemState systemState;

    @Deprecated
    public InventoryIngredients() {
        this.measureUnitContainer = this.createReference(InventoryIngredients.Properties.MEASURE_UNIT_CONTAINER);
        this.stockInventoryUsageLink = this.createReference(InventoryIngredients.Properties.STOCK_INVENTORY_USAGE_LINK);
        this.stockInventoryModLink = this.createReference(InventoryIngredients.Properties.STOCK_INVENTORY_MOD_LINK);
        this.stockItem = this.createReference(InventoryIngredients.Properties.STOCK_ITEM);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    protected InventoryIngredients(MeasureUnitContainer measureUnitLink, Reference<StockInventoryUsageLink> stockInventoryUsageLink, Reference<StockUsageModLink> stockInventoryModLink, Reference<StockItem> stockItem) {
        this.measureUnitContainer = this.createReference(InventoryIngredients.Properties.MEASURE_UNIT_CONTAINER);
        this.stockInventoryUsageLink = this.createReference(InventoryIngredients.Properties.STOCK_INVENTORY_USAGE_LINK);
        this.stockInventoryModLink = this.createReference(InventoryIngredients.Properties.STOCK_INVENTORY_MOD_LINK);
        this.stockItem = this.createReference(InventoryIngredients.Properties.STOCK_ITEM);
        this.systemState = SystemState.ACTIVE_STATE;
        this.measureUnitContainer.set(measureUnitLink);
        this.stockInventoryUsageLink = stockInventoryUsageLink;
        this.stockInventoryModLink = stockInventoryModLink;
        this.stockItem = stockItem;
    }

    public static InventoryIngredients findInventoryIngredient(MeasureUnit measure, StockInventoryUsageLink usage) {
        if (measure == null) {
            throw new IllegalArgumentException("Cannot find inventory ingredient for null measureUnit.");
        }
        if (usage == null) {
            throw new IllegalArgumentException("Cannot find inventory ingredient for null StockInventoryUsageLink.");
        }
        String sql = Query.select(InventoryIngredients.class).equals(InventoryIngredients.Properties.STOCK_INVENTORY_USAGE_LINK, usage.getID()).toString();
        return PersistenceManager.getObject(InventoryIngredients.class, sql, new Object[0]);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newState) {
        this.systemState = newState;
    }

    @Column(name="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_measure_unit_container")
    public MeasureUnitContainer getMeasureUnitContainer() {
        return this.measureUnitContainer.get();
    }

    public void setMeasureUnitContainer(MeasureUnitContainer value) {
        this.measureUnitContainer.set(value);
    }

    @Transient
    public StockInventoryUsageLink getStockInventoryUsageLink() {
        return this.stockInventoryUsageLink.get();
    }

    public void setStockInventoryUsageLink(StockInventoryUsageLink stockInventoryUsageLink) {
        this.stockInventoryUsageLink.set(stockInventoryUsageLink);
    }

    @Transient
    public StockUsageModLink getStockInventoryModLink() {
        return this.stockInventoryModLink.get();
    }

    public void setStockUsageModLink(StockUsageModLink stockInventoryModLink) {
        this.stockInventoryModLink.set(stockInventoryModLink);
    }

    @Transient
    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public void setStockItem(StockItem stockItem) {
        this.stockItem.set(stockItem);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.getStockInventoryUsageLink() == null) {
            if (!this.isPersistent()) {
                throw new NullPointerException("The inventory ingredient " + this + " has no link to the table 'stock_inventory_item_unit'.");
            }
            OrderMate.LOG.error("The inventory ingredient " + this + " has no link to the table 'stock_inventory_item_unit'.");
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Double> QUANTITY;
        public PropertiedObject.Property<MeasureUnitContainer> MEASURE_UNIT_CONTAINER;
        public PropertiedObject.Property<StockInventoryUsageLink> STOCK_INVENTORY_USAGE_LINK;
        public PropertiedObject.Property<StockUsageModLink> STOCK_INVENTORY_MOD_LINK;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

