/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Sequenced;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.sales.Account;
import ordermate.database.stock.DecrementStockAreaInventoryItem;
import ordermate.database.stock.StockArea;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_item")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryItem
extends PersistentDisplayableObject
implements Saveable,
Inventory,
ExportableObject,
Sequenced {
    public static final Props Properties = new Props();
    private transient Map<String, List<VirtualPrinter>> printersCachedByTerminalAndAccountType;
    private boolean isOpenPrice;
    private boolean isItemNote;
    private Integer sequence = new Integer(0);
    private boolean quickSale;
    private String systemState = "ACTIVE";
    private String ingredientIcon;
    private PersistentWriteableList<InventoryItemUnit> units;
    private PersistentWriteableList<InventoryRemove> removes;
    private Reference<InventoryGroup> menuGroup;
    private Reference<InventoryCategory> category;
    private Reference<PrinterGroup> printerGroup;
    private String shortName;
    private String description;
    private Long masterId;
    private InventoryWeightUnit inventoryWeightUnit;
    private PersistentWriteableList<DecrementStockAreaInventoryItem> decrementStock;

    public InventoryItem() {
        this.units = this.createWriteableList(InventoryItem.Properties.UNITS);
        this.removes = this.createWriteableList(InventoryItem.Properties.REMOVES);
        this.menuGroup = this.createReference(InventoryItem.Properties.MENU_GROUP);
        this.category = this.createReference(InventoryItem.Properties.CATEGORY);
        this.printerGroup = this.createReference(InventoryItem.Properties.PRINTER_GROUP);
        this.shortName = "";
        this.inventoryWeightUnit = InventoryWeightUnit.NA;
        this.decrementStock = (PersistentWriteableList)this.createList(InventoryItem.Properties.DECREMENT_STOCK);
    }

    public InventoryItem(InventoryItem copy) {
        super(copy);
        this.units = this.createWriteableList(InventoryItem.Properties.UNITS);
        this.removes = this.createWriteableList(InventoryItem.Properties.REMOVES);
        this.menuGroup = this.createReference(InventoryItem.Properties.MENU_GROUP);
        this.category = this.createReference(InventoryItem.Properties.CATEGORY);
        this.printerGroup = this.createReference(InventoryItem.Properties.PRINTER_GROUP);
        this.shortName = "";
        this.inventoryWeightUnit = InventoryWeightUnit.NA;
        this.decrementStock = (PersistentWriteableList)this.createList(InventoryItem.Properties.DECREMENT_STOCK);
        this.isOpenPrice = copy.isOpenPrice;
        this.isItemNote = copy.isItemNote;
        this.sequence = copy.sequence;
        this.quickSale = copy.quickSale;
        this.systemState = copy.systemState;
        for (InventoryItemUnit unit : copy.units) {
            this.units.add(new InventoryItemUnit(unit));
        }
        for (InventoryRemove rem : copy.removes) {
            this.removes.add(new InventoryRemove(rem));
        }
        this.category.set(copy.getSafeCategory());
        this.ingredientIcon = copy.ingredientIcon;
        this.printerGroup.set(copy.getPrinterGroup());
    }

    @Override
    public void save() {
        this.printerGroup.saveChild();
        PersistenceManager.save(this);
        this.units.saveChild();
        this.removes.saveChild();
        this.decrementStock.saveChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.units.hasChildChanged() || this.removes.hasChildChanged();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.units.deleteChild();
        this.removes.deleteChild();
        this.save();
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence != null ? this.sequence : 0;
    }

    @Column(name="quick_sale_easy_order_item")
    public boolean isQuickSale() {
        return this.quickSale;
    }

    public void setQuickSale(boolean newQuickSale) {
        this.quickSale = newQuickSale;
    }

    public void setSequence(Integer newSequence) {
        this.sequence = newSequence;
    }

    @OneToMany(mappedBy="item", targetEntity=InventoryItemUnit.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Where(clause="system_state = 'ACTIVE'")
    @Fetch(value=FetchMode.SELECT)
    public List<InventoryItemUnit> getUnits() {
        return this.units.getUnmodifiable();
    }

    public void addUnit(InventoryItemUnit toAdd) {
        if (this.units.getLocalObjects().contains(toAdd)) {
            this.units.remove(toAdd);
        }
        this.units.add(toAdd);
    }

    public void removeUnit(InventoryItemUnit toRemove) {
        this.units.remove(toRemove);
    }

    public void reloadUnits() {
        this.units.collapseUnsafe();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getMenuGroup() {
        return this.menuGroup.get();
    }

    @Transient
    public Long getMenuGroupId() {
        return this.menuGroup.getObjectID();
    }

    public void setMenuGroup(InventoryGroup group) {
        this.menuGroup.set(group);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_category")
    public InventoryCategory getCategory() {
        return this.category.get();
    }

    @Transient
    public InventoryCategory getSafeCategory() {
        if (this.getCategory() != null) {
            return this.getCategory();
        }
        return InventoryCategory.getDefaultCategory();
    }

    public void setCategory(InventoryCategory newCategory) {
        this.category.set(newCategory);
    }

    @Transient
    public boolean isOpenPrice() {
        return this.isOpenPrice;
    }

    @Transient
    public boolean isItemNote() {
        return this.isItemNote;
    }

    @Transient
    public List<InventoryRemove> getMinuses() {
        return this.removes.getUnmodifiable();
    }

    public void addMinus(InventoryRemove remove) {
        this.removes.add(remove);
    }

    public void setMinuses(Collection<InventoryRemove> newRemoves) {
        this.removes.clear();
        for (InventoryRemove remove : newRemoves) {
            this.removes.add(remove);
        }
    }

    public void removeMinus(InventoryRemove toRemove) {
        this.removes.remove(toRemove);
    }

    public InventoryRemove findMinus(String minusName) {
        InventoryRemove found = null;
        Iterator it = this.removes.iterator();
        while (it.hasNext() && found == null) {
            InventoryRemove rem = (InventoryRemove)it.next();
            if (!rem.getLabel().equals(minusName)) continue;
            found = rem;
        }
        return found;
    }

    public List<VirtualPrinter> getPrinters(Terminal currentTerminal, Account account) {
        if (account == null) {
            throw new NullPointerException("The account is null, cannot get the printers");
        }
        String compositeKey = currentTerminal.getLabel() + " TermLoc:" + currentTerminal.getLocation() + " AccType:" + account.getAccountType() + " PrintGrp:" + this.getPrinterGroup();
        if (currentTerminal.getLocation() == null) {
            OrderMate.LOG.warn("** Terminal " + currentTerminal.getLabel() + " does NOT have a location. Printing will not work! **");
        }
        if (this.printersCachedByTerminalAndAccountType == null) {
            this.printersCachedByTerminalAndAccountType = new HashMap<String, List<VirtualPrinter>>();
        } else if (this.printersCachedByTerminalAndAccountType.containsKey(compositeKey)) {
            return PersistenceManager.refreshList(this.printersCachedByTerminalAndAccountType.get(compositeKey), VirtualPrinter.class);
        }
        List<VirtualPrinter> printerList = PersistenceManager.getObjectList(VirtualPrinter.class, "SELECT config_printer_virtual.* FROM \t\tconfig_printer_virtual INNER JOIN config_printer_location \t\tON \tconfig_printer_virtual.ID = config_printer_location.FK_config_printer_virtual INNER JOIN config_printer_group \t\tON \tconfig_printer_location.FK_config_printer_group = config_printer_group.ID INNER JOIN inventory_item \t\tON \tinventory_item.FK_config_printer_group = config_printer_group.ID INNER JOIN config_terminal_location \t\tON \tconfig_terminal_location.ID = config_printer_location.FK_config_terminal_location INNER JOIN config_terminal \t\tON \tconfig_terminal.FK_config_terminal_location = config_terminal_location.ID WHERE  \tinventory_item.ID = ? \tAND \tconfig_terminal.ID = ? \tAND\t\t(config_printer_location.account_type = ? OR config_printer_location.account_type = 'ALL') ORDER BY \tconfig_printer_location.account_type = 'ALL' ", new Object[]{this.getID(), currentTerminal.getID(), account.getAccountType().toString()});
        this.printersCachedByTerminalAndAccountType.put(compositeKey, printerList);
        return printerList;
    }

    @Transient
    public InventoryItemUnit getUnitIfSingle() {
        if (this.units.size() == 1) {
            return (InventoryItemUnit)this.units.get(0);
        }
        return null;
    }

    public boolean isPrintableThrough(Terminal terminal, VirtualPrinter printer, Account account) {
        return this.getPrinters(terminal, account).contains(printer);
    }

    @Transient
    public List<InventoryItemSize> getSizes() {
        HashSet<InventoryItemSize> sizes = new HashSet<InventoryItemSize>();
        for (InventoryItemUnit unit : this.getUnits()) {
            sizes.add(unit.getSize());
        }
        return new ArrayList<InventoryItemSize>(sizes);
    }

    @Transient
    public List<InventoryItemPortion> getPortions() {
        HashSet<InventoryItemPortion> portions = new HashSet<InventoryItemPortion>();
        for (InventoryItemUnit unit : this.getUnits()) {
            portions.add(unit.getPortion());
        }
        return new ArrayList<InventoryItemPortion>(portions);
    }

    public List<InventoryItemPortion> getPortions(InventoryItemSize forSize) {
        HashSet<InventoryItemPortion> portions = new HashSet<InventoryItemPortion>();
        for (InventoryItemUnit unit : this.getUnits()) {
            if (!unit.getSize().equals(forSize)) continue;
            portions.add(unit.getPortion());
        }
        return new ArrayList<InventoryItemPortion>(portions);
    }

    public InventoryItemUnit getUnit(InventoryItemSize size, InventoryItemPortion portion) {
        InventoryItemUnit unit = null;
        Iterator<InventoryItemUnit> iterator = this.getUnits().iterator();
        while (iterator.hasNext() && unit == null) {
            InventoryItemUnit u = iterator.next();
            if (!u.getSize().equals(size) || !u.getPortion().equals(portion)) continue;
            unit = u;
        }
        return unit;
    }

    public StockArea getDecrementStockArea(Terminal terminal) {
        StockArea stockArea = this.getItemLevelDecrementStockArea(terminal);
        return stockArea != null ? stockArea : this.getMenuGroup().getDefaultDecrementStockArea(terminal);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static InventoryItem findInventoryItem(String name, InventoryProfile profile) {
        return PersistenceManager.getObject(InventoryItem.class, "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.FK_inventory_profile = ? AND inventory_item.system_state = 'ACTIVE' AND inventory_group.system_state = 'ACTIVE' ", new Object[]{name, profile.getID()});
    }

    public static List<InventoryItem> findAllInventoryItems(String name, InventoryProfile profile) {
        return PersistenceManager.getObjectList(InventoryItem.class, "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.FK_inventory_profile = ? AND inventory_item.system_state = 'ACTIVE' AND inventory_group.system_state = 'ACTIVE' ", new Object[]{name, profile.getID()});
    }

    public static InventoryItem findInventoryItem(String name, InventoryGroup group) {
        return PersistenceManager.getObject(InventoryItem.class, "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.system_state = 'ACTIVE' AND inventory_item.system_state != 'DELETED'", new Object[]{name, group.getID()});
    }

    public static InventoryItem findInventoryItem(String name, InventoryGroup group, Integer seq) {
        return PersistenceManager.getObject(InventoryItem.class, "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = ? AND inventory_item.sequence = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.system_state = 'ACTIVE' AND inventory_item.system_state != 'DELETED'", new Object[]{name, group.getID(), seq});
    }

    public boolean hasHigherPriorityThan(InventoryItem levelToCompareTo) {
        return this.getSequence() > levelToCompareTo.getSequence();
    }

    public void deleteSequence() {
        this.sequence = null;
        this.save();
    }

    public void setSequence(int newSequence) {
        this.sequence = new Integer(newSequence);
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Column(name="ingredient_icon")
    public String getIngredientIcon() {
        return this.ingredientIcon;
    }

    public void setIngredientIcon(String newIngredientIcon) {
        this.ingredientIcon = newIngredientIcon;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_printer_group")
    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup newPrinterGroup) {
        this.printerGroup.set(newPrinterGroup);
    }

    public void setOpenPrice(boolean openPrice) {
        this.isOpenPrice = openPrice;
    }

    public void setItemNote(boolean itemNote) {
        this.isItemNote = itemNote;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_background")
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_foreground")
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    @Override
    @Column(name="icon")
    public String getIcon() {
        return super.getIcon();
    }

    @Override
    public void setBackgroundColor(Color newBackgroundColor) {
        super.setBackgroundColor(newBackgroundColor);
    }

    @Override
    public void setForegroundColor(Color newForegroundColor) {
        super.setForegroundColor(newForegroundColor);
    }

    @Override
    public void setIcon(String newIcon) {
        super.setIcon(newIcon);
    }

    protected void setUnits(List<InventoryItemUnit> newUnits) {
        this.units = this.units.clone();
        this.units.set(newUnits);
    }

    @OneToMany(mappedBy="item", targetEntity=InventoryRemove.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Where(clause="system_state = 'ACTIVE'")
    protected List<InventoryRemove> getRemoves() {
        return this.removes;
    }

    protected void setRemoves(List<InventoryRemove> newRemoves) {
        this.removes = this.removes.clone();
        this.removes.set(newRemoves);
    }

    @Column(name="item_note")
    public boolean isIsItemNote() {
        return this.isItemNote;
    }

    public void setIsItemNote(boolean itemNote) {
        this.isItemNote = itemNote;
    }

    @Column(name="OpenPrice")
    public boolean isIsOpenPrice() {
        return this.isOpenPrice;
    }

    public void setIsOpenPrice(boolean openPrice) {
        this.isOpenPrice = openPrice;
    }

    public void setShortName(String newShortName) {
        this.shortName = newShortName;
    }

    @Column(name="short_name")
    public String getShortName() {
        return this.shortName;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setInventoryWeightUnit(InventoryWeightUnit newUnit) {
        this.inventoryWeightUnit = newUnit;
    }

    @Column(name="weight_unit")
    @Enumerated(value=EnumType.STRING)
    public InventoryWeightUnit getInventoryWeightUnit() {
        return this.inventoryWeightUnit;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Transient
    public List<DecrementStockAreaInventoryItem> getDecrementStock() {
        return this.decrementStock.getUnmodifiable();
    }

    protected void setDecrementStock(List<DecrementStockAreaInventoryItem> newDecrementStock) {
        this.decrementStock = this.decrementStock.clone();
        this.decrementStock.set(newDecrementStock);
    }

    private StockArea getItemLevelDecrementStockArea(Terminal terminal) {
        StockArea area = null;
        for (DecrementStockAreaInventoryItem decArea : this.decrementStock) {
            if (!terminal.equals(decArea.getTerminal())) continue;
            area = decArea.getStockArea();
            break;
        }
        return area;
    }

    public void setDefaultDecrementStockArea(Terminal terminal, StockArea area) {
        ArrayList<DecrementStockAreaInventoryItem> toRemove = new ArrayList<DecrementStockAreaInventoryItem>(this.decrementStock.size());
        boolean alreadyExisting = false;
        for (DecrementStockAreaInventoryItem dec : this.decrementStock) {
            if (!terminal.equals(dec.getTerminal())) continue;
            if (area == null || !dec.getStockArea().equals(area)) {
                toRemove.add(dec);
            }
            if (!dec.getStockArea().equals(area)) continue;
            alreadyExisting = true;
        }
        this.decrementStock.removeAll(toRemove);
        if (!alreadyExisting && area != null) {
            DecrementStockAreaInventoryItem dec = new DecrementStockAreaInventoryItem(this, area, terminal);
            this.decrementStock.add(dec);
        }
    }

    public void setDecrementStockAreaForAllTerminals(StockArea area) {
        List<Terminal> allTerminals = Terminal.getAllTerminalsExceptServer();
        for (Terminal terminal : allTerminals) {
            this.setDefaultDecrementStockArea(terminal, area);
        }
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property IS_OPEN_PRICE;
        public PropertiedObject.Property IS_ITEM_NOTE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<InventoryGroup> MENU_GROUP;
        public PropertiedObject.Property<InventoryCategory> CATEGORY;
        public PropertiedObject.Property<InventoryItemUnit> UNITS;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property QUICK_SALE;
        public PropertiedObject.Property INGREDIENT_ICON;
        public PropertiedObject.Property<InventoryRemove> REMOVES;
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
        public PropertiedObject.Property<String> SHORT_NAME;
        public PropertiedObject.Property<InventoryWeightUnit> INVENTORY_WEIGHT_UNIT;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property<DecrementStockAreaInventoryItem> DECREMENT_STOCK;
        public PropertiedObject.Property<String> DESCRIPTION;
    }
}

