/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.Inventory;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="inventory_portion")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryItemPortion
extends PersistentDisplayableObject
implements Saveable,
Inventory,
ExportableObject {
    public static final String WHOLE = "Whole";
    public static final String HALF = "Half-Half";
    public static final String QUARTER = "Quarters";
    private static Map<String, InventoryItemPortion> portions = new HashMap<String, InventoryItemPortion>();
    public static final Props Properties = new Props();
    private double size;
    private String systemState = "ACTIVE";
    private Long masterId;

    @Column(name="portion")
    public double getSize() {
        return this.size;
    }

    public void setSize(double newSize) {
        this.size = newSize;
    }

    @Transient
    public String getFraction() {
        if (this.size == 1.0) {
            return "1";
        }
        return "1/" + (int)(1.0 / this.getSize());
    }

    @Transient
    public boolean isFractional() {
        return this.getSize() != 1.0;
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
        portions.clear();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        portions.clear();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public static InventoryItemPortion getPortion(String portionName) {
        InventoryItemPortion toReturn = null;
        if (portions.containsKey(portionName)) {
            toReturn = portions.get(portionName);
        } else {
            toReturn = InventoryItemPortion.findPortion(portionName);
            if (toReturn != null) {
                portions.put(portionName, toReturn);
            }
        }
        return toReturn;
    }

    public static InventoryItemPortion findPortion(String name) {
        String sql = Query.select(InventoryItemPortion.class).active(InventoryItemPortion.class).equals(InventoryItemPortion.Properties.LABEL, name).orderBy(InventoryItemPortion.Properties.SIZE).toString();
        return PersistenceManager.getObject(InventoryItemPortion.class, sql, new Object[0]);
    }

    public static List<InventoryItemPortion> getAllPortions() {
        String sql = Query.select(InventoryItemPortion.class).active(InventoryItemPortion.class).orderBy(InventoryItemPortion.Properties.SIZE).toString();
        return PersistenceManager.getObjectList(InventoryItemPortion.class, sql, new Object[0]);
    }

    protected void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SIZE;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

