/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItemUnit;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="inventory_size")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryItemSize
extends PersistentDisplayableObject
implements Saveable,
Inventory,
ExportableObject {
    public static final Props Properties = new Props();
    private String shortName = "";
    private Integer sequence;
    private String systemState = "ACTIVE";
    private Long masterId;
    private static final LocalCacheListManager<InventoryItemSize> allSizes = new LocalCacheListManager<InventoryItemSize>(Query.createQueryList(InventoryItemSize.class, Query.select(InventoryItemSize.class).active(InventoryItemSize.class).orderBy(InventoryItemSize.Properties.SEQUENCE)));

    @Column(name="short_name")
    public String getShortName() {
        if (this.shortName == null) {
            return "";
        }
        return this.shortName;
    }

    public void setShortName(String value) {
        this.shortName = value != null ? value : "";
    }

    public static InventoryItemSize findSize(String sizeName) {
        return PersistenceManager.getObject(InventoryItemSize.class, "SELECT * FROM inventory_size WHERE Name = ? AND system_state = 'ACTIVE'", new Object[]{sizeName});
    }

    @Column(name="Sequence")
    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer newSequence) {
        this.sequence = newSequence;
    }

    public static List<InventoryItemSize> getAllSizes() {
        return allSizes.getList();
    }

    public static void clearCache() {
        allSizes.clearCache();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Override
    public void delete() {
        if (!PersistenceManager.getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.SIZE, this).active(InventoryItemUnit.class).limit(1).toString()).isEmpty()) {
            throw new IllegalStateException("This size contains some items and cannot be deleted.");
        }
        InventoryItemSize.clearCache();
        this.systemState = "DELETED";
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            InventoryItemSize.clearCache();
        }
        PersistenceManager.save(this);
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static String quickFormatToLitres(Integer unitSize) {
        if (unitSize < 1000) {
            return unitSize + "ml";
        }
        Double litres = new Double((double)unitSize.intValue() / 1000.0);
        return litres + "L";
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SHORT_NAME;
        public PropertiedObject.Property<Integer> SEQUENCE;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

