/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.OptimisticLockException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.ConcurrentDatabaseModificationException;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.InventoryItemUnitBarcodeLink;
import ordermate.database.Sequenced;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnitTax;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.enums.OversellModeType;
import ordermate.database.queries.inventory.InventoryItemUnitQueries;
import ordermate.database.queries.stock.StockInventoryUsageLinkQueries;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockCount;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_item_unit")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryItemUnit
extends PersistentObject
implements SaveableChild,
StockLinkable<StockInventoryUsageLink>,
Inventory,
Displayable,
Sequenced {
    public static final Props Properties = new Props();
    private Reference<InventoryItemSize> size;
    private Reference<InventoryItemPortion> portion;
    private Reference<InventoryItem> item;
    private PersistentWriteableList<InventoryItemUnitTax> unitTaxes;
    private List<TaxCode> taxCodes;
    private PersistentWriteableList<InventoryOptionGroupLink> optionGroupLinks;
    private Reference<InventoryAddGroup> plusGroup;
    private PersistentWriteableList<UnitPriceLevel> prices;
    private PersistentWriteableList<InventoryItemUnitBarcodeLink> barcodeLinks;
    private PersistentWriteableList<InventoryComboGroupItemUnitLink> comboGroupLinks;
    private PersistentWriteableList<InventoryDefaultMod> defaultMods;
    private String recipe;
    private String externalID;
    private String systemState;
    private Price customStockCost;
    private PersistentWriteableList<StockInventoryUsageLink> stockItemLinks;
    private Reference<StockCount> stockCount;
    private Integer menuIdentifier;
    private Long masterId;
    private int numPatrons;

    public InventoryItemUnit() {
        this.size = this.createReference(InventoryItemUnit.Properties.SIZE);
        this.portion = this.createReference(InventoryItemUnit.Properties.PORTION);
        this.item = this.createReference(InventoryItemUnit.Properties.ITEM);
        this.unitTaxes = this.createWriteableList(InventoryItemUnit.Properties.UNIT_TAXES);
        this.taxCodes = new ArrayList<TaxCode>();
        this.optionGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.OPTION_GROUP_LINKS);
        this.plusGroup = this.createReference(InventoryItemUnit.Properties.PLUS_GROUP);
        this.prices = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.PRICES);
        this.barcodeLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.BARCODE_LINKS);
        this.comboGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.COMBO_GROUP_LINKS);
        this.defaultMods = this.createWriteableList(InventoryItemUnit.Properties.DEFAULT_MODS);
        this.recipe = "";
        this.systemState = "ACTIVE";
        this.stockItemLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.STOCK_ITEM_LINKS);
        this.stockCount = this.createReference(InventoryItemUnit.Properties.STOCK_COUNT);
        this.numPatrons = 0;
    }

    public InventoryItemUnit(InventoryItemSize newSize) {
        this.size = this.createReference(InventoryItemUnit.Properties.SIZE);
        this.portion = this.createReference(InventoryItemUnit.Properties.PORTION);
        this.item = this.createReference(InventoryItemUnit.Properties.ITEM);
        this.unitTaxes = this.createWriteableList(InventoryItemUnit.Properties.UNIT_TAXES);
        this.taxCodes = new ArrayList<TaxCode>();
        this.optionGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.OPTION_GROUP_LINKS);
        this.plusGroup = this.createReference(InventoryItemUnit.Properties.PLUS_GROUP);
        this.prices = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.PRICES);
        this.barcodeLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.BARCODE_LINKS);
        this.comboGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.COMBO_GROUP_LINKS);
        this.defaultMods = this.createWriteableList(InventoryItemUnit.Properties.DEFAULT_MODS);
        this.recipe = "";
        this.systemState = "ACTIVE";
        this.stockItemLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.STOCK_ITEM_LINKS);
        this.stockCount = this.createReference(InventoryItemUnit.Properties.STOCK_COUNT);
        this.numPatrons = 0;
        for (TaxCode code : TaxCode.getDefaultTaxCodes()) {
            this.addTaxCode(code);
        }
        this.portion.set(InventoryItemPortion.getPortion("Whole"));
        this.setSize(newSize);
    }

    public InventoryItemUnit(InventoryItemUnit copy) {
        this.size = this.createReference(InventoryItemUnit.Properties.SIZE);
        this.portion = this.createReference(InventoryItemUnit.Properties.PORTION);
        this.item = this.createReference(InventoryItemUnit.Properties.ITEM);
        this.unitTaxes = this.createWriteableList(InventoryItemUnit.Properties.UNIT_TAXES);
        this.taxCodes = new ArrayList<TaxCode>();
        this.optionGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.OPTION_GROUP_LINKS);
        this.plusGroup = this.createReference(InventoryItemUnit.Properties.PLUS_GROUP);
        this.prices = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.PRICES);
        this.barcodeLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.BARCODE_LINKS);
        this.comboGroupLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.COMBO_GROUP_LINKS);
        this.defaultMods = this.createWriteableList(InventoryItemUnit.Properties.DEFAULT_MODS);
        this.recipe = "";
        this.systemState = "ACTIVE";
        this.stockItemLinks = (PersistentWriteableList)this.createList(InventoryItemUnit.Properties.STOCK_ITEM_LINKS);
        this.stockCount = this.createReference(InventoryItemUnit.Properties.STOCK_COUNT);
        this.numPatrons = 0;
        this.recipe = copy.recipe;
        this.externalID = copy.externalID;
        this.systemState = copy.systemState;
        this.customStockCost = copy.customStockCost;
        this.size = copy.size;
        this.portion = copy.portion;
        for (InventoryItemUnitTax tax : copy.unitTaxes) {
            this.addTaxCode(tax.getTaxCode());
        }
        for (InventoryOptionGroupLink grpLink : copy.getOptionGroupLinks()) {
            InventoryOptionGroupLink link = new InventoryOptionGroupLink(this, grpLink.getOptionGroup());
            link.setMaxQty(grpLink.getMaxQty());
            link.setMinQty(grpLink.getMinQty());
            link.setReducedZone(grpLink.getReducedZone());
            this.optionGroupLinks.add(link);
        }
        this.plusGroup = copy.plusGroup;
        for (UnitPriceLevel unitPrice : copy.prices) {
            this.prices.add(new UnitPriceLevel(unitPrice));
        }
    }

    @Override
    public void init() {
        this.getItem();
        super.init();
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    @Override
    public void saveChild() {
        if (this.item.get() == null) {
            if (!this.isPersistent()) {
                throw new NullPointerException("The item unit " + this + " has no menu item.");
            }
            OrderMate.LOG.error("The item unit " + this + " has no menu item.");
        }
        if (this.size.get() == null) {
            if (!this.isPersistent()) {
                throw new NullPointerException("The item unit " + this + " has no size.");
            }
            OrderMate.LOG.error("The item unit " + this + " has no size.");
        }
        if (this.portion.get() == null) {
            if (!this.isPersistent()) {
                throw new NullPointerException("The item unit " + this + " has no portion.");
            }
            OrderMate.LOG.error("The item unit " + this + " has no portion.");
        }
        if (this.stockCount.get() == null && !PersistenceManager.getPersistenceDelegate().isHeadOffice() && StockControlProperty.getInstance().isStockCountDownEnabled()) {
            this.stockCount.set(new StockCount());
            this.stockCount.saveChild();
        }
        PersistenceManager.saveChild(this);
        this.optionGroupLinks.saveChild();
        this.plusGroup.saveChild();
        this.prices.saveChild();
        this.stockItemLinks.saveChild();
        this.barcodeLinks.saveChild();
        this.unitTaxes.saveChild();
        this.defaultMods.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void deleteChild() {
        this.barcodeLinks.deleteChild();
        for (StockInventoryUsageLink currentLink : StockInventoryUsageLinkQueries.getLinksToInventoryUnit(this)) {
            currentLink.deleteChild();
        }
        this.systemState = "DELETED";
        this.optionGroupLinks.deleteChild();
        this.prices.deleteChild();
        this.comboGroupLinks.deleteChild();
        this.stockItemLinks.deleteChild();
        this.stockCount.deleteChild();
        this.defaultMods.deleteChild();
        this.saveChild();
    }

    @PrePersist
    @PreUpdate
    public void removeEmptyPrices() {
        HashSet<UnitPriceLevel> toDelete = new HashSet<UnitPriceLevel>();
        for (UnitPriceLevel price : this.getPrices()) {
            if (price.getPrice() != null) continue;
            toDelete.add(price);
        }
        for (UnitPriceLevel deleteMe : toDelete) {
            this.removeUnitPriceLevel(deleteMe);
            if (!deleteMe.isPersistent()) continue;
            deleteMe.delete();
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_size")
    public InventoryItemSize getSize() {
        return this.size.get();
    }

    public void setSize(InventoryItemSize newSize) {
        this.size.set(newSize);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_portion")
    public InventoryItemPortion getPortion() {
        return this.portion.get();
    }

    public void setPortion(InventoryItemPortion newPortion) {
        this.portion.set(newPortion);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_item", referencedColumnName="ID")
    public InventoryItem getItem() {
        return this.item.get();
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getItemLabel() + "(" + this.getSizeLabel() + ")";
    }

    @Transient
    public String getSizeLabel() {
        if (this.getSize() != null) {
            return this.getSize().getLabel();
        }
        return "";
    }

    @Transient
    public String getPortionLabel() {
        return this.getPortion().getLabel();
    }

    @Transient
    public String getItemLabel() {
        return this.getItem() == null ? "ERROR, NO ITEM FOR THIS INSTANCE " + this.getID() : this.getItem().getLabel();
    }

    @Column(name="menu_identifier")
    public Integer getMenuIdentifier() {
        return this.menuIdentifier;
    }

    public void setMenuIdentifier(Integer menuId) {
        this.menuIdentifier = menuId;
    }

    public boolean hasChoices(TriggerActivationContext activationContext) {
        if (this.getPortion().getSize() == 1.0 && this.getActiveOptionGroupLinks(activationContext).size() == 0 && !this.getItem().isOpenPrice() && !this.getItem().isItemNote()) {
            for (InventoryOptionGroupLink link : this.optionGroupLinks) {
                if (link.getMaxQty() == 1 || link.getMinQty() == 1) continue;
                return true;
            }
            if (this.getPluses().size() == 0 && this.getItem().getMinuses().size() == 0) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        InventoryItemPortion aPortion = this.getPortion();
        String portionString = "";
        if (aPortion != null && aPortion.getSize() < 1.0) {
            portionString = aPortion.getLabel() + ", ";
        }
        return this.getItemLabel() + "(" + portionString + this.getSizeLabel() + ")";
    }

    @OneToMany(mappedBy="unit", targetEntity=UnitPriceLevel.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<UnitPriceLevel> getPrices() {
        return this.prices.getUnmodifiable();
    }

    public void addUnitPriceLevel(UnitPriceLevel toAdd) {
        if (toAdd == null) {
            return;
        }
        UnitPriceLevel toRemove = null;
        for (UnitPriceLevel price : this.prices) {
            if (price.getPriceLevel() == null || !price.getPriceLevel().equals(toAdd.getPriceLevel())) continue;
            toRemove = price;
            break;
        }
        this.prices.remove(toRemove);
        toAdd.setUnit(this);
        this.prices.add(toAdd);
    }

    public void removeUnitPriceLevel(UnitPriceLevel toRemove) {
        if (!this.prices.remove(toRemove)) {
            throw new IllegalArgumentException("Inventory item " + this.getLabel() + " does not contain unit price level " + toRemove);
        }
    }

    @Transient
    public List<UnitPriceLevel> getUnitPriceLevels() {
        return this.prices.getUnmodifiable();
    }

    public UnitPriceLevel getUnitPriceLevel(PriceLevel priceLevel) {
        UnitPriceLevel toReturn = null;
        Iterator it = this.prices.iterator();
        while (it.hasNext() && toReturn == null) {
            UnitPriceLevel toCheck = (UnitPriceLevel)it.next();
            if (!toCheck.getPriceLevel().equals(priceLevel)) continue;
            toReturn = toCheck;
        }
        return toReturn;
    }

    public boolean hasUnitPriceLevel(PriceLevel priceLevel) {
        return this.getUnitPriceLevel(priceLevel) != null;
    }

    public UnitPriceLevel getActiveUnitPriceLevel(EventContext context, Date currentDateTime, Account currentAccount) {
        return this.getActiveUnitPriceLevel(new TriggerActivationContext(context, currentDateTime, currentAccount));
    }

    public UnitPriceLevel getActiveUnitPriceLevel(TriggerActivationContext context) {
        UnitPriceLevel highestActive = null;
        for (UnitPriceLevel current : this.getUnitPriceLevels()) {
            if (!current.isActive(context)) continue;
            if (highestActive == null) {
                highestActive = current;
                continue;
            }
            int sequence = current.getPriceLevel().getSequence();
            if (sequence <= highestActive.getPriceLevel().getSequence()) continue;
            highestActive = current;
        }
        return highestActive;
    }

    @Column(name="recipe")
    public String getRecipe() {
        return this.recipe;
    }

    public void setRecipe(String aRecipe) {
        this.recipe = aRecipe;
    }

    @Column(name="external_id")
    public String getExternalID() {
        return this.externalID;
    }

    @Transient
    public boolean isPubliclyAccessible() {
        return this.systemState.equals("ACTIVE");
    }

    @Override
    @Transient
    public Price getIngredientCostIncTax() {
        Price customCost = this.getCustomStockCost();
        if (customCost != null) {
            return new Price(0.0, 0.0);
        }
        return this.calculateIngredientCost(null, true, true);
    }

    @Transient
    public Price getCurrentIngredientCost(boolean incTax) {
        return this.calculateIngredientCost(null, incTax, false);
    }

    public Price getAverageCost(StockArea area) {
        Price customCost = this.getCustomStockCost();
        return customCost != null ? customCost : this.getOnHandCost(area);
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        Price customCost = this.getCustomStockCost();
        if (customCost != null) {
            return customCost;
        }
        return this.getOnHandCost(null);
    }

    @Column(name="custom_stock_cost")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCustomStockCost() {
        return this.customStockCost;
    }

    public void setCustomStockCost(Price custStockCost) {
        this.customStockCost = custStockCost;
    }

    @Transient
    public boolean isProfitable() {
        double theCheapestPrice;
        Iterator<UnitPriceLevel> it = this.getUnitPriceLevels().iterator();
        if (it.hasNext()) {
            theCheapestPrice = it.next().getPriceExTax().doubleValue();
        } else {
            return false;
        }
        while (it.hasNext()) {
            UnitPriceLevel priceLevel = it.next();
            if (!(priceLevel.getPriceExTax().doubleValue() < theCheapestPrice)) continue;
            theCheapestPrice = priceLevel.getPriceExTax().doubleValue();
        }
        double cost = this.getIngredientCostExTax().doubleValue();
        return cost == 0.0 || cost < theCheapestPrice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public boolean isTaxFree() {
        double value = 0.0;
        List<TaxCode> list = this.taxCodes;
        synchronized (list) {
            for (TaxCode code : this.getTaxCodes()) {
                value += code.getRate();
            }
        }
        return MathsUtils.approxEquals(value, 0.0);
    }

    public void addTaxCode(TaxCode newCode) {
        if (newCode == null) {
            return;
        }
        for (InventoryItemUnitTax tax : this.unitTaxes) {
            if (!tax.getTaxCode().toString().equals(newCode.toString())) continue;
            return;
        }
        this.unitTaxes.add(new InventoryItemUnitTax(this, newCode));
    }

    public void removeTaxCode(TaxCode oldCode) {
        this.taxCodes.clear();
        InventoryItemUnitTax toRemove = null;
        for (InventoryItemUnitTax tax : this.unitTaxes) {
            if (!tax.getTaxCode().equals(oldCode)) continue;
            toRemove = tax;
            break;
        }
        if (toRemove != null) {
            this.unitTaxes.remove(toRemove);
        }
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=InventoryItemUnitTax.class, mappedBy="unit", cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    protected List<InventoryItemUnitTax> getUnitTaxes() {
        return this.unitTaxes;
    }

    protected void setUnitTaxes(List<InventoryItemUnitTax> values) {
        this.unitTaxes = this.unitTaxes.clone();
        this.unitTaxes.set(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public List<TaxCode> getTaxCodes() {
        List<TaxCode> list = this.taxCodes;
        synchronized (list) {
            if (this.taxCodes.isEmpty()) {
                for (InventoryItemUnitTax tax : this.unitTaxes) {
                    if (!tax.getTaxCode().getSystemState().equals(SystemState.ACTIVE_STATE)) continue;
                    this.taxCodes.add(tax.getTaxCode());
                }
            }
        }
        return this.taxCodes;
    }

    public void setTaxCodes(List<TaxCode> codes) {
        ArrayList<TaxCode> toAdd = new ArrayList<TaxCode>(codes);
        HashSet<InventoryItemUnitTax> toRemove = new HashSet<InventoryItemUnitTax>();
        for (InventoryItemUnitTax tax : this.unitTaxes) {
            if (!codes.contains(tax.getTaxCode())) {
                toRemove.add(tax);
            }
            toAdd.remove(tax.getTaxCode());
        }
        this.unitTaxes.removeAll(toRemove);
        for (TaxCode code : toAdd) {
            this.unitTaxes.add(new InventoryItemUnitTax(this, code));
        }
    }

    public void setPlusGroup(InventoryAddGroup group) {
        InventoryAddGroup oldGroup = this.plusGroup.get();
        this.plusGroup.set(group);
        if (oldGroup != null && !oldGroup.equals(group)) {
            this.removeStaleDefaults();
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_add_group")
    public InventoryAddGroup getPlusGroup() {
        return this.plusGroup.get();
    }

    @Transient
    public List<InventoryAdd> getPluses() {
        ArrayList<InventoryAdd> pluses = new ArrayList<InventoryAdd>();
        InventoryAddGroup addgroup = this.plusGroup.get();
        if (addgroup != null) {
            pluses.addAll(addgroup.getModifications());
        }
        return pluses;
    }

    @Transient
    public InventoryAdd findPlus(String name) {
        for (InventoryAdd add : this.getPluses()) {
            if (!add.getLabel().equals(name)) continue;
            return add;
        }
        return null;
    }

    public List<InventoryOptionGroupLink> getActiveOptionGroupLinks(TriggerActivationContext activationContext) {
        ArrayList<InventoryOptionGroupLink> links = new ArrayList<InventoryOptionGroupLink>();
        for (InventoryOptionGroupLink link : this.optionGroupLinks) {
            if (!link.getOptionGroup().isActive(activationContext)) continue;
            links.add(link);
        }
        return links;
    }

    public void setOptionGroups(List<InventoryOptionGroupLink> groupsLinks) {
        ArrayList<InventoryOptionGroupLink> toAdd = new ArrayList<InventoryOptionGroupLink>(groupsLinks);
        for (InventoryOptionGroupLink myLink : this.optionGroupLinks) {
            for (int i = 0; i < groupsLinks.size(); ++i) {
                if (!groupsLinks.get(i).getOptionGroup().equals(myLink)) continue;
                InventoryOptionGroupLink newLink = groupsLinks.get(i);
                myLink.setMinQty(newLink.getMinQty());
                myLink.setMaxQty(newLink.getMaxQty());
                myLink.setReducedZone(newLink.getReducedZone());
                myLink.setSequence(newLink.getSequence());
                toAdd.set(i, myLink);
            }
        }
        Collections.sort(toAdd, Sequenced.SequenceComparator.getInst());
        int lastSequence = toAdd.size() == 0 ? 0 : ((InventoryOptionGroupLink)toAdd.get(0)).getSequence() - 1;
        for (InventoryOptionGroupLink link : toAdd) {
            if (lastSequence >= link.getSequence()) {
                link.setSequence(lastSequence + 1);
            }
            lastSequence = link.getSequence();
        }
        this.optionGroupLinks.removeAll(new ArrayList<InventoryOptionGroupLink>(this.optionGroupLinks));
        this.optionGroupLinks.addAll(toAdd);
        this.removeStaleDefaults();
    }

    void removeStaleDefaults() {
        HashSet<InventoryOptionGroup> groups = new HashSet<InventoryOptionGroup>();
        for (InventoryOptionGroupLink link : this.optionGroupLinks) {
            groups.add(link.getOptionGroup());
        }
        InventoryAddGroup addGroup = this.getPlusGroup();
        HashSet<InventoryDefaultMod> toRemove = new HashSet<InventoryDefaultMod>();
        for (InventoryDefaultMod mod : this.defaultMods) {
            if (mod instanceof InventoryDefaultOption) {
                if (groups.contains(((InventoryDefaultOption)mod).getOption().getOptionGroup())) continue;
                toRemove.add(mod);
                continue;
            }
            if (!(mod instanceof InventoryDefaultAdd) || addGroup.equals(((InventoryDefaultAdd)mod).getAdd().getAddGroup())) continue;
            toRemove.add(mod);
        }
        this.defaultMods.removeAll(toRemove);
    }

    public static List getPubliclyAccessibleInventoryItemUnits() {
        return PersistenceManager.getObjectList(InventoryItemUnit.class, InventoryItemUnitQueries.QUERY_GET_VALID, null);
    }

    public static List<InventoryItemUnit> getAllInventoryItemUnits() {
        return PersistenceManager.getObjectList(InventoryItemUnit.class, "SELECT inventory_item_unit.* FROM inventory_item_unit, inventory_item WHERE inventory_item_unit.FK_inventory_item = inventory_item.ID ORDER BY Name", null);
    }

    public static Collection<InventoryItemUnit> getUnitsByBarcode(String barcode, AccountType type, Terminal theTerminal) {
        return new HashSet<InventoryItemUnit>(PersistenceManager.getObjectList(InventoryItemUnit.class, "SELECT inventory_item_unit.* FROM inventory_item_unit_barcodes INNER JOIN inventory_item_unit_barcodes_link ON inventory_item_unit_barcodes_link.FK_inventory_item_unit_barcodes = inventory_item_unit_barcodes.ID INNER JOIN inventory_item_unit ON  inventory_item_unit_barcodes_link.FK_inventory_item_unit = inventory_item_unit.ID INNER JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID  INNER JOIN inventory_group ON inventory_item.fk_inventory_group = inventory_group.ID INNER JOIN inventory_profile ON inventory_group.fk_inventory_profile = inventory_profile.ID INNER JOIN config_display_profile ON  config_display_profile.FK_inventory_profile = inventory_profile.ID WHERE config_display_profile.account_type IN (? , 'ALL')AND config_display_profile.FK_config_terminal_location = ? AND inventory_item_unit_barcodes.barcode = ? AND inventory_item_unit.system_state = 'ACTIVE' ", new Object[]{type.toString(), theTerminal.getLocation().getID(), barcode}));
    }

    public static InventoryItemUnit getUnitByID(long ID) {
        return PersistenceManager.getObject(InventoryItemUnit.class, "SELECT * FROM inventory_item_unit WHERE ID = ?", new Object[]{ID});
    }

    public static InventoryItemUnit getUnitByExtID(String extID) {
        return PersistenceManager.getObject(InventoryItemUnit.class, "SELECT * FROM inventory_item_unit WHERE external_id = ?", new Object[]{extID});
    }

    public static InventoryItemUnit findInventoryItemUnit(String itemName, String itemSize, String itemPortion, InventoryProfile theProfile) {
        try {
            return Data.database.findInventoryItemUnit(itemName, itemSize, itemPortion, theProfile.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public static InventoryItemUnit findInventoryItemUnit(InventoryItem item, InventoryItemSize size, InventoryItemPortion portion) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot find unit for null item");
        }
        if (size == null) {
            throw new IllegalArgumentException("Cannot find unit for null size");
        }
        if (portion == null) {
            throw new IllegalArgumentException("Cannot find unit for null portion");
        }
        ArrayList<String> stateList = new ArrayList<String>();
        stateList.add("ACTIVE");
        stateList.add("INACTIVE");
        String sql = Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, item.getID()).equals(InventoryItemUnit.Properties.SIZE, size.getID()).equals(InventoryItemUnit.Properties.PORTION, portion.getID()).wherePropertyIn(InventoryItemUnit.Properties.SYSTEM_STATE, stateList).toString();
        return PersistenceManager.getObject(InventoryItemUnit.class, sql, new Object[0]);
    }

    public static InventoryItemUnit findInventoryItemUnit(Integer menuIdentifier) {
        if (menuIdentifier == null) {
            throw new NullPointerException("Cannot search with a null menu identifier.");
        }
        String sql = Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.MENU_IDENTIFIER, menuIdentifier).active(InventoryItemUnit.class).toString();
        return PersistenceManager.getObject(InventoryItemUnit.class, sql, new Object[0]);
    }

    @Transient
    public StockItem getSingleIngredient() {
        if (this.stockItemLinks.size() == 1) {
            StockInventoryUsageLink link = (StockInventoryUsageLink)this.stockItemLinks.get(0);
            return link.getStockItem();
        }
        return null;
    }

    @Transient
    public List<String> getBarcodes() {
        ArrayList<String> barcodes = new ArrayList<String>();
        for (InventoryItemUnitBarcodeLink link : this.barcodeLinks) {
            barcodes.add(link.getBarcode().getBarcode());
        }
        return barcodes;
    }

    @Transient
    public List<InventoryBarcode> getInventoryBarcodes() {
        ArrayList<InventoryBarcode> barcodes = new ArrayList<InventoryBarcode>();
        for (InventoryItemUnitBarcodeLink link : this.barcodeLinks) {
            barcodes.add(link.getBarcode());
        }
        return barcodes;
    }

    @OneToMany(mappedBy="itemUnit", targetEntity=InventoryItemUnitBarcodeLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    protected List<InventoryItemUnitBarcodeLink> getBarcodeLinks() {
        return this.barcodeLinks;
    }

    protected void setBarcodeLinks(List<InventoryItemUnitBarcodeLink> links) {
        this.barcodeLinks = this.barcodeLinks.clone();
        this.barcodeLinks.set(links);
    }

    @Override
    public void clearStockUsage() {
        this.stockItemLinks.clear();
    }

    public void setStockUsage(List stockUsage) {
        this.clearStockUsage();
        for (Pair pair : stockUsage) {
            StockItem stockItem = (StockItem)pair.key;
            Quantity qty = (Quantity)pair.value;
            this.setStockUsage(stockItem, qty);
        }
    }

    public void retainStockUsages(Collection<StockItem> stockItems) {
        HashSet<StockLink> linksToRemove = new HashSet<StockLink>();
        for (StockLink stockLink : this.stockItemLinks) {
            if (stockItems.contains(stockLink.getStockItem())) continue;
            linksToRemove.add(stockLink);
        }
        for (StockLink stockLink : linksToRemove) {
            this.removeStockLink(stockLink);
        }
    }

    @Transient
    public List<Pair<StockItem, Quantity>> getStockUsage() {
        return StockLinkable.StockLinkableHelper.getStockUsage(this);
    }

    @Transient
    public String getStockUsageDescString() {
        String retval = "...";
        PersistentWriteableList<StockInventoryUsageLink> stockUsage = this.stockItemLinks;
        if (stockUsage.size() == 1) {
            StockInventoryUsageLink firstLink = (StockInventoryUsageLink)stockUsage.get(0);
            Quantity qty = firstLink.getQuantity();
            return qty.toString();
        }
        if (stockUsage.size() == 0) {
            return "(empty)";
        }
        return retval;
    }

    public Quantity getStockUsage(StockItem stockItem) {
        for (StockInventoryUsageLink si : this.stockItemLinks) {
            if (!si.isLinkingStockItem(stockItem)) continue;
            return si.getQuantity();
        }
        return Quantity.ZERO();
    }

    public void setStockUsageRemovable(StockItem stockItem, boolean removable, Price removePrice) {
        for (StockInventoryUsageLink si : this.stockItemLinks) {
            if (!si.isLinkingStockItem(stockItem)) continue;
            si.setRemovable(removable);
            si.setRemovePrice(removePrice);
            return;
        }
    }

    @Override
    public void setStockUsage(StockItem stockItem, Quantity qty) {
        this.setStockUsage(stockItem, qty, false, false);
    }

    @Override
    public void setStockUsage(StockItem stockItem, Quantity qty, boolean isFixedQty, boolean isRemoveable) {
        if (stockItem == null) {
            throw new NullPointerException("The stock item to set the usage is null");
        }
        if (qty != null && !qty.isZero()) {
            this.setCustomStockCost(null);
        }
        for (StockInventoryUsageLink si : this.stockItemLinks) {
            if (!si.getStockItem().equals(stockItem)) continue;
            if (qty == null || qty.getRawValue() == 0.0) {
                this.stockItemLinks.remove(si);
            } else {
                si.setQuantity(qty);
                si.setFixedQuantity(isFixedQty);
                si.setRemovable(isRemoveable);
            }
            return;
        }
        if (qty != null && !qty.equals(Quantity.ZERO())) {
            StockInventoryUsageLink si = new StockInventoryUsageLink(this, stockItem, qty);
            si.setFixedQuantity(isFixedQty);
            si.setRemovable(isRemoveable);
            this.stockItemLinks.add(si);
        }
    }

    public Price getOnHandCost(StockArea area) {
        return new Price(StockLinkable.StockLinkableHelper.getOnHandCost(area, this, false), 0.01);
    }

    private Price calculateIngredientCost(StockArea area, boolean incTax, boolean useAvg) {
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            return new Price(0.0, 0.0);
        }
        double cost = 0.0;
        for (StockInventoryUsageLink link : this.stockItemLinks) {
            StockItem stockItem = link.getStockItem();
            if (stockItem == null) {
                return new Price(0.0, 0.0);
            }
            cost += link.calculateStockItemLinkCost(area, incTax, useAvg);
        }
        return new Price(cost, 0.01);
    }

    @Transient
    public SalesQuantity getGenericStockCount() {
        StockControlProperty props = StockControlProperty.getInstance();
        SalesQuantity stockQty = null;
        if (props.isStockCountDownEnabled() && this.isStockCountDownEnabled()) {
            stockQty = this.getStockCountQuantity();
        } else if (props.isStockControlEnabled() && this.stockItemLinks.size() == 1) {
            StockInventoryUsageLink stockLink = (StockInventoryUsageLink)this.stockItemLinks.get(0);
            double sohAmount = stockLink.getStockOnHand().getRawValue();
            double ingredientAmount = stockLink.getQuantity().getRawValue();
            stockQty = new SalesQuantity(BigDecimal.valueOf(sohAmount / ingredientAmount));
        }
        return stockQty;
    }

    public static void deleteUnitBarcode(String barcode, InventoryItemUnit unit) {
        List<InventoryBarcode> barcodeObjs = unit.getBarcodeObjects(barcode);
        for (InventoryBarcode code : barcodeObjs) {
            unit.removeBarcode(code);
        }
    }

    public void removeBarcode(InventoryBarcode code) {
        ArrayList<InventoryItemUnitBarcodeLink> deleteSet = new ArrayList<InventoryItemUnitBarcodeLink>();
        for (InventoryItemUnitBarcodeLink link : this.barcodeLinks) {
            if (!link.getBarcode().equals(code)) continue;
            deleteSet.add(link);
        }
        this.barcodeLinks.removeAll(deleteSet);
    }

    private List<InventoryBarcode> getBarcodeObjects(String barcode) {
        ArrayList<InventoryBarcode> barcodeObjs = new ArrayList<InventoryBarcode>();
        for (InventoryItemUnitBarcodeLink link : this.barcodeLinks) {
            if (!link.getBarcode().matches(barcode)) continue;
            barcodeObjs.add(link.getBarcode());
        }
        return barcodeObjs;
    }

    public static void addUnitBarcode(String newBarcode, InventoryItemUnit unit) {
        List<String> barcodes = unit.getBarcodes();
        if (barcodes.contains(newBarcode)) {
            return;
        }
        InventoryBarcode code = InventoryBarcode.getBarcode(newBarcode);
        if (code == null) {
            code = new InventoryBarcode(newBarcode);
            code.save();
        }
        unit.addBarCode(code);
    }

    public void addBarCode(InventoryBarcode code) {
        if (!code.isPersistent()) {
            throw new IllegalArgumentException("Cannot add non-persistent barcode to inventory item unit : " + this.getID());
        }
        if (!this.getBarcodes().contains(code.getBarcode())) {
            this.barcodeLinks.add(new InventoryItemUnitBarcodeLink(this, code));
        }
    }

    @Transient
    public boolean isStockLinked() {
        boolean retval = false;
        retval = this.getCustomStockCost() != null ? true : !this.stockItemLinks.isEmpty();
        return retval;
    }

    @Transient
    public boolean isStockCountDownEnabled() {
        if (this.stockCount.getID() == null) {
            return false;
        }
        StockCount stockCountInst = this.getStockCount();
        if (stockCountInst == null) {
            return false;
        }
        return stockCountInst.getQuantity() != null;
    }

    @Transient
    public SalesQuantity getStockCountQuantity() {
        StockCount stockCountInst = this.getStockCount();
        SalesQuantity retValue = stockCountInst == null ? SalesQuantity.ZERO : (stockCountInst.getQuantity() != null ? stockCountInst.getQuantity() : SalesQuantity.ZERO);
        return retValue;
    }

    public void setStockCountQty(SalesQuantity newQty, EventContext context) throws ConcurrentDatabaseModificationException {
        this.setStockCountQty(newQty, this.stockCount.get(), context);
    }

    public void setStockCountQty(SalesQuantity qty, StockCount count, EventContext context) throws ConcurrentDatabaseModificationException {
        boolean isNew = false;
        StockCount stockCountInst = count;
        if (stockCountInst == null) {
            stockCountInst = new StockCount();
            isNew = true;
        }
        stockCountInst.setQuantity(qty);
        TerminalEventLog.logStockCountSet(this.getItem(), stockCountInst.getQuantity(), context);
        OrderMate.LOG.info("Stock Count Set For " + this.getItem().getLabel() + ": " + (stockCountInst.getQuantity() == null ? "None" : stockCountInst.getQuantity()));
        try {
            this.stockCount.saveChild();
            if (isNew) {
                this.saveChild();
            }
        }
        catch (OptimisticLockException ole) {
            throw new ConcurrentDatabaseModificationException(ole);
        }
        catch (Exception ex) {
            throw new ConcurrentDatabaseModificationException(ex.getCause());
        }
    }

    public void cancelStockCount() throws ConcurrentDatabaseModificationException {
        StockCount existingCount = this.stockCount.get();
        if (existingCount == null) {
            existingCount = new StockCount();
        }
        existingCount.setQuantity(null);
        try {
            existingCount.saveChild();
        }
        catch (OptimisticLockException ole) {
            throw new ConcurrentDatabaseModificationException(ole);
        }
    }

    public void decrementStockCount(SalesQuantity qty, EventContext context) {
        if (this.isStockCountDownEnabled()) {
            for (int i = 0; i < 100; ++i) {
                try {
                    StockCount countInst = this.getStockCount();
                    TerminalEventLog.logStockCountChange(this.getItem(), countInst.getQuantity(), countInst.getQuantity().subtract(qty), context);
                    OrderMate.LOG.info("Stock Count Change (" + this.getItem().getLabel() + "): " + countInst.getQuantity().toString() + " -> " + countInst.getQuantity().subtract(qty).toString());
                    this.setStockCountQty(countInst.getQuantity().subtract(qty), countInst, context);
                    return;
                }
                catch (ConcurrentDatabaseModificationException ex) {
                    OrderMate.LOG.info("Could not set stock count, will retry", (Throwable)ex);
                    try {
                        Thread.sleep(i);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
            OrderMate.LOG.error("Could not set stock count to " + qty + " for " + this.getLabel());
        }
    }

    public boolean shouldNotifyOfStockOverSold(double qty) {
        StockControlProperty props = StockControlProperty.getInstance();
        if (!(props.isStockControlEnabled() && !props.getOversellMode().equals(OversellModeType.IGNORE) || props.isStockCountDownEnabled() && this.isStockCountDownEnabled() && !props.getStockCountdownOversellMode().equals(OversellModeType.IGNORE))) {
            return false;
        }
        double quantity = qty;
        boolean retval = false;
        int wholeQuantity = (int)Math.ceil(quantity);
        if (props.isStockCountDownEnabled() && this.isStockCountDownEnabled()) {
            retval = this.getStockCountQuantity().lessThan(wholeQuantity);
        } else if (props.isStockControlEnabled()) {
            try {
                retval = Data.database.isInventoryItemUnitStockOverSold(this.intID(), wholeQuantity);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        return retval;
    }

    public String getStockQuantityString(SalesQuantity itemQty, SalesQuantity alreadyUncommittedQty) {
        StockControlProperty props = StockControlProperty.getInstance();
        String returnValue = "";
        SalesQuantity genericStockQty = null;
        if (props.isStockCountDownEnabled() && this.isStockCountDownEnabled() && props.isShowStockCountInFrontEnd()) {
            genericStockQty = this.getGenericStockCount();
        } else if (props.isStockControlEnabled() && props.isShowSOHInFrontEnd()) {
            genericStockQty = this.getGenericStockCount();
        }
        if (genericStockQty != null) {
            returnValue = " (" + genericStockQty.subtract(alreadyUncommittedQty).subtract(itemQty) + ")";
        }
        return returnValue;
    }

    public StockItem linkStockItemForUnit() {
        String name;
        StockItem stockItem;
        StockSupplier defaultSupplier = StockSupplier.getDefaultSupplier();
        StockGroup defaultStockGroup = StockGroup.getDefaultStockGroup();
        if (defaultSupplier == null) {
            defaultSupplier = new StockSupplier();
            defaultSupplier.setName("Default");
            defaultSupplier.setAddress1("");
            defaultSupplier.setAddress2("");
            defaultSupplier.setPhone("");
            defaultSupplier.setFax("");
            defaultSupplier.setEmail("");
            defaultSupplier.save();
        }
        if ((stockItem = StockItemQueries.getStockItemForName(name = StringUtils.cleanStringForSQL(this.getItem().getLabel()))) == null) {
            StockGroup group = this.getStockGroupForMenuItemUnit();
            if (group == null) {
                if (defaultStockGroup == null) {
                    defaultStockGroup = new StockGroup();
                    defaultStockGroup.setLabel("Default");
                    defaultStockGroup.save();
                }
                group = defaultStockGroup;
            }
            stockItem = new StockItem();
            stockItem.setName(name);
            MeasureUnit UNITS = MeasureUnitHelper.getMeasureUnitForName("units");
            stockItem.setPurchaseQty(UNITS, 1.0);
            stockItem.setIngredientMeasureUnit(UNITS);
            stockItem.setStockGroup(group);
            stockItem.addSupplier(defaultSupplier);
            stockItem.save();
        }
        Quantity qty = new Quantity(stockItem.getIngredientMeasureUnit(), 1.0, false);
        this.setStockUsage(stockItem, qty);
        return stockItem;
    }

    @Transient
    protected StockCount getStockCount() {
        return this.stockCount.get();
    }

    @Transient
    private StockGroup getStockGroupForMenuItemUnit() {
        StockGroup group = null;
        InventoryGroup selectedMenuGroup = this.getItem().getMenuGroup();
        if (selectedMenuGroup != null) {
            String groupName = selectedMenuGroup.getLabel();
            group = StockGroup.getStockGroupForName(groupName = StringUtils.cleanStringForSQL(groupName));
            if (group == null) {
                group = new StockGroup();
                group.setLabel(groupName);
                group.save();
            }
        }
        return group;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Transient
    public List<StockInventoryUsageLink> getStockInventoryUsageLinks() {
        return this.stockItemLinks.getUnmodifiable();
    }

    @Transient
    public boolean isStockUsed() {
        return !this.stockItemLinks.isEmpty();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @OneToMany(mappedBy="itemUnit", targetEntity=InventoryOptionGroupLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @Where(clause="system_state = 'ACTIVE'")
    public List<InventoryOptionGroupLink> getOptionGroupLinks() {
        return this.optionGroupLinks.getUnmodifiable();
    }

    protected void setOptionGroupLinks(List<InventoryOptionGroupLink> newOptionGroupLinks) {
        this.optionGroupLinks = this.optionGroupLinks.clone();
        this.optionGroupLinks.set(newOptionGroupLinks);
    }

    public InventoryOptionGroupLink addOptionGroupLink(InventoryOptionGroup group) {
        InventoryOptionGroupLink link = new InventoryOptionGroupLink(this, group);
        this.optionGroupLinks.add(link);
        return link;
    }

    public void removeOptionGroupLink(InventoryOptionGroupLink linkToRemove) {
        this.optionGroupLinks.remove(linkToRemove);
        InventoryOptionGroup group = linkToRemove.getOptionGroup();
        for (InventoryOptionGroupLink link : this.optionGroupLinks) {
            if (!group.equals(link.getOptionGroup())) continue;
            return;
        }
        this.removeStaleDefaults();
    }

    protected void setPrices(List<UnitPriceLevel> newPrices) {
        this.prices = this.prices.clone();
        this.prices.set(newPrices);
    }

    public void setExternalID(String newExternalID) {
        this.externalID = newExternalID;
    }

    public void setItem(InventoryItem newItem) {
        if (newItem == null) {
            return;
        }
        if (this.item.get() == null || newItem.equals(this.item.get())) {
            this.item.set(newItem);
        }
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @OneToMany(mappedBy="itemUnit", targetEntity=InventoryComboGroupItemUnitLink.class, fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    protected List<InventoryComboGroupItemUnitLink> getComboGroupLinks() {
        return this.comboGroupLinks;
    }

    protected void setComboGroupLinks(List<InventoryComboGroupItemUnitLink> links) {
        this.comboGroupLinks = this.comboGroupLinks.clone();
        this.comboGroupLinks.set(links);
    }

    @OneToMany(mappedBy="unit", targetEntity=InventoryDefaultMod.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<InventoryDefaultMod> getDefaultMods() {
        return this.defaultMods.getUnmodifiable();
    }

    protected void setDefaultMods(List<InventoryDefaultMod> newMods) {
        this.defaultMods = this.defaultMods.clone();
        this.defaultMods.set(newMods);
    }

    protected void setStockCount(StockCount count) {
        this.stockCount.set(count);
    }

    @Transient
    protected List<StockInventoryUsageLink> getStockItemLinks() {
        return this.stockItemLinks;
    }

    protected void setStockItemLinks(List<StockInventoryUsageLink> links) {
        this.stockItemLinks = this.stockItemLinks.clone();
        this.stockItemLinks.set(links);
    }

    @Override
    @Transient
    public List<StockInventoryUsageLink> getStockLinks() {
        return this.stockItemLinks.getUnmodifiable();
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="num_patrons")
    public int getNumPatrons() {
        return this.numPatrons;
    }

    public void setNumPatrons(int value) {
        this.numPatrons = value;
    }

    @Override
    public boolean removeStockLink(StockLink link) {
        return this.stockItemLinks.remove(link);
    }

    public boolean removeStockLink(StockItem linkedItem) {
        StockLink theLink = null;
        for (StockLink stockLink : this.stockItemLinks) {
            if (!linkedItem.equals(stockLink.getStockItem())) continue;
            theLink = stockLink;
        }
        if (theLink != null) {
            this.removeStockLink(theLink);
            return true;
        }
        return false;
    }

    @Transient
    public Collection<InventoryRemovable<SalesRemoveStocked>> getRemoveableIngredients() {
        ArrayList<InventoryRemovable<SalesRemoveStocked>> removable = new ArrayList<InventoryRemovable<SalesRemoveStocked>>();
        for (StockInventoryUsageLink ingredient : this.getStockInventoryUsageLinks()) {
            if (!ingredient.isRemovable()) continue;
            removable.add(ingredient);
        }
        return removable;
    }

    @Override
    public void collapseStockLinks() {
        this.stockItemLinks.collapseUnsafe();
    }

    public InventoryDefaultMod addDefaultMod(InventoryDefaultMod mod) {
        int sequence = 0;
        for (InventoryDefaultMod nextMod : this.defaultMods) {
            sequence = Math.max(sequence, nextMod.getSequence());
            if (!nextMod.getDefaultMod().equals(mod.getDefaultMod())) continue;
            nextMod.setSequence(mod.getSequence());
            return nextMod;
        }
        mod.setUnit(this);
        if (mod.getSequence() == 0) {
            mod.setSequence(sequence + 1);
        }
        this.defaultMods.add(mod);
        return mod;
    }

    public void removeDefaultMod(InventoryDefaultMod mod) {
        this.defaultMods.remove(mod);
    }

    @Override
    @Transient
    public int getSequence() {
        return 0;
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItemSize> SIZE;
        public PropertiedObject.Property<InventoryItemPortion> PORTION;
        public PropertiedObject.Property<InventoryItem> ITEM;
        public PropertiedObject.Property<InventoryOptionGroupLink> OPTION_GROUP_LINKS;
        public PropertiedObject.Property<InventoryAddGroup> PLUS_GROUP;
        public PropertiedObject.Property RECIPE;
        public PropertiedObject.Property EXTERNAL_ID;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property CUSTOM_STOCK_COST;
        public PropertiedObject.Property<UnitPriceLevel> PRICES;
        public PropertiedObject.Property<InventoryItemUnitTax> UNIT_TAXES;
        public PersistentObject.DerivedProperty<TaxCode> TAX_CODES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryItemUnit.class), "taxCodes");
        public PropertiedObject.Property<InventoryItemUnitBarcodeLink> BARCODE_LINKS;
        public PropertiedObject.Property<InventoryComboGroupItemUnitLink> COMBO_GROUP_LINKS;
        public PropertiedObject.Property<StockInventoryUsageLink> STOCK_ITEM_LINKS;
        public PropertiedObject.Property<StockCount> STOCK_COUNT;
        public PropertiedObject.Property MENU_IDENTIFIER;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property NUM_PATRONS;
        public PropertiedObject.Property<InventoryDefaultMod> DEFAULT_MODS;
    }
}

