/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryItemUnit;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="inventory_item_unit_tax")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryItemUnitTax
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryItemUnit> unit;
    private Reference<TaxCode> taxCode;

    public InventoryItemUnitTax() {
        this.unit = this.createReference(InventoryItemUnitTax.Properties.UNIT);
        this.taxCode = this.createReference(InventoryItemUnitTax.Properties.TAX_CODE);
    }

    public InventoryItemUnitTax(InventoryItemUnit unit, TaxCode tax) {
        this.unit = this.createReference(InventoryItemUnitTax.Properties.UNIT);
        this.taxCode = this.createReference(InventoryItemUnitTax.Properties.TAX_CODE);
        this.setUnit(unit);
        this.setTaxCode(tax);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="fk_inventory_item_unit", referencedColumnName="ID")
    public InventoryItemUnit getUnit() {
        return this.unit.get();
    }

    public void setUnit(InventoryItemUnit value) {
        this.unit.set(value);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="fk_system_tax_code", referencedColumnName="ID")
    public TaxCode getTaxCode() {
        return this.taxCode.get();
    }

    public void setTaxCode(TaxCode value) {
        this.taxCode.set(value);
    }

    @Override
    public String toString() {
        return this.taxCode.isNull() ? "No Code" : this.taxCode.get().getCode();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItemUnit> UNIT;
        public PropertiedObject.Property<TaxCode> TAX_CODE;
    }
}

