/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.config.Quantity;
import ordermate.database.finance.CostedItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.queries.inventory.InventoryOptionQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_option")
@AccessType(value="property")
public class InventoryOption
extends Modification
implements StockLinkable<StockUsageOptionLink>,
SaveableChild,
ExportableObject,
CostedItem {
    public static final Props Properties = new Props();
    private int sequence;
    private Reference<InventoryOptionGroup> optionGroup;
    private String systemState;
    private PersistentWriteableList<StockUsageOptionLink> stockUsageOptions;
    private Price costPerOptionEx;
    private Price customStockCost;
    private Long masterId;
    private double reducedFactor;
    private boolean availableOnline;

    public InventoryOption() {
        this.optionGroup = this.createReference(InventoryOption.Properties.OPTION_GROUP);
        this.systemState = "ACTIVE";
        this.stockUsageOptions = this.createWriteableList(InventoryOption.Properties.STOCK_USAGE_OPTIONS);
        this.costPerOptionEx = null;
        this.customStockCost = null;
        this.availableOnline = true;
    }

    public InventoryOption(InventoryOption toCopy) {
        this.optionGroup = this.createReference(InventoryOption.Properties.OPTION_GROUP);
        this.systemState = "ACTIVE";
        this.stockUsageOptions = this.createWriteableList(InventoryOption.Properties.STOCK_USAGE_OPTIONS);
        this.costPerOptionEx = null;
        this.customStockCost = null;
        this.setLabel(toCopy.getLabel());
        this.setBackgroundColor(toCopy.getBackgroundColor());
        this.setForegroundColor(toCopy.getForegroundColor());
        this.setSequence(toCopy.getSequence());
        this.setPrice(toCopy.getPrice());
        this.setAvailableOnline(toCopy.isAvailableOnline());
        for (Pair<StockItem, Quantity> usage : toCopy.getStockUsage()) {
            this.setStockUsage(usage.getKey(), usage.getValue());
        }
    }

    public boolean belongsToGroup(InventoryOptionGroup group) {
        return group.getModifications().contains(this);
    }

    public static InventoryOption findOption(String name, InventoryItemSize size) {
        return PersistenceManager.getObject(InventoryOption.class, InventoryOptionQueries.QUERY_GET_BY_NAME_SIZE.toString(), new Object[]{name, size.getID()});
    }

    @Override
    @Transient
    public ModificationSize getModificationSize() {
        return ModificationSize.getDefaultSize();
    }

    @Override
    public void setModificationSize(ModificationSize ms) {
    }

    @Override
    public void clearStockUsage() {
        this.stockUsageOptions.clear();
    }

    @Transient
    public List<Pair<StockItem, Quantity>> getStockUsage() {
        return StockLinkable.StockLinkableHelper.getStockUsage(this);
    }

    public void setStockUsage(List stockUsage) {
        this.clearStockUsage();
        for (Pair pair : stockUsage) {
            StockItem stockItem = (StockItem)pair.key;
            Quantity qty = (Quantity)pair.value;
            this.setStockUsage(stockItem, qty);
        }
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount) {
        this.setStockUsage(item, amount, false, false);
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount, boolean isFixedQty, boolean isRemoveable) {
        if (StockLinkable.StockLinkableHelper.updateExistingStockUsage(this, item, amount)) {
            return;
        }
        StockUsageOptionLink stockOption = new StockUsageOptionLink(item, this, amount);
        stockOption.setFixedQuantity(isFixedQty);
        this.stockUsageOptions.add(stockOption);
    }

    @Transient
    public Price getCustomStockCost() {
        return this.customStockCost;
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        if (this.costPerOptionEx == null) {
            this.costPerOptionEx = this.getCost(false);
        }
        return this.costPerOptionEx;
    }

    @Override
    @Transient
    public Price getIngredientCostIncTax() {
        return this.getCost(true);
    }

    @Transient
    public Price getCost(boolean incTax) {
        double cost = 0.0;
        this.customStockCost = this.getCustomStockCost();
        cost = this.customStockCost == null ? StockLinkable.StockLinkableHelper.calcReplacementCost(incTax, this) : this.customStockCost.doubleValue();
        return new Price(cost, 0.0);
    }

    public Price getOnHandCost(StockArea area) {
        return StockLinkable.StockLinkableHelper.getOnHandCost(area, this, false);
    }

    @Transient
    public boolean isProfitable() {
        double cost = this.getIngredientCostIncTax().doubleValue();
        double sales = this.getModificationPrice().doubleValue();
        return cost == 0.0 || cost < sales;
    }

    public boolean isEquivalentTo(InventoryOption option) {
        return option != null && this.getLabel().equals(option.getLabel()) && this.getModificationPrice().equals(option.getModificationPrice());
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newValue) {
        this.sequence = newValue;
    }

    public void setOptionGroup(InventoryOptionGroup group) {
        this.optionGroup.set(group);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_option_group")
    public InventoryOptionGroup getOptionGroup() {
        return this.optionGroup.get();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String value) {
        this.systemState = value;
    }

    @Deprecated
    public static InventoryOption getOptionByID(long ID) {
        return PersistenceManager.getByID(ID, InventoryOption.class);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.stockUsageOptions.saveChild();
    }

    @Override
    public void deleteChild() {
        this.setSystemState("DELETED");
        PersistenceManager.saveChild(this);
        this.stockUsageOptions.deleteChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Transient
    public List<StockUsageOptionLink> getStockUsageOptions() {
        return this.stockUsageOptions;
    }

    protected void setStockUsageOptions(List<StockUsageOptionLink> newStockUsageOptions) {
        this.stockUsageOptions = this.stockUsageOptions.clone();
        this.stockUsageOptions.set(newStockUsageOptions);
    }

    @Transient
    public boolean isDefault() {
        InventoryOption defaultOption = this.getOptionGroup().getDefaultOption();
        return defaultOption != null && defaultOption.equals(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Override
    @Transient
    public List<StockUsageOptionLink> getStockLinks() {
        return this.stockUsageOptions.getUnmodifiable();
    }

    @Override
    public boolean removeStockLink(StockLink link) {
        return this.stockUsageOptions.remove(link);
    }

    @Override
    public void collapseStockLinks() {
        this.stockUsageOptions.collapseUnsafe();
    }

    @Column(name="reduced_factor")
    public double getReducedFactor() {
        return this.reducedFactor;
    }

    public void setReducedFactor(double value) {
        this.reducedFactor = value;
    }

    @Transient
    public Price getReducedPrice() {
        return this.getPrice().multiply(1.0 - this.getReducedFactor());
    }

    @Column(name="available_online")
    public boolean isAvailableOnline() {
        return this.availableOnline;
    }

    public void setAvailableOnline(boolean availableOnline) {
        this.availableOnline = availableOnline;
    }

    public static class Props
    extends Modification.Props {
        public PropertiedObject.Property<StockUsageOptionLink> STOCK_USAGE_OPTIONS;
        public PropertiedObject.Property<InventoryOptionGroup> OPTION_GROUP;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property REDUCED_FACTOR;
        public PropertiedObject.Property AVAILABLE_ONLINE;
    }
}

