/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroupTriggerLink;
import ordermate.database.inventory.ModificationGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.inventory.triggers.activation.TriggerActivationSupport;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_option_group")
@AccessType(value="property")
public class InventoryOptionGroup
extends ModificationGroup
implements TriggerActivated {
    public static final Props Properties = new Props();
    private PersistentWriteableList<InventoryOption> options;
    private boolean printable;
    private int sequence;
    private TriggerActivationStrategy triggerActivationStrategy;
    private PersistentWriteableList<InventoryOptionGroupTriggerLink> triggerLinks;
    private Reference<InventoryOption> defaultOption;

    public InventoryOptionGroup() {
        this.options = this.createWriteableList(InventoryOptionGroup.Properties.OPTIONS);
        this.printable = true;
        this.triggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
        this.triggerLinks = this.createWriteableList(InventoryOptionGroup.Properties.TRIGGER_LINKS);
        this.defaultOption = this.createReference(InventoryOptionGroup.Properties.DEFAULT_OPTION);
    }

    @OneToMany(mappedBy="optionGroup", targetEntity=InventoryOption.class, cascade={CascadeType.ALL})
    @Where(clause="system_state = 'ACTIVE'")
    public List<InventoryOption> getOptions() {
        return this.getModifications();
    }

    @Override
    @Transient
    public List<InventoryOption> getModifications() {
        return this.options.getUnmodifiable();
    }

    public static InventoryOptionGroup findModificationGroup(String groupName, InventoryItemSize size) {
        String sql = Query.select(InventoryOptionGroup.class).active(InventoryOptionGroup.class).equals(InventoryOptionGroup.Properties.LABEL, groupName).equals(InventoryOptionGroup.Properties.SIZE, size.getID()).toString();
        return PersistenceManager.getObject(InventoryOptionGroup.class, sql, new Object[0]);
    }

    public static List<InventoryOptionGroup> getOptionGroups() {
        return PersistenceManager.getObjectList(InventoryOptionGroup.class, Query.select(InventoryOptionGroup.class).active(InventoryOptionGroup.class).toString(), null);
    }

    @Column(name="printable")
    public boolean isPrintable() {
        return this.printable;
    }

    public void setPrintable(boolean value) {
        this.printable = value;
    }

    @Override
    public String toString() {
        String size = null;
        if (this.getSize() != null) {
            size = !this.getSize().getShortName().isEmpty() ? this.getSize().getShortName() : this.getSize().getLabel();
        }
        if (size != null) {
            return this.getLabel() + "(" + size + ")";
        }
        return this.getLabel();
    }

    public void setOptions(List<InventoryOption> optionList) {
        this.options = this.options.clone();
        this.options.set(optionList);
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation_strategy")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggers = new ArrayList<AbstractTrigger>();
        for (InventoryOptionGroupTriggerLink link : this.getTriggerLinks()) {
            triggers.add(link.getTrigger());
        }
        return triggers;
    }

    @Override
    @Transient
    public boolean isActive(TriggerActivationContext context) {
        return this.getTriggerActivationStrategy().isActive(this, context);
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trig) {
        InventoryOptionGroupTriggerLink link = new InventoryOptionGroupTriggerLink(trig, this);
        this.triggerLinks.add(link);
        return link;
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trig) {
        boolean removed = false;
        Iterator it = this.triggerLinks.iterator();
        while (it.hasNext()) {
            TriggerLink link = (TriggerLink)it.next();
            if (!link.getTrigger().equals(trig)) continue;
            link.deleteChild();
            it.remove();
            removed = true;
        }
        return removed;
    }

    protected void setTriggerLinks(List<InventoryOptionGroupTriggerLink> links) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(links);
    }

    @OneToMany(mappedBy="inventoryOptionGroup", targetEntity=InventoryOptionGroupTriggerLink.class, cascade={CascadeType.ALL})
    protected List<InventoryOptionGroupTriggerLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    @Override
    public void save() {
        super.save();
        this.options.saveChild();
        this.triggerLinks.saveChild();
    }

    @Override
    public void delete() {
        this.triggerLinks.deleteChild();
        this.options.deleteChild();
        super.delete();
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy newStrategy) {
        this.triggerActivationStrategy = newStrategy;
    }

    public void setTriggers(List<AbstractTrigger> triggers) {
        new TriggerActivationSupport(this).setTriggers(triggers);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_inventory_option")
    public InventoryOption getDefaultOption() {
        return this.defaultOption.get();
    }

    public void setDefaultOption(InventoryOption newDefault) {
        this.defaultOption.set(newDefault);
    }

    public void removeOption(InventoryOption option) {
        this.options.remove(option);
    }

    public void addOption(InventoryOption option) {
        if (option != null) {
            this.options.add(option);
        }
    }

    public static class Props
    extends ModificationGroup.Props {
        public PropertiedObject.Property<InventoryOption> OPTIONS;
        public PropertiedObject.Property PRINTABLE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<InventoryOptionGroupTriggerLink> TRIGGER_LINKS;
        public PropertiedObject.Property<InventoryOption> DEFAULT_OPTION;
    }
}

