/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_option_group_link")
@AccessType(value="property")
public class InventoryOptionGroupLink
extends PersistentObject
implements Sequenced,
SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryItemUnit> itemUnit;
    private Reference<InventoryOptionGroup> optionGroup;
    private int sequence;
    private SystemState systemState;
    private int minQty;
    private int maxQty;
    private int reducedZone;

    public InventoryOptionGroupLink() {
        this.itemUnit = this.createReference(InventoryOptionGroupLink.Properties.ITEM_UNIT);
        this.optionGroup = this.createReference(InventoryOptionGroupLink.Properties.OPTION_GROUP);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public InventoryOptionGroupLink(InventoryItemUnit unit, InventoryOptionGroup group) {
        this.itemUnit = this.createReference(InventoryOptionGroupLink.Properties.ITEM_UNIT);
        this.optionGroup = this.createReference(InventoryOptionGroupLink.Properties.OPTION_GROUP);
        this.systemState = SystemState.ACTIVE_STATE;
        this.setItemUnit(unit);
        this.setOptionGroup(group);
    }

    public InventoryOptionGroupLink(InventoryOptionGroupLink linkToCopy) {
        this(linkToCopy.getItemUnit(), linkToCopy.getOptionGroup());
        this.setSequence(linkToCopy.getSequence());
        this.minQty = linkToCopy.getMinQty();
        this.maxQty = linkToCopy.getMaxQty();
        this.reducedZone = linkToCopy.getReducedZone();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getItemUnit() {
        return this.itemUnit.get();
    }

    public void setItemUnit(InventoryItemUnit unit) {
        this.itemUnit.set(unit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_option_group")
    public InventoryOptionGroup getOptionGroup() {
        return this.optionGroup.get();
    }

    public void setOptionGroup(InventoryOptionGroup optionGrp) {
        this.optionGroup.set(optionGrp);
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Column(name="min_qty")
    public int getMinQty() {
        return this.minQty;
    }

    public void setMinQty(int value) {
        this.minQty = value;
    }

    @Column(name="max_qty")
    public int getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(int value) {
        this.maxQty = value;
    }

    @Column(name="reduced_zone")
    public int getReducedZone() {
        return this.reducedZone;
    }

    public void setReducedZone(int value) {
        this.reducedZone = value;
    }

    public int compareTo(Object o) {
        return Sequenced.SequenceComparator.getInst().compare(this, o);
    }

    @Override
    public void deleteChild() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void saveChild() {
        if (this.getOptionGroup() == null || this.getItemUnit() == null) {
            OrderMate.LOG.info("Attempt to save optionGroupLink with null option or null unit.  OptionGroupLink : " + this.getID() + " unit " + this.getItemUnit() + ", option group " + this.getOptionGroup());
            this.deleteChild();
        } else {
            this.optionGroup.saveChild();
            PersistenceManager.saveChild(this);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    @Transient
    public boolean isForcedChoice() {
        return this.minQty == 1 && this.maxQty == 1 && this.getOptionGroup().getOptions().size() == 1;
    }

    public boolean hasRealMaximum() {
        return this.maxQty >= this.minQty && this.maxQty > 0;
    }

    public boolean isSatisfied(boolean fully, List selectedOptions) {
        int size = selectedOptions.size();
        if (!fully) {
            return size >= this.minQty && (!this.hasRealMaximum() || size <= this.maxQty);
        }
        if (this.hasRealMaximum()) {
            return size == this.maxQty;
        }
        return false;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItemUnit> ITEM_UNIT;
        public PropertiedObject.Property<InventoryOptionGroup> OPTION_GROUP;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property MIN_QTY;
        public PropertiedObject.Property MAX_QTY;
        public PropertiedObject.Property REDUCED_ZONE;
    }
}

