/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.database.sales.AccountType;
import ordermate.database.users.PermissionGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="inventory_profile")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InventoryProfile
extends PersistentDisplayableObject
implements Saveable,
Inventory,
ExportableObject {
    public static final Props Properties = new Props();
    private PersistentWriteableList<InventoryGroup> menuGroups;
    private String systemState;
    private Long masterId;
    private transient boolean inventoryGroupsPreloaded;
    private static final Object cacheMutex = new Object();
    private static Map<InventoryProfile, List<InventoryGroup>> groupCache = new HashMap<InventoryProfile, List<InventoryGroup>>();
    private static TerminalLocation cachedLocation;
    private static Map<InventoryProfile, List<InventoryItem>> quickItemsCache;
    private static final Map<Terminal, Map<AccountType, InventoryProfile>> profileCache;

    @Override
    public String toString() {
        return this.getLabel();
    }

    public InventoryProfile() {
        this.menuGroups = this.createWriteableList(InventoryProfile.Properties.MENU_GROUPS);
        this.systemState = "ACTIVE";
        this.inventoryGroupsPreloaded = false;
    }

    public static InventoryProfile getProfile(AccountType accountType, Terminal theTerminal) {
        return InventoryProfileHelper.getInstance().getProfile(accountType, theTerminal);
    }

    static void cacheTerminalProfiles(Terminal currentTerminal) {
        InventoryProfileHelper.getInstance().cacheTerminalProfiles(currentTerminal);
    }

    public static Vector<InventoryProfile> getAllProfiles() {
        return InventoryProfileHelper.getInstance().getAllProfiles();
    }

    public static List<InventoryGroup> getProfileGroups(InventoryProfile toGet) {
        return InventoryProfileHelper.getInstance().getProfileGroups(toGet);
    }

    public static List<InventoryGroup> getProfileGroups(TriggerActivationContext context, InventoryProfile toGet) {
        return InventoryProfileHelper.getInstance().getProfileGroups(context, toGet);
    }

    public List<InventoryGroup> getActiveProfileGroups(TriggerActivationContext context) {
        return this.getActiveProfileGroups(context, false);
    }

    public List<InventoryGroup> getActiveProfileGroups(TriggerActivationContext context, boolean expandSubgroups) {
        List<InventoryGroup> groups = this.getProfileGroups(expandSubgroups);
        groups = new ArrayList<InventoryGroup>(TriggerActivationHelper.getActive(groups, context));
        Collections.sort(groups);
        return groups;
    }

    public List<InventoryGroup> getProfileGroups(boolean expandSubGroups) {
        return InventoryProfileHelper.getInstance().getProfileGroups(this, expandSubGroups);
    }

    public List<InventoryItem> getQuickSaleItems(Terminal localTerminal) {
        return InventoryProfileHelper.getInstance().getQuickSaleItems(this, localTerminal);
    }

    public static List<String> getActiveGroupNames(InventoryProfile profile) {
        return InventoryProfileHelper.getInstance().getActiveGroupNames(profile);
    }

    @Transient
    public List<InventoryGroup> getAvailableGroups() {
        return InventoryProfileHelper.getInstance().getAvailableGroups(this);
    }

    public static InventoryProfile findProfile(String name) {
        return InventoryProfileHelper.getInstance().findProfile(name);
    }

    public static boolean shouldCacheMenus(Terminal localTerminal) {
        return InventoryProfileHelper.getInstance().shouldCacheMenus(localTerminal);
    }

    public static Task cacheMenuGroups(Terminal localTerminal) {
        return InventoryProfileHelper.getInstance().cacheMenuGroups(localTerminal);
    }

    public void clearCache() {
        InventoryProfileHelper.getInstance().clearCache();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.menuGroups.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    public InventoryGroup getCachedGroup(InventoryGroup lastGroup) {
        if (!Terminal.getLocalHost().getMenuCaching()) {
            return lastGroup;
        }
        List<InventoryGroup> groups = groupCache.get(this);
        for (InventoryGroup currentGroup : groups) {
            if (currentGroup.equals(lastGroup)) {
                return currentGroup;
            }
            for (InventoryGroup subgroup : currentGroup.getRecursiveSubGroups()) {
                if (!subgroup.equals(lastGroup)) continue;
                return subgroup;
            }
        }
        if (Config.isDebuging()) {
            throw new IllegalStateException("Could not find group in profile, " + this.getLabel() + " cache, for : " + lastGroup);
        }
        OrderMate.LOG.warn("Could not find group in profile : " + this.getLabel() + " cache : " + lastGroup + " using non-cached.");
        return lastGroup;
    }

    @OneToMany(mappedBy="profile", targetEntity=InventoryGroup.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<InventoryGroup> getMenuGroups() {
        return this.menuGroups;
    }

    public void addInventoryGroup(InventoryGroup group) {
        if (group != null) {
            this.menuGroups.add(group);
        }
    }

    public void removeInventoryGroup(InventoryGroup group) {
        this.menuGroups.remove(group);
    }

    protected void setMenuGroups(List<InventoryGroup> newMenuGroups) {
        this.menuGroups = this.menuGroups.clone();
        this.menuGroups.set(newMenuGroups);
    }

    @Transient
    public boolean isInventoryGroupsPreloaded() {
        return this.inventoryGroupsPreloaded;
    }

    public void setInventoryGroupsPreloaded(boolean value) {
        this.inventoryGroupsPreloaded = value;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public List<InventoryGroup> getModifiableProfileGroupsWithoutDuplicates(PermissionGroup permissionGroup) {
        return this.getAllModifiableProfileGroupsDuplicates(permissionGroup, false);
    }

    public List<InventoryGroup> getAllModifiableProfileGroupsDuplicates(PermissionGroup permissionGroup, boolean withDuplicates) {
        List<InventoryGroup> groupList = this.getProfileGroups(withDuplicates);
        Iterator<InventoryGroup> it = groupList.iterator();
        while (it.hasNext()) {
            InventoryGroup group = it.next();
            if (group.canModify(permissionGroup)) continue;
            it.remove();
        }
        return groupList;
    }

    public List<InventoryGroup> getModifiableProfileGroups(PermissionGroup clearance) {
        return this.getAllModifiableProfileGroupsDuplicates(clearance, true);
    }

    static {
        quickItemsCache = new HashMap<InventoryProfile, List<InventoryItem>>();
        profileCache = new HashMap<Terminal, Map<AccountType, InventoryProfile>>();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<InventoryGroup> MENU_GROUPS;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property MASTER_ID;
    }
}

