/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.guicore.task.NullTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.CacheMenuTask;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.AccountType;

public class InventoryProfileHelper {
    private transient boolean inventoryGroupsPreloaded = false;
    private final Object cacheMutex = new Object();
    private Map<InventoryProfile, List<InventoryGroup>> groupCache = new HashMap<InventoryProfile, List<InventoryGroup>>();
    private TerminalLocation cachedLocation;
    private Map<InventoryProfile, List<InventoryItem>> quickItemsCache = new HashMap<InventoryProfile, List<InventoryItem>>();
    private final Map<Terminal, Map<AccountType, InventoryProfile>> profileCache = new HashMap<Terminal, Map<AccountType, InventoryProfile>>();
    private static volatile InventoryProfileHelper instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InventoryProfileHelper getInstance() {
        if (instance != null) return instance;
        Class<InventoryProfileHelper> clazz = InventoryProfileHelper.class;
        synchronized (InventoryProfileHelper.class) {
            if (instance != null) return instance;
            instance = new InventoryProfileHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public InventoryProfile getProfile(AccountType accountType, Terminal theTerminal) {
        if (this.profileCache.containsKey(theTerminal)) {
            Map<AccountType, InventoryProfile> accountTypeProfileMap = this.profileCache.get(theTerminal);
            if (accountTypeProfileMap.containsKey(accountType)) {
                if (this.shouldCacheMenus(theTerminal)) {
                    accountTypeProfileMap.put(accountType, this.getProfilesFromDatabase(accountType, theTerminal));
                }
                return accountTypeProfileMap.get(accountType);
            }
            accountTypeProfileMap.put(accountType, this.getProfilesFromDatabase(accountType, theTerminal));
            return accountTypeProfileMap.get(accountType);
        }
        return this.getProfilesFromDatabase(accountType, theTerminal);
    }

    private InventoryProfile getProfilesFromDatabase(AccountType accountType, Terminal theTerminal) {
        InventoryProfile profile = PersistenceManager.getObject(InventoryProfile.class, "SELECT inventory_profile.* FROM inventory_profile, config_display_profile, config_terminal_location, config_terminal WHERE config_display_profile.FK_inventory_profile = inventory_profile.ID AND config_display_profile.FK_config_terminal_location = config_terminal_location.ID AND config_terminal.FK_config_terminal_location = config_terminal_location.ID AND config_display_profile.system_state = 'ACTIVE' AND inventory_profile.system_state = 'ACTIVE' AND config_display_profile.account_type = ? AND config_terminal.ID = ?", new Object[]{accountType.toString(), theTerminal.getID()});
        if (profile == null) {
            profile = PersistenceManager.getObject(InventoryProfile.class, "SELECT inventory_profile.* FROM inventory_profile, config_display_profile, config_terminal_location, config_terminal WHERE config_display_profile.FK_inventory_profile = inventory_profile.ID AND config_display_profile.FK_config_terminal_location = config_terminal_location.ID AND config_terminal.FK_config_terminal_location = config_terminal_location.ID AND config_display_profile.system_state = 'ACTIVE' AND inventory_profile.system_state = 'ACTIVE' AND config_display_profile.account_type = ? AND config_terminal.ID = ?", new Object[]{AccountType.allType.toString(), theTerminal.getID()});
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheTerminalProfiles(Terminal currentTerminal) {
        HashMap accTypeProfileMap = new HashMap();
        Iterator<AccountType> accountTypeIt = currentTerminal.getSupportedAccountTypes().iterator();
        HashMap<Long, InventoryProfile> profileSet = new HashMap<Long, InventoryProfile>();
        while (accountTypeIt.hasNext()) {
            AccountType currentAccType = accountTypeIt.next();
            InventoryProfile profile = this.profileCache.containsKey(currentTerminal) && this.profileCache.get(currentTerminal).containsKey(currentAccType) && this.profileCache.get(currentTerminal).get(currentAccType) != null ? this.profileCache.get(currentTerminal).get(currentAccType) : this.getProfilesFromDatabase(currentAccType, currentTerminal);
            if (profile == null) {
                if (AccountType.barTabType.equals(currentAccType)) {
                    profile = (InventoryProfile)accTypeProfileMap.get(AccountType.tableType);
                }
                if (profile == null && (profile = this.getProfilesFromDatabase(AccountType.allType, currentTerminal)) == null) {
                    throw new IllegalStateException("No profile linked for Account Type : " + currentAccType + " on terminal : " + currentTerminal + ", terminal has location : " + currentTerminal.getLocation());
                }
            }
            profileSet.put(profile.getID(), profile);
            accTypeProfileMap.put(currentAccType, profileSet.get(profile.getID()));
            if (!AccountType.tableType.equals(currentAccType)) continue;
            accTypeProfileMap.put(AccountType.barTabType, profileSet.get(profile.getID()));
        }
        Object object = this.cacheMutex;
        synchronized (object) {
            this.profileCache.put(currentTerminal, accTypeProfileMap);
        }
    }

    public Vector<InventoryProfile> getAllProfiles() {
        List<InventoryProfile> objects = PersistenceManager.getObjectList(InventoryProfile.class, "SELECT * FROM inventory_profile WHERE system_state = 'ACTIVE' ORDER BY Name", null);
        return new Vector<InventoryProfile>(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryGroup> getProfileGroups(InventoryProfile toGet) {
        Object object = this.cacheMutex;
        synchronized (object) {
            if (this.groupCache.containsKey(toGet)) {
                return this.groupCache.get(toGet);
            }
            List<InventoryGroup> groups = PersistenceManager.getObjectList(InventoryGroup.class, "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.FK_inventory_profile = ? AND inventory_group.FK_inventory_group IS NULL AND inventory_group.system_state = 'ACTIVE' ORDER BY inventory_group.sequence", new Object[]{toGet.getID()});
            return groups;
        }
    }

    public List<InventoryGroup> getProfileGroups(TriggerActivationContext context, InventoryProfile toGet) {
        List<InventoryGroup> list = this.getProfileGroups(toGet);
        list = new ArrayList<InventoryGroup>(TriggerActivationHelper.getActive(list, context));
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryGroup> getProfileGroups(InventoryProfile profile, boolean expandSubGroups) {
        Object object = this.cacheMutex;
        synchronized (object) {
            List<InventoryGroup> groups = null;
            groups = this.getRootGroups(profile);
            if (expandSubGroups) {
                groups = this.expandSubGroups(groups);
            }
            return groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InventoryGroup> getRootGroups(InventoryProfile profile) {
        List<InventoryGroup> groups;
        Object object = this.cacheMutex;
        synchronized (object) {
            groups = this.groupCache.containsKey(profile) ? this.groupCache.get(profile) : PersistenceManager.getObjectList(InventoryGroup.class, "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.FK_inventory_profile = ? AND inventory_group.FK_inventory_group IS NULL AND inventory_group.system_state = 'ACTIVE' ORDER BY inventory_group.sequence", new Object[]{profile.getID()});
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InventoryGroup> expandSubGroups(List<InventoryGroup> groupsToExpand) {
        ArrayList<InventoryGroup> expandedGroups = new ArrayList<InventoryGroup>(groupsToExpand.size() * 2);
        Object object = this.cacheMutex;
        synchronized (object) {
            for (InventoryGroup group : groupsToExpand) {
                expandedGroups.add(group);
                expandedGroups.addAll(group.getRecursiveSubGroups());
            }
        }
        return expandedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryItem> getQuickSaleItems(InventoryProfile inventoryProfile, Terminal localTerminal) {
        Object object = this.cacheMutex;
        synchronized (object) {
            if (this.quickItemsCache.containsKey(inventoryProfile)) {
                return this.quickItemsCache.get(inventoryProfile);
            }
            List<InventoryItem> quickItems = this.getQuickSaleItems(inventoryProfile);
            if (localTerminal.getMenuCaching()) {
                this.quickItemsCache.put(inventoryProfile, quickItems);
            }
            return quickItems;
        }
    }

    List<InventoryItem> getQuickSaleItems(InventoryProfile profile) {
        String sql = Query.select(InventoryItem.class).equals(InventoryItem.Properties.QUICK_SALE, 1.0).equals(InventoryGroup.Properties.PROFILE, profile.getID()).linkUsing(InventoryItem.Properties.MENU_GROUP).linkUsing(InventoryGroup.Properties.PROFILE).active(InventoryItem.class).orderBy(InventoryItem.Properties.SEQUENCE).toString();
        return PersistenceManager.getObjectList(InventoryItem.class, sql, new Object[0]);
    }

    public List<String> getActiveGroupNames(InventoryProfile profile) {
        ArrayList<String> states = new ArrayList<String>();
        states.add("INACTIVE");
        states.add("ACTIVE");
        String sql = Query.select(InventoryGroup.Properties.LABEL, "name").wherePropertyIn(InventoryGroup.Properties.SYSTEM_STATE, states).equals(InventoryGroup.Properties.PROFILE, profile.getID()).toString();
        Object[][] rs = PersistenceManager.getPersistenceDelegate().executeQuery(sql, new Object[0]);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (int i = 0; i < rs.length; ++i) {
            groupNames.add((String)rs[i][0]);
        }
        return groupNames;
    }

    public List<InventoryGroup> getAvailableGroups(InventoryProfile profile) {
        ArrayList<String> states = new ArrayList<String>();
        states.add("INACTIVE");
        states.add("ACTIVE");
        String sql = Query.select(InventoryGroup.class).wherePropertyIn(InventoryGroup.Properties.SYSTEM_STATE, states).isNull(InventoryGroup.Properties.PARENT_GROUP).equals(InventoryGroup.Properties.PROFILE, profile.getID()).orderBy(InventoryGroup.Properties.SEQUENCE).toString();
        return PersistenceManager.getObjectList(InventoryGroup.class, sql, null);
    }

    public InventoryProfile findProfile(String name) {
        String sql = Query.select(InventoryProfile.class).active(InventoryProfile.class).equals(InventoryProfile.Properties.LABEL, name).toString();
        return PersistenceManager.getObject(InventoryProfile.class, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldCacheMenus(Terminal localTerminal) {
        boolean updates = SystemCurrentInfo.getInstance().needsUpdate();
        boolean locationsDifferent = false;
        Object object = this.cacheMutex;
        synchronized (object) {
            locationsDifferent = !localTerminal.getLocation().equals(this.cachedLocation);
        }
        return localTerminal.getMenuCaching() && (updates || locationsDifferent);
    }

    public Task cacheMenuGroups(Terminal localTerminal) {
        PersistenceManager.getInstance().clearLocalCaches();
        List<AccountType> types = localTerminal.getSupportedAccountTypes();
        if (types.size() == 0) {
            return new NullTask("Empty Cache Menu Task", "Terminal does not have any supported account types " + localTerminal);
        }
        StringBuffer accountTypes = new StringBuffer();
        Iterator<AccountType> typesIt = types.iterator();
        while (typesIt.hasNext()) {
            accountTypes.append("'");
            accountTypes.append(((Object)typesIt.next()).toString());
            accountTypes.append("'");
            if (!typesIt.hasNext()) continue;
            accountTypes.append(",");
        }
        String SQL2 = "SELECT DISTINCT inventory_group.ID FROM inventory_group, inventory_profile, config_display_profile WHERE config_display_profile.account_type IN (" + accountTypes.toString() + ") AND config_display_profile.FK_config_terminal_location = ? AND config_display_profile.FK_inventory_profile = inventory_profile.ID AND inventory_group.FK_inventory_profile = inventory_profile.ID AND inventory_group.FK_inventory_group IS NULL AND config_display_profile.system_state = 'ACTIVE' AND inventory_profile.system_state = 'ACTIVE' AND inventory_group.system_state ='ACTIVE'";
        Object[][] groupIDs = PersistenceManager.getPersistenceDelegate().executeQuery(SQL2, new Object[]{localTerminal.getLocation().getID()});
        int numGroups = groupIDs.length;
        return new CacheMenuTask(numGroups, localTerminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.cacheMutex;
        synchronized (object) {
            this.quickItemsCache.clear();
            this.groupCache.clear();
            this.cachedLocation = null;
            this.profileCache.clear();
        }
    }

    Object getCacheMutex() {
        return this.cacheMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache(Map<InventoryProfile, List<InventoryItem>> newQuickItemCache, Map<InventoryProfile, List<InventoryGroup>> newCache, TerminalLocation location) {
        Object object = this.cacheMutex;
        synchronized (object) {
            this.quickItemsCache.clear();
            this.quickItemsCache = newQuickItemCache;
            this.groupCache.clear();
            this.groupCache = newCache;
            this.cachedLocation = location;
        }
    }

    public InventoryProfile getFirstProfile() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryProfile.class).active(InventoryProfile.class).limit(1).orderBy(InventoryProfile.Properties.ID);
        InventoryProfile firstProfile = PersistenceManager.getObject(InventoryProfile.class, oQuery.toString(), null);
        if (firstProfile == null) {
            throw new IllegalStateException("No active InventoryProfiles to select!");
        }
        return firstProfile;
    }
}

