/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesRemove;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_remove")
@AccessType(value="property")
public class InventoryRemove
extends Modification
implements SaveableChild,
Inventory,
ExportableObject,
InventoryRemovable<SalesRemove> {
    public static final Props Properties = new Props();
    private int sequence;
    private Reference<InventoryItem> item;
    private String systemState;
    private ModificationSize modSize;
    private Long masterId;
    private boolean availableOnline;

    public InventoryRemove() {
        this.item = this.createReference(InventoryRemove.Properties.ITEM);
        this.systemState = "ACTIVE";
        this.availableOnline = true;
    }

    public InventoryRemove(InventoryRemove copy) {
        super(copy);
        this.item = this.createReference(InventoryRemove.Properties.ITEM);
        this.systemState = "ACTIVE";
        this.modSize = ModificationSize.getDefaultSize();
        this.setAvailableOnline(copy.isAvailableOnline());
    }

    @Override
    @Transient
    public ModificationSize getModificationSize() {
        if (this.modSize == null) {
            this.modSize = ModificationSize.getDefaultSize();
        }
        return this.modSize;
    }

    @Override
    public void setModificationSize(ModificationSize newSize) {
        this.modSize = newSize;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = "DELETED";
        this.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item")
    public InventoryItem getItem() {
        return this.item.get();
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public void setItem(InventoryItem item) {
        this.item.set(item);
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="available_online")
    public boolean isAvailableOnline() {
        return this.availableOnline;
    }

    public void setAvailableOnline(boolean availableOnline) {
        this.availableOnline = availableOnline;
    }

    @Override
    public SalesRemove createSalesRemove(SalesComponent component) {
        return new SalesRemove(component, this);
    }

    public static class Props
    extends Modification.Props {
        public PropertiedObject.Property ITEM;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property AVAILABLE_ONLINE;
    }
}

