/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.queries.DomainQueries;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_special")
@AccessType(value="property")
public class InventorySpecial
extends PersistentObject
implements Inventory,
Saveable,
ExportableObject {
    public static final Props Properties = new Props();
    private String description = "Insert Description";
    private String systemState = "ACTIVE";
    private Reference<InventoryItem> item;
    private Long masterId;

    public InventorySpecial() {
        this.item = this.createReference(InventorySpecial.Properties.ITEM);
    }

    @Transient
    public String getName() {
        return this.getItem().getLabel();
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item")
    public InventoryItem getItem() {
        return this.item.get();
    }

    public static List<InventorySpecial> getActiveSpecials() {
        return DomainQueries.Helper.getAllActive(InventorySpecial.class);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setItem(InventoryItem invItem) {
        this.item.set(invItem);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String newState) {
        this.systemState = newState;
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DESCRIPTION;
        public PropertiedObject.Property<InventoryItem> ITEM;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property MASTER_ID;
    }
}

