/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.units.SalesQuantity;
import java.util.Map;

public enum InventoryWeightUnit {
    NA("", 1),
    Grams("g", 1000),
    Kilograms("kg", 1);

    public static final Map<String, InventoryWeightUnit> register;
    private String display;
    private int factor;

    private InventoryWeightUnit(String displayString, int kgFactor) {
        this.display = displayString;
        this.factor = kgFactor;
    }

    public final int getFactor() {
        return this.factor;
    }

    public final String getDisplay() {
        return this.display;
    }

    public static String convertToString(InventoryWeightUnit unit, SalesQuantity qty) {
        if (NA.equals((Object)unit)) {
            return String.valueOf(qty);
        }
        StringBuilder SB = new StringBuilder();
        SB.append(qty.multiply(SalesQuantity.valueOf(unit.getFactor())).weightedQtyToString()).append(" ").append(unit.getDisplay());
        return SB.toString();
    }

    static {
        register = PersistentEnumeration.buildRegister(InventoryWeightUnit.values());
    }
}

