/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.persistence.Auditable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.finance.tax.TaxMan;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.config.Quantity;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
public class ItemSummary
extends PersistentSummaryObject
implements Saveable,
Auditable,
StockLinkable<StockInventoryUsageLink> {
    private static final String SPACING_ITEM = ".";
    public static final Props Properties = new Props();
    private Long theId;
    private Long masterId;
    private boolean createNewItemOnNameChange = false;
    private Reference<InventoryItem> inventoryItem;
    private Reference<UnitPriceLevel> unitPriceLevel;
    private Reference<InventoryGroup> inventoryGroup;
    private String name;
    private String shortName;
    private String description;
    private Reference<InventoryItemPortion> portion;
    private PersistentWriteableList<InventoryRemove> minuses;
    private Reference<InventoryCategory> category;
    private Reference<PrinterGroup> printerGroup;
    private String icon;
    private String recipe;
    private String ingredientIcon;
    private Color foregroundColor;
    private Color backgroundColor;
    private Integer sequence;
    private String systemState;
    private Price price;
    private InventoryWeightUnit inventoryWeightUnit;
    private Reference<InventoryItemSize> size;
    private Reference<InventoryAddGroup> plusGroup;
    private List<InventoryOptionGroup> optionGroups;
    private List<InventoryBarcode> barcodes;
    private Reference<InventoryItemUnit> inventoryItemUnit;
    private Reference<PriceLevel> priceLevel;
    private Reference<InventoryProfile> profile;
    private List<TaxCode> taxCodes;
    private List<InventoryDefaultAdd> defAdds;
    private List<InventoryDefaultOption> defOptions;
    private Price priceExTax;
    private List<InventoryOptionGroupLink> optionGroupLinks;
    private List<PropertiedObject.Property> propertyHasChanged;
    private final Map<StockItem, Quantity> stockUsageMap;
    private Map<InventoryOptionGroupLink, InventoryOptionGroup> origOptionLinkGroups;
    private Integer menuIdentifier;
    private int loyaltyAdd;
    private int loyaltyRedeem;
    private int numPatrons;
    private List<InventoryRemove> localMinuses;
    private Boolean localOpenPrice;
    private Boolean localAutoItemNote;

    @Override
    @Transient
    public String getAuditName() {
        return "Item";
    }

    @Override
    @Transient
    public String getLogDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("MenuSection(").append(this.getInventoryGroup()).append("),").append("Name(").append(this.getName()).append("),").append("Category(").append(this.getCategory()).append("),").append("PrinterGroup(").append(this.getPrinterGroup()).append("),").append("Price(").append(this.getPrice()).append("),").append("TaxCodes(").append(this.getTaxCodes()).append("),").append("Size(").append(this.getSize()).append(")");
        return sb.toString();
    }

    public static final PropertiedObject.Property[] getPortionProperties() {
        return new PropertiedObject.Property[]{ItemSummary.Properties.PORTION};
    }

    public static final PropertiedObject.Property[] getColorProperties() {
        return new PropertiedObject.Property[]{ItemSummary.Properties.BACKGROUND_COLOR, ItemSummary.Properties.FOREGROUND_COLOR, ItemSummary.Properties.SEQUENCE};
    }

    public static final PropertiedObject.Property[] getExtendedProperties() {
        return new ArrayList<PropertiedObject.Property>(){
            {
                this.add(ItemSummary.Properties.ICON);
                this.add(ItemSummary.Properties.INGREDIENT_ICON);
                this.add(ItemSummary.Properties.RECIPE);
                this.add(ItemSummary.Properties.SHORT_NAME);
                this.add(ItemSummary.Properties.DESCRIPTION);
                this.add(ItemSummary.Properties.OPEN_PRICE);
                this.add(ItemSummary.Properties.AUTO_ITEM_NOTE);
                this.add(ItemSummary.Properties.MINUSES);
                if (SystemProperty.getInstance().isStockControlEnabled()) {
                    this.add(ItemSummary.Properties.INGREDIENTS);
                }
                this.add(ItemSummary.Properties.SYSTEM_STATE);
                this.add(ItemSummary.Properties.PLUS_GROUP);
                this.add(ItemSummary.Properties.OPTION_GROUPS);
                this.add(ItemSummary.Properties.BARCODES);
                this.add(ItemSummary.Properties.INVENTORY_WEIGHT_UNIT);
                this.add(ItemSummary.Properties.NUM_PATRONS);
                this.add(ItemSummary.Properties.DEFAULT_ADDS);
                this.add(ItemSummary.Properties.DEFAULT_OPTIONS);
            }
        }.toArray(new PropertiedObject.Property[0]);
    }

    public static final PropertiedObject.Property[] getLoyaltyProperties() {
        return new PropertiedObject.Property[]{ItemSummary.Properties.LOYALTY_ADD, ItemSummary.Properties.LOYALTY_REDEEM};
    }

    public ItemSummary() {
        this.inventoryItem = this.createReference(ItemSummary.Properties.INVENTORY_ITEM);
        this.unitPriceLevel = this.createReference(ItemSummary.Properties.UNIT_PRICE_LEVEL);
        this.inventoryGroup = this.createReference(ItemSummary.Properties.INVENTORY_GROUP);
        this.portion = this.createReference(ItemSummary.Properties.PORTION);
        this.minuses = (PersistentWriteableList)this.createList(ItemSummary.Properties.MINUSES);
        this.category = this.createReference(ItemSummary.Properties.CATEGORY);
        this.printerGroup = this.createReference(ItemSummary.Properties.PRINTER_GROUP);
        this.systemState = "ACTIVE";
        this.size = this.createReference(ItemSummary.Properties.SIZE);
        this.plusGroup = this.createReference(ItemSummary.Properties.PLUS_GROUP);
        this.optionGroups = null;
        this.barcodes = null;
        this.inventoryItemUnit = this.createReference(ItemSummary.Properties.INVENTORY_ITEM_UNIT);
        this.priceLevel = this.createReference(ItemSummary.Properties.PRICE_LEVEL);
        this.profile = this.createReference(ItemSummary.Properties.PROFILE);
        this.taxCodes = null;
        this.optionGroupLinks = null;
        this.propertyHasChanged = new ArrayList<PropertiedObject.Property>();
        this.stockUsageMap = new HashMap<StockItem, Quantity>();
        this.origOptionLinkGroups = new HashMap<InventoryOptionGroupLink, InventoryOptionGroup>();
        this.menuIdentifier = null;
        this.numPatrons = 0;
        this.localMinuses = null;
    }

    public ItemSummary(ItemSummary instance) {
        this();
        this.setBackgroundColor(instance.getBackgroundColor());
        this.setBarcodes(instance.getBarcodes());
        this.setCategory(instance.getCategory());
        this.setForegroundColor(instance.getForegroundColor());
        this.setInventoryGroup(instance.getInventoryGroup());
        this.setName(instance.getName());
        this.setIcon(instance.getIcon());
        this.setRecipe(instance.getRecipe());
        this.setIngredientIcon(instance.getIngredientIcon());
        this.setShortName(instance.getShortName());
        this.setDescription(instance.getDescription());
        this.setPlusGroup(instance.getPlusGroup());
        this.setPortion(instance.getPortion());
        this.setPrice(instance.getPrice());
        this.setPriceLevel(instance.getPriceLevel());
        this.setPriceExTax(instance.getPriceExTax());
        this.setPrinterGroup(instance.getPrinterGroup());
        this.setProfile(instance.getProfile());
        this.setSequence(instance.getSequence());
        this.setSize(instance.getSize());
        this.setSystemState(instance.getSystemState());
        this.setTaxCodes(instance.getTaxCodes());
        this.setInventoryWeightUnit(instance.inventoryWeightUnit);
        this.setNumPatrons(instance.numPatrons);
        this.setOptionGroupLinks(instance.getOptionGroupLinks());
        this.origOptionLinkGroups.putAll(instance.origOptionLinkGroups);
        this.localMinuses = new ArrayList<InventoryRemove>();
        for (InventoryRemove remove : instance.getMinuses()) {
            this.localMinuses.add(new InventoryRemove(remove));
        }
    }

    public void setShortName(String shortName2) {
        this.shortName = shortName2;
    }

    public void setCreateNewItemOnNameChange(boolean newItemOnNameChange) {
        this.createNewItemOnNameChange = newItemOnNameChange;
    }

    @Transient
    public boolean isCreateNewItemOnNameChange() {
        return this.createNewItemOnNameChange;
    }

    @Override
    public void setStockUsage(StockItem stockItem, Quantity qty) {
        this.stockUsageMap.put(stockItem, qty);
    }

    @Override
    public void setStockUsage(StockItem stockItem, Quantity qty, boolean isFixedQty, boolean isRemoveable) {
        this.setStockUsage(stockItem, qty);
    }

    @Transient
    public List getStockUsage() {
        if (this.inventoryItemUnit.get() == null) {
            throw new IllegalStateException("Cannot retrieve the stock usage from " + this.getName() + " because the item is not persisted.");
        }
        InventoryItemUnit unit = this.inventoryItemUnit.get();
        return unit.getStockInventoryUsageLinks();
    }

    @Column(name="RGB_background")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color background) {
        this.backgroundColor = background;
        if (this.getInventoryItemObject() != null) {
            this.getInventoryItemObject().setBackgroundColor(background);
        }
    }

    @Transient
    public List<InventoryBarcode> getBarcodes() {
        if (this.barcodes == null) {
            this.barcodes = new ArrayList<InventoryBarcode>();
            if (this.inventoryItemUnit.get() != null) {
                ArrayList<String> barcodesAsStrings = new ArrayList<String>(this.inventoryItemUnit.get().getBarcodes());
                for (String barcodeValue : barcodesAsStrings) {
                    InventoryBarcode barcode = InventoryBarcode.getBarcode(barcodeValue);
                    this.barcodes.add(barcode);
                }
            }
        }
        return this.barcodes;
    }

    public void setBarcodes(Collection<InventoryBarcode> newBarcodes) {
        if (newBarcodes == null) {
            this.barcodes = null;
        } else {
            this.getBarcodes().clear();
            this.getBarcodes().addAll(newBarcodes);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_category", referencedColumnName="ID")
    public InventoryCategory getCategory() {
        return this.category.get();
    }

    public void setCategory(InventoryCategory newCategory) {
        this.category.set(newCategory);
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String newIcon) {
        this.icon = newIcon;
    }

    @Column(name="recipe")
    public String getRecipe() {
        return this.recipe;
    }

    public void setRecipe(String html) {
        this.recipe = html;
    }

    @Column(name="ingredient_icon")
    public String getIngredientIcon() {
        return this.ingredientIcon;
    }

    public void setIngredientIcon(String newIcon) {
        this.ingredientIcon = newIcon;
    }

    @Column(name="RGB_foreground")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foreground) {
        this.foregroundColor = foreground;
        if (this.getInventoryItemObject() != null) {
            this.getInventoryItemObject().setForegroundColor(foreground);
        }
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_group", referencedColumnName="ID")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setInventoryGroup(InventoryGroup newGroup) {
        this.inventoryGroup.set(newGroup);
    }

    @Transient
    public List<InventoryRemove> getMinuses() {
        if (this.localMinuses == null) {
            return new ArrayList<InventoryRemove>(this.minuses);
        }
        return new ArrayList<InventoryRemove>(this.localMinuses);
    }

    public void setMinuses(List<InventoryRemove> newMinuses) {
        this.localMinuses = newMinuses != null ? new ArrayList<InventoryRemove>(newMinuses) : null;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Column(name="short_name")
    public String getShortName() {
        return this.shortName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Transient
    public List<InventoryOptionGroup> getOptionGroups() {
        if (this.optionGroups != null) {
            this.optionGroups.clear();
        } else {
            this.optionGroups = new ArrayList<InventoryOptionGroup>();
        }
        this.optionGroups.addAll(this.getGroupsFromLinks(this.getOptionGroupLinks()));
        return this.optionGroups;
    }

    protected void setOptionGroups(Collection<InventoryOptionGroup> newOptionGroups) {
        this.optionGroups = newOptionGroups != null ? new ArrayList<InventoryOptionGroup>(newOptionGroups) : null;
    }

    public InventoryOptionGroupLink addOptionGroup(InventoryOptionGroup group) {
        int highest = 0;
        for (InventoryOptionGroupLink link : this.getOptionGroupLinks()) {
            if (group.equals(link.getOptionGroup())) {
                return link;
            }
            highest = Math.max(link.getSequence(), highest);
        }
        InventoryOptionGroupLink link = new InventoryOptionGroupLink(this.inventoryItemUnit.get(), group);
        link.setSequence(highest + 1);
        this.getOptionGroupLinks().add(link);
        return link;
    }

    @Transient
    public List<InventoryOptionGroupLink> getOptionGroupLinks() {
        if (this.optionGroupLinks == null) {
            this.optionGroupLinks = this.inventoryItemUnit.get() != null ? new ArrayList<InventoryOptionGroupLink>(this.inventoryItemUnit.get().getOptionGroupLinks()) : new ArrayList<InventoryOptionGroupLink>();
            this.origOptionLinkGroups.clear();
            for (InventoryOptionGroupLink link : this.optionGroupLinks) {
                this.origOptionLinkGroups.put(link, link.getOptionGroup());
            }
        }
        return this.optionGroupLinks;
    }

    public void setOptionGroupLinks(Collection<InventoryOptionGroupLink> newOptionGroupLinks) {
        this.optionGroupLinks = newOptionGroupLinks != null ? new ArrayList<InventoryOptionGroupLink>(newOptionGroupLinks) : null;
        SequentialComparator comparator = new SequentialComparator();
        comparator.addComparator(Sequenced.SequenceComparator.getInst());
        Collections.sort(this.optionGroupLinks, comparator);
        if (this.optionGroupLinks != null && !this.optionGroupLinks.isEmpty()) {
            int highest = this.optionGroupLinks.get(0).getSequence();
            for (InventoryOptionGroupLink link : this.optionGroupLinks) {
                if (link.getSequence() < highest) {
                    link.setSequence(highest + 1);
                }
                highest = link.getSequence();
            }
        }
        this.setOptionGroups(this.getGroupsFromLinks(this.optionGroupLinks));
    }

    @Transient
    private List<InventoryOptionGroup> getGroupsFromLinks(List<InventoryOptionGroupLink> optionsLinksList) {
        ArrayList<InventoryOptionGroup> groupList = new ArrayList<InventoryOptionGroup>();
        if (optionsLinksList != null) {
            for (InventoryOptionGroupLink link : this.optionGroupLinks) {
                groupList.add(link.getOptionGroup());
            }
        }
        return groupList;
    }

    private void setOptionGroupLinksUsing(List<InventoryOptionGroupLink> newOptionGroupLinks, InventoryItemUnit inventoryItemUnitObject) {
        ArrayList<InventoryOptionGroupLink> removeList = new ArrayList<InventoryOptionGroupLink>(inventoryItemUnitObject.getOptionGroupLinks());
        ArrayList<InventoryOptionGroupLink> insertList = new ArrayList<InventoryOptionGroupLink>();
        for (InventoryOptionGroupLink link : newOptionGroupLinks) {
            if (link.getItemUnit() != inventoryItemUnitObject) {
                InventoryOptionGroupLink newLink = new InventoryOptionGroupLink(link);
                newLink.setItemUnit(inventoryItemUnitObject);
                insertList.add(newLink);
                continue;
            }
            insertList.add(link);
        }
        block1: for (InventoryOptionGroupLink origOptionLink : inventoryItemUnitObject.getOptionGroupLinks()) {
            for (InventoryOptionGroupLink newOptionLink : newOptionGroupLinks) {
                if (!origOptionLink.equals(newOptionLink)) continue;
                if (this.origOptionLinkGroups.containsKey(origOptionLink) && !this.origOptionLinkGroups.get(origOptionLink).equals(newOptionLink.getOptionGroup())) {
                    insertList.add(new InventoryOptionGroupLink(newOptionLink));
                    continue block1;
                }
                removeList.remove(origOptionLink);
            }
        }
        insertList.removeAll(removeList);
        for (InventoryOptionGroupLink newOptionLink : removeList) {
            newOptionLink = (InventoryOptionGroupLink)PersistenceManager.reacquire(newOptionLink);
        }
        inventoryItemUnitObject.setOptionGroups(insertList);
        this.setOptionGroups(this.getGroupsFromLinks(newOptionGroupLinks));
    }

    @Transient
    public InventoryItemUnit getInventoryItemUnitObject() {
        return this.inventoryItemUnit.get();
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_add_group")
    public InventoryAddGroup getPlusGroup() {
        return this.plusGroup.get();
    }

    public void setPlusGroup(InventoryAddGroup newPlusGroup) {
        this.plusGroup.set(newPlusGroup);
        this.propertyHasChanged.add(ItemSummary.Properties.PLUS_GROUP);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_portion", referencedColumnName="ID")
    public InventoryItemPortion getPortion() {
        return this.portion.get();
    }

    public void setPortion(InventoryItemPortion newPortion) {
        this.portion.set(newPortion);
    }

    @Column(name="price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price newPrice) {
        this.price = newPrice;
    }

    @Column(name="sequence")
    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer newSequence) {
        this.sequence = newSequence;
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_size", referencedColumnName="ID")
    public InventoryItemSize getSize() {
        return this.size.get();
    }

    public void setSize(InventoryItemSize newSize) {
        this.size.set(newSize);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    public void setPrinterGroup(PrinterGroup newPrinterGroup) {
        this.printerGroup.set(newPrinterGroup);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_printer_group", referencedColumnName="ID")
    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_price_level", referencedColumnName="ID")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    public void setPriceLevel(PriceLevel newPriceLevel) {
        this.priceLevel.set(newPriceLevel);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_profile", referencedColumnName="ID")
    public InventoryProfile getProfile() {
        return this.profile.get();
    }

    public void setProfile(InventoryProfile newProfile) {
        this.profile.set(newProfile);
    }

    @Transient
    public List<TaxCode> getTaxCodes() {
        if (this.taxCodes == null) {
            this.taxCodes = this.inventoryItemUnit.isNull() || this.getInventoryItemUnitObject() == null ? new ArrayList<TaxCode>(TaxCode.getDefaultTaxCodes()) : new ArrayList<TaxCode>(this.getInventoryItemUnitObject().getTaxCodes());
        }
        return this.taxCodes;
    }

    public void setTaxCodes(List<TaxCode> newTaxCodes) {
        this.taxCodes = newTaxCodes != null && !newTaxCodes.isEmpty() ? new ArrayList<TaxCode>(newTaxCodes) : new ArrayList<TaxCode>(TaxCode.getDefaultTaxCodes());
    }

    @Column(name="menu_identifier")
    public Integer getMenuIdentifier() {
        return this.menuIdentifier;
    }

    public void setMenuIdentifier(Integer identifier) {
        this.menuIdentifier = identifier;
    }

    @Transient
    public boolean hasDuplicateBarcodes() {
        if (this.getBarcodes() != null) {
            for (InventoryBarcode itemBarcode : this.getBarcodes()) {
                List<InventoryItemUnit> itemUnits = itemBarcode.getItemUnits();
                if (itemUnits.isEmpty()) continue;
                for (InventoryItemUnit itemUnit : itemUnits) {
                    if (itemUnit.getItem().getLabel().equals(this.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void delete() {
        this.findItem();
        InventoryItem inventoryItemObject = this.getInventoryItemObject();
        if (inventoryItemObject == null) {
            return;
        }
        InventoryItemPortion portionObject = this.getPortion();
        if (portionObject == null) {
            portionObject = InventoryItemPortion.findPortion("Whole");
        }
        InventoryItemUnit inventoryItemUnitObject = inventoryItemObject.getUnit(this.getSize(), portionObject);
        inventoryItemObject.removeUnit(inventoryItemUnitObject);
        if (inventoryItemObject.getUnits().isEmpty()) {
            inventoryItemObject.delete();
        } else {
            inventoryItemObject.save();
        }
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if ("DELETED".equals(this.getSystemState())) {
            this.delete();
            return;
        }
        this.checkPreConditions();
        this.createElementsIfNeeded();
        this.createItemIfNeeded();
        this.createInventoryItemUnitIfNeeded();
        InventoryItemUnit inventoryItemUnitObject = this.getInventoryItemUnitObject();
        UnitPriceLevel unitPriceLevelObject = this.createUnitPriceLevelIfNeeded(inventoryItemUnitObject);
        this.getPriceLevel().addUnitPriceLevel(unitPriceLevelObject);
        inventoryItemUnitObject.addUnitPriceLevel(unitPriceLevelObject);
        this.maintainItemSystemState(this.getInventoryItemObject());
        this.createBarcodes(inventoryItemUnitObject);
        this.updateDefaultMods();
        this.getInventoryItemObject().addUnit(this.getInventoryItemUnitObject());
        this.getInventoryItemObject().save();
        unitPriceLevelObject.save();
        this.unitPriceLevel.set(unitPriceLevelObject);
        this.theId = this.unitPriceLevel.getID();
        this.inventoryItemUnit.set(inventoryItemUnitObject);
        this.propertyHasChanged.clear();
    }

    private void createBarcodes(InventoryItemUnit inventoryItemUnitObject) {
        if (this.barcodes != null) {
            List<String> existingBarcodes = inventoryItemUnitObject.getBarcodes();
            for (InventoryBarcode barcode : this.getBarcodes()) {
                if (existingBarcodes.contains(barcode.getBarcode())) continue;
                InventoryItemUnit.addUnitBarcode(barcode.getBarcode(), inventoryItemUnitObject);
            }
            for (String existingCode : existingBarcodes) {
                if (this.listContainsBarcode(existingCode, this.getBarcodes())) continue;
                InventoryItemUnit.deleteUnitBarcode(existingCode, inventoryItemUnitObject);
            }
        }
    }

    private boolean listContainsBarcode(String barcode, List barcodeList) {
        for (InventoryBarcode toCheck : barcodeList) {
            if (!toCheck.getBarcode().equals(barcode)) continue;
            return true;
        }
        return false;
    }

    private void addRemoveMinuses(InventoryItem item) {
        item.setMinuses(this.localMinuses);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_item", referencedColumnName="ID")
    public InventoryItem getInventoryItemObject() {
        return this.inventoryItem.get();
    }

    protected void setInventoryItemObject(InventoryItem item) {
        this.inventoryItem.set(item);
    }

    @Transient
    public Reference<InventoryItem> getInventoryItem() {
        return this.inventoryItem;
    }

    @Transient
    public Reference<InventoryItemUnit> getInventoryItemUnit() {
        return this.inventoryItemUnit;
    }

    private void checkPreConditions() throws IllegalStateException {
        this.checkNotNull(ItemSummary.Properties.SYSTEM_STATE, ItemSummary.Properties.NAME, ItemSummary.Properties.INVENTORY_GROUP, ItemSummary.Properties.PRICE, ItemSummary.Properties.PRICE_LEVEL, ItemSummary.Properties.PROFILE, ItemSummary.Properties.SIZE);
        this.checkLabelNotEmpty(ItemSummary.Properties.SIZE, ItemSummary.Properties.CATEGORY, ItemSummary.Properties.PORTION, ItemSummary.Properties.INVENTORY_GROUP, ItemSummary.Properties.PRINTER_GROUP);
        if (this.getInventoryGroup() != null && this.getInventoryGroup().getProfile() != null && !this.getInventoryGroup().getProfile().equals(this.getProfile())) {
            throw new IllegalStateException("The group belong to the " + this.getInventoryGroup().getProfile() + " profile while the item is in the " + this.getProfile() + SPACING_ITEM);
        }
    }

    private void checkNotNull(PropertiedObject.Property ... props) {
        for (PropertiedObject.Property prop : props) {
            if (prop.resolveValue(this) != null) continue;
            throw new IllegalStateException("The " + prop.getUserVisibleLabel() + " is compulsory and must not be null.");
        }
    }

    private void checkLabelNotEmpty(PropertiedObject.Property<? extends PersistentDisplayableObject> ... props) {
        for (PropertiedObject.Property<? extends PersistentDisplayableObject> prop : props) {
            PersistentDisplayableObject resolved = prop.resolveValue(this);
            if (resolved == null || !StringUtils.isEmpty(resolved.getLabel())) continue;
            throw new IllegalStateException("The " + prop.getUserVisibleLabel() + " label is compulsory and must not be null or empty.");
        }
    }

    private void createElementsIfNeeded() {
        PersistentDisplayableObject checkExists;
        if (this.getSize() != null && !this.getSize().isPersistent()) {
            checkExists = InventoryItemSize.findSize(this.getSize().getLabel());
            if (checkExists == null) {
                this.getSize().save();
            } else {
                this.setSize((InventoryItemSize)checkExists);
            }
        }
        if (this.getCategory() != null && !this.getCategory().isPersistent()) {
            checkExists = InventoryCategory.getCategoryForName(this.getCategory().getName());
            if (checkExists == null) {
                this.getCategory().save();
            } else {
                this.setCategory((InventoryCategory)checkExists);
            }
        }
        if (this.getPortion() != null && !this.getPortion().isPersistent()) {
            checkExists = InventoryItemPortion.getPortion(this.getPortion().getLabel());
            if (checkExists == null) {
                this.getPortion().save();
            } else {
                this.setPortion((InventoryItemPortion)checkExists);
            }
        }
        if (this.getInventoryGroup() != null && !this.getInventoryGroup().isPersistent()) {
            ArrayDeque<InventoryGroup> groups = new ArrayDeque<InventoryGroup>();
            InventoryGroup group = this.getInventoryGroup();
            do {
                groups.push(group);
            } while ((group = group.getParentGroup()) != null);
            InventoryGroup parent = null;
            while (!groups.isEmpty()) {
                group = (InventoryGroup)groups.pop();
                InventoryGroup newGroup = InventoryGroup.findInventoryGroup(this.getProfile(), group.getLabel());
                if (newGroup == null) {
                    newGroup = new InventoryGroup();
                    newGroup.setLabel(group.getLabel());
                    newGroup.setProfile(this.getProfile());
                    newGroup.save();
                    if (parent != null) {
                        parent.addSubGroup(newGroup);
                        parent.save();
                    }
                }
                parent = newGroup;
            }
            this.setInventoryGroup(parent);
        }
        if (this.getPrinterGroup() != null && !this.getPrinterGroup().isPersistent()) {
            checkExists = PrinterGroup.getPrinterGroup(this.getPrinterGroup().getName());
            if (checkExists == null) {
                this.getPrinterGroup().save();
            } else {
                this.setPrinterGroup((PrinterGroup)checkExists);
            }
        }
    }

    private void createInventoryItemUnitIfNeeded() {
        InventoryItem item = this.getInventoryItemObject();
        InventoryItemUnit inventoryItemUnitObject = null;
        inventoryItemUnitObject = this.findUnit();
        if (inventoryItemUnitObject == null) {
            inventoryItemUnitObject = new InventoryItemUnit(this.getSize());
        }
        if (this.optionGroupLinks != null) {
            this.setOptionGroupLinksUsing(this.optionGroupLinks, inventoryItemUnitObject);
        }
        if (this.getPlusGroup() != null || this.propertyHasChanged.contains(ItemSummary.Properties.PLUS_GROUP)) {
            inventoryItemUnitObject.setPlusGroup(this.getPlusGroup());
        }
        if (inventoryItemUnitObject.getPortion() == null && this.getPortion() == null) {
            this.setPortion(InventoryItemPortion.getPortion("Whole"));
        }
        if (this.getPortion() != null) {
            inventoryItemUnitObject.setPortion(this.getPortion());
        }
        if (this.getSize() != null) {
            inventoryItemUnitObject.setSize(this.getSize());
        }
        if (this.getRecipe() != null) {
            inventoryItemUnitObject.setRecipe(this.getRecipe());
        }
        inventoryItemUnitObject.setNumPatrons(this.numPatrons);
        if (this.stockUsageMap.size() > 0) {
            for (Map.Entry<StockItem, Quantity> entry : this.stockUsageMap.entrySet()) {
                StockItem stockItem = entry.getKey();
                Quantity quantity = entry.getValue();
                inventoryItemUnitObject.setStockUsage(stockItem, quantity);
            }
        }
        if (this.getTaxCodes() != null) {
            inventoryItemUnitObject.setTaxCodes(this.getTaxCodes());
        }
        if (this.getMenuIdentifier() != null) {
            inventoryItemUnitObject.setMenuIdentifier(this.getMenuIdentifier());
        }
        item.addUnit(inventoryItemUnitObject);
        if (this.systemState != null) {
            inventoryItemUnitObject.setSystemState(this.systemState);
        }
        this.inventoryItemUnit.set(inventoryItemUnitObject);
    }

    private InventoryItemUnit findUnit() {
        InventoryItemUnit inventoryItemUnitObject = this.inventoryItemUnit.get();
        if (inventoryItemUnitObject == null) {
            if (this.getPortion() != null) {
                return InventoryItemUnit.findInventoryItemUnit(this.getInventoryItemObject(), this.getSize(), this.getPortion());
            }
            return InventoryItemUnit.findInventoryItemUnit(this.getInventoryItemObject(), this.getSize(), InventoryItemPortion.getPortion("Whole"));
        }
        return inventoryItemUnitObject;
    }

    private void createItemIfNeeded() {
        this.findItem();
        InventoryItem item = this.getInventoryItemObject();
        boolean newlyCreated = false;
        if (item == null) {
            item = new InventoryItem();
            newlyCreated = true;
        }
        this.copyAcrossItemDetails(item);
        if (newlyCreated) {
            this.checkItemIntegrity(item);
        }
        this.inventoryItem.set(item);
    }

    private void maintainItemSystemState(InventoryItem item) {
        if (!this.systemState.equals(item.getSystemState())) {
            if (this.systemState.equals("INACTIVE")) {
                boolean allInactive = true;
                Iterator<InventoryItemUnit> it = item.getUnits().iterator();
                while (it.hasNext() && allInactive) {
                    InventoryItemUnit unit = it.next();
                    if (unit.equals(this.getInventoryItemUnitObject())) continue;
                    allInactive &= unit.getSystemState().equals("INACTIVE");
                }
                if (allInactive) {
                    item.setSystemState("INACTIVE");
                }
            } else if (this.systemState.equals("ACTIVE")) {
                item.setSystemState("ACTIVE");
            }
        }
    }

    private void updateDefaultMods() {
        ArrayList<InventoryDefaultMod> defMods = new ArrayList<InventoryDefaultMod>();
        defMods.addAll(this.getDefaultAdds());
        defMods.addAll(this.getDefaultOptions());
        InventoryItemUnit unit = this.getInventoryItemUnitObject();
        HashSet<InventoryDefaultMod> toRemove = new HashSet<InventoryDefaultMod>();
        for (InventoryDefaultMod mod : unit.getDefaultMods()) {
            boolean found = false;
            for (InventoryDefaultMod nextMod : defMods) {
                if (!nextMod.getDefaultMod().equals(mod.getDefaultMod())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(mod);
        }
        for (InventoryDefaultMod mod : toRemove) {
            unit.removeDefaultMod(mod);
        }
        for (InventoryDefaultMod mod : defMods) {
            unit.addDefaultMod(mod);
        }
        unit.removeStaleDefaults();
    }

    private void copyAcrossItemDetails(InventoryItem item) {
        this.copyIfNotNull(this.backgroundColor, InventoryItem.Properties.BACKGROUND_COLOR, item);
        this.copyIfNotNull(this.foregroundColor, InventoryItem.Properties.FOREGROUND_COLOR, item);
        this.copyIfNotNull(this.category.get(), InventoryItem.Properties.CATEGORY, item);
        this.copyIfNotNull(this.name, InventoryItem.Properties.LABEL, item);
        this.copyIfNotNull(this.icon, InventoryItem.Properties.ICON, item);
        this.copyIfNotNull(this.ingredientIcon, InventoryItem.Properties.INGREDIENT_ICON, item);
        this.copyIfNotNull(this.shortName, InventoryItem.Properties.SHORT_NAME, item);
        this.copyIfNotNull(this.description, InventoryItem.Properties.DESCRIPTION, item);
        this.copyIfNotNull(this.sequence, InventoryItem.Properties.SEQUENCE, item);
        this.copyIfNotNull(this.printerGroup.get(), InventoryItem.Properties.PRINTER_GROUP, item);
        this.copyIfNotNull(this.inventoryGroup.get(), InventoryItem.Properties.MENU_GROUP, item);
        this.copyIfNotNull(this.localOpenPrice, InventoryItem.Properties.IS_OPEN_PRICE, item);
        this.copyIfNotNull((Object)this.inventoryWeightUnit, InventoryItem.Properties.INVENTORY_WEIGHT_UNIT, item);
        if (this.localAutoItemNote != null) {
            item.setIsItemNote(this.localAutoItemNote);
        }
        if (this.localMinuses != null) {
            this.addRemoveMinuses(item);
        }
    }

    private void copyIfNotNull(Object value, PropertiedObject.Property invItemProperty, InventoryItem item) {
        if (value != null) {
            PropertiedObject.PropsHelper.setPropertyValue(item, invItemProperty, value);
        }
    }

    private void checkItemIntegrity(InventoryItem item) {
        if (item.getPrinterGroup() == null) {
            throw new NullPointerException("The printer group is compulsory for a new item.");
        }
        if (item.getSafeCategory() == null) {
            throw new NullPointerException("The category is compulsory for a new item.");
        }
    }

    private void findItem() {
        InventoryItemUnit unit;
        if (this.getMenuIdentifier() != null && (unit = InventoryItemUnit.findInventoryItemUnit(this.getMenuIdentifier())) != null) {
            if (this.getInventoryItemObject() != null && !this.getInventoryItemObject().equals(unit.getItem())) {
                throw new IllegalStateException("The current item is " + this.getInventoryItemObject() + " but the menu identifier is linked to the item " + unit.getItem());
            }
            this.inventoryItemUnit.set(unit);
            this.inventoryItem.set(unit.getItem());
        }
        if (this.getInventoryItemObject() != null) {
            InventoryItem theItem = this.getInventoryItemObject();
            if (!theItem.getLabel().equals(this.name) && this.createNewItemOnNameChange && this.getMenuIdentifier() == null) {
                this.inventoryItem.set(null);
                this.inventoryItemUnit.set(null);
                this.unitPriceLevel.set(null);
                this.theId = null;
            }
        } else {
            InventoryItem alreadyExistingItem = null;
            alreadyExistingItem = SPACING_ITEM.equals(this.name) ? InventoryItem.findInventoryItem(this.name, this.getInventoryGroup(), this.sequence) : InventoryItem.findInventoryItem(this.name, this.getInventoryGroup());
            if (alreadyExistingItem != null) {
                this.inventoryItem.set(alreadyExistingItem);
            }
        }
    }

    private UnitPriceLevel createUnitPriceLevelIfNeeded(InventoryItemUnit inventoryItemUnitObject) {
        UnitPriceLevel unitPriceLevelObject = null;
        unitPriceLevelObject = this.unitPriceLevel.get();
        if (unitPriceLevelObject == null) {
            unitPriceLevelObject = inventoryItemUnitObject.getUnitPriceLevel(this.getPriceLevel());
        }
        if (unitPriceLevelObject == null) {
            unitPriceLevelObject = new UnitPriceLevel();
        }
        if (!SystemProperty.getInstance().isExTax()) {
            unitPriceLevelObject.setPrice(this.price);
        } else {
            Price priceIncTax = TaxMan.getInstance().getPriceIncTax(this.getPriceExTax(), this.getTaxCodes());
            unitPriceLevelObject.setPrice(priceIncTax);
        }
        unitPriceLevelObject.setLoyaltyAdd(this.loyaltyAdd);
        unitPriceLevelObject.setLoyaltyRedeem(this.loyaltyRedeem);
        return unitPriceLevelObject;
    }

    @Override
    public String toString() {
        return this.getName() != null ? this.getName() : "Item Summary : No Name";
    }

    @Override
    @Transient
    public boolean isPersistent() {
        return this.unitPriceLevel.isPersistent();
    }

    @Override
    @Transient
    public Long getID() {
        if (this.theId == null && this.unitPriceLevel != null && PersistenceManager.isPersistenceSetup()) {
            this.theId = this.unitPriceLevel.getID();
        }
        return this.theId;
    }

    @Override
    protected void setID(Long value) {
        this.theId = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_unit_price_level", referencedColumnName="ID")
    protected UnitPriceLevel getUnitPriceLevel() {
        return this.unitPriceLevel.get();
    }

    protected void setUnitPriceLevel(UnitPriceLevel value) {
        this.unitPriceLevel.set(value);
        this.theId = this.unitPriceLevel.getID();
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    @Transient
    public Long getMasterId() {
        return this.masterId;
    }

    public void setLoyaltyAdd(int add) {
        this.loyaltyAdd = add;
    }

    @Column(name="loyalty_add")
    public int getLoyaltyAdd() {
        return this.loyaltyAdd;
    }

    public void setLoyaltyRedeem(int redeem) {
        this.loyaltyRedeem = redeem;
    }

    @Column(name="loyalty_redeem")
    public int getLoyaltyRedeem() {
        return this.loyaltyRedeem;
    }

    @Transient
    public boolean isOpenPrice() {
        if (this.getInventoryItemObject() != null) {
            return this.getInventoryItemObject().isOpenPrice();
        }
        if (this.localOpenPrice != null) {
            return this.localOpenPrice;
        }
        return false;
    }

    public void setOpenPrice(boolean openPrice) {
        if (this.getInventoryItemObject() != null) {
            this.getInventoryItemObject().setOpenPrice(openPrice);
        }
        this.localOpenPrice = openPrice;
    }

    @Transient
    public boolean isAutoItemNote() {
        if (this.getInventoryItemObject() != null) {
            return this.getInventoryItemObject().isIsItemNote();
        }
        if (this.localAutoItemNote != null) {
            return this.localAutoItemNote;
        }
        return false;
    }

    public void setAutoItemNote(boolean note) {
        if (this.getInventoryItemObject() != null) {
            this.getInventoryItemObject().setItemNote(note);
        }
        this.localAutoItemNote = note;
    }

    @Column(name="weight_unit")
    @Enumerated(value=EnumType.STRING)
    public InventoryWeightUnit getInventoryWeightUnit() {
        return this.inventoryWeightUnit;
    }

    public void setInventoryWeightUnit(InventoryWeightUnit newUnit) {
        if (this.getInventoryItemObject() != null) {
            this.getInventoryItemObject().setInventoryWeightUnit(newUnit);
        }
        this.inventoryWeightUnit = newUnit;
    }

    @Transient
    public List<StockInventoryUsageLink> getIngredients() {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().getStockInventoryUsageLinks();
        }
        return new ArrayList<StockInventoryUsageLink>();
    }

    @Column(name="num_patrons")
    public int getNumPatrons() {
        return this.numPatrons;
    }

    public void setNumPatrons(int value) {
        this.numPatrons = value;
    }

    public void setStockUsage(List stockUsage) {
        if (this.getInventoryItemUnitObject() != null) {
            this.getInventoryItemUnitObject().setStockUsage(stockUsage);
        }
    }

    @Transient
    public Price getPriceExTax() {
        if (this.priceExTax == null) {
            this.priceExTax = this.getUnitPriceLevel() != null ? this.getUnitPriceLevel().getPriceExTax() : Price.ZERO_DOLLAR;
        }
        return this.priceExTax;
    }

    public void setPriceExTax(Price value) {
        this.priceExTax = value;
    }

    @Transient
    public Price getCustomStockCost() {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().getCustomStockCost();
        }
        return null;
    }

    @Transient
    public List<InventoryDefaultOption> getDefaultOptions() {
        if (this.defOptions == null) {
            this.defOptions = new ArrayList<InventoryDefaultOption>();
            if (!this.inventoryItemUnit.isNull()) {
                for (InventoryDefaultMod mod : this.inventoryItemUnit.get().getDefaultMods()) {
                    if (!(mod instanceof InventoryDefaultOption)) continue;
                    this.defOptions.add((InventoryDefaultOption)mod);
                }
            }
        }
        return this.defOptions;
    }

    @Transient
    public List<InventoryDefaultAdd> getDefaultAdds() {
        if (this.defAdds == null) {
            this.defAdds = new ArrayList<InventoryDefaultAdd>();
            if (!this.inventoryItemUnit.isNull()) {
                for (InventoryDefaultMod mod : this.inventoryItemUnit.get().getDefaultMods()) {
                    if (!(mod instanceof InventoryDefaultAdd)) continue;
                    this.defAdds.add((InventoryDefaultAdd)mod);
                }
            }
        }
        return this.defAdds;
    }

    @Override
    public void clearStockUsage() {
        if (this.getInventoryItemUnitObject() != null) {
            this.getInventoryItemUnitObject().clearStockUsage();
        }
    }

    @Override
    @Transient
    public Price getIngredientCostIncTax() {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().getIngredientCostIncTax();
        }
        throw new IllegalStateException("No Inventory Item Unit Object configured for item summary" + this);
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().getIngredientCostExTax();
        }
        throw new IllegalStateException("No Inventory Item Unit Object configured for item summary" + this);
    }

    @Override
    @Transient
    public boolean removeStockLink(StockLink link) {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().removeStockLink(link);
        }
        throw new IllegalStateException("No Inventory Item Unit Object configured for item summary" + this);
    }

    @Override
    @Transient
    public List<StockInventoryUsageLink> getStockLinks() {
        if (this.getInventoryItemUnitObject() != null) {
            return this.getInventoryItemUnitObject().getStockLinks();
        }
        throw new IllegalStateException("No Inventory Item Unit Object configured for item summary" + this);
    }

    @Override
    public void collapseStockLinks() {
        if (this.getInventoryItemUnitObject() != null) {
            this.getInventoryItemUnitObject().collapseStockLinks();
        }
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<InventoryItem> INVENTORY_ITEM;
        public PropertiedObject.Property<UnitPriceLevel> UNIT_PRICE_LEVEL;
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property SHORT_NAME;
        public PropertiedObject.Property DESCRIPTION;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property<InventoryItemPortion> PORTION;
        public PropertiedObject.Property<InventoryRemove> MINUSES;
        public PropertiedObject.Property<InventoryCategory> CATEGORY;
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
        public PropertiedObject.Property ICON;
        public PropertiedObject.Property RECIPE;
        public PropertiedObject.Property INGREDIENT_ICON;
        public PropertiedObject.Property FOREGROUND_COLOR;
        public PropertiedObject.Property BACKGROUND_COLOR;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property PRICE;
        public PropertiedObject.Property<Price> PRICE_EX_TAX;
        public PropertiedObject.Property<InventoryItemSize> SIZE;
        public PropertiedObject.Property<InventoryAddGroup> PLUS_GROUP;
        public PropertiedObject.Property<InventoryOptionGroup> OPTION_GROUPS = new PersistentObject.DerivedProperty<InventoryOptionGroup>((Class<PersistentObject>)ItemSummary.class, "optionGroups");
        public PropertiedObject.Property BARCODES;
        public PropertiedObject.Property<InventoryItemUnit> INVENTORY_ITEM_UNIT;
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
        public PropertiedObject.Property<InventoryProfile> PROFILE;
        public PropertiedObject.Property<TaxCode> TAX_CODES;
        public PropertiedObject.Property MENU_IDENTIFIER;
        public PropertiedObject.Property LOYALTY_ADD;
        public PropertiedObject.Property LOYALTY_REDEEM;
        public PersistentObject.DerivedProperty OPEN_PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSummary.class), "openPrice");
        public PersistentObject.DerivedProperty AUTO_ITEM_NOTE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSummary.class), "autoItemNote");
        public PropertiedObject.Property<InventoryWeightUnit> INVENTORY_WEIGHT_UNIT;
        public PropertiedObject.Property NUM_PATRONS;
        public PersistentObject.DerivedProperty<String> INGREDIENTS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSummary.class), "ingredients");
        public PersistentObject.DerivedProperty<InventoryDefaultOption> DEFAULT_OPTIONS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSummary.class), "defaultOptions");
        public PersistentObject.DerivedProperty<InventoryDefaultAdd> DEFAULT_ADDS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSummary.class), "defaultAdds");

        @Override
        protected void initFieldLabels() {
            this.addFieldLabel(this.INVENTORY_ITEM, "Item");
            this.addFieldLabel(this.UNIT_PRICE_LEVEL, "Price Level");
            this.addFieldLabel(this.INVENTORY_GROUP, "Menu group");
            this.addFieldLabel(this.NAME, "Item Name");
            this.addFieldLabel(this.PORTION, "Item Portion");
            this.addFieldLabel(this.MINUSES, "List of Minuses");
            this.addFieldLabel(this.CATEGORY, "Item Category");
            this.addFieldLabel(this.DESCRIPTION, "Description");
            this.addFieldLabel(this.PRINTER_GROUP, "Printer Group");
            this.addFieldLabel(this.ICON, "Button Icon");
            this.addFieldLabel(this.RECIPE, "Recipe");
            this.addFieldLabel(this.INGREDIENT_ICON, "Ingredient Icon");
            this.addFieldLabel(this.FOREGROUND_COLOR, "Foreground Color");
            this.addFieldLabel(this.BACKGROUND_COLOR, "Foreground Color");
            this.addFieldLabel(this.SEQUENCE, "Item Sequence");
            this.addFieldLabel(this.SYSTEM_STATE, "System State");
            this.addFieldLabel(this.PRICE, "Price");
            this.addFieldLabel(this.PRICE_EX_TAX, "Price Ex Tax");
            this.addFieldLabel(this.SIZE, "Size");
            this.addFieldLabel(this.PLUS_GROUP, "Plus group");
            this.addFieldLabel(this.OPTION_GROUPS, "List of Option Groups");
            this.addFieldLabel(this.BARCODES, "Barcode");
            this.addFieldLabel(this.INVENTORY_ITEM_UNIT, "Inventory Item Unit");
            this.addFieldLabel(this.PRICE_LEVEL, "Price Level");
            this.addFieldLabel(this.PROFILE, "Profile");
            this.addFieldLabel(this.TAX_CODES, "Tax Codes");
            this.addFieldLabel(this.MENU_IDENTIFIER, "Menu Identifier");
            this.addFieldLabel(this.LOYALTY_ADD, "Loyalty Add");
            this.addFieldLabel(this.LOYALTY_REDEEM, "Loyalty Remove");
            this.addFieldLabel(this.INVENTORY_WEIGHT_UNIT, "Weight Unit");
            this.addFieldLabel(this.NUM_PATRONS, "Number of Covers");
        }
    }
}

