/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.ItemSummaryException;
import ordermate.database.inventory.ItemSummaryQueries;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.BarcodeUtils;
import ordermate.integration.csv.CsvImportException;
import ordermate.integration.csv.CsvIterator;
import ordermate.integration.menuitem.MenuExportTemplate;
import ordermate.internationalization.Internationalization;

public class ItemSummaryManager {
    CsvIterator iterator = null;
    private ObjectQuery baseQuery;
    private PriceLevel priceLevel;
    private InventoryProfile profile;

    private final ObjectQuery getBaseQuery() {
        if (this.baseQuery == null) {
            this.baseQuery = this.createQueries().createBaseQuery();
        }
        return this.baseQuery.copy();
    }

    protected ItemSummaryQueries createQueries() {
        return new ItemSummaryQueries();
    }

    public static void saveSummaries(List<ItemSummary> summaries) throws ItemSummaryException {
        for (ItemSummary itemSummary : summaries) {
            itemSummary.save();
        }
    }

    public ItemSummaryManager(PriceLevel newPriceLevel, InventoryProfile newProfile) {
        this.priceLevel = newPriceLevel;
        this.profile = newProfile;
    }

    public List<ItemSummary> getSummaries(List stringData) throws ItemSummaryException {
        try {
            ArrayList<ItemSummary> list = new ArrayList<ItemSummary>();
            this.iterator = new CsvIterator(new MenuExportTemplate(), stringData);
            while (this.iterator.hasNext()) {
                this.iterator.next();
                if (this.iterator.isRowEmpty()) continue;
                ItemSummary itemSummary = this.convertToItemSummary();
                list.add(itemSummary);
            }
            return list;
        }
        catch (CsvImportException ex) {
            throw new ItemSummaryException(ex);
        }
    }

    public ItemSummary convertToItemSummary() throws ItemSummaryException, CsvImportException {
        this.iterator.checkRowValid();
        ItemSummary itemSummary = new ItemSummary();
        itemSummary.setBackgroundColor(this.getBackground());
        itemSummary.setBarcodes(this.getBarcodes());
        itemSummary.setCategory(this.getCategory());
        itemSummary.setForegroundColor(this.getForeground());
        itemSummary.setInventoryGroup(this.getGroup());
        itemSummary.setMinuses(this.getMinuses());
        itemSummary.setName(this.getName());
        itemSummary.setShortName(this.getShortName());
        itemSummary.setPortion(this.getPortion());
        itemSummary.setPrice(this.getPrice());
        itemSummary.setPriceLevel(this.priceLevel);
        itemSummary.setPrinterGroup(this.getPrinterGroup());
        itemSummary.setProfile(this.profile);
        itemSummary.setSequence(this.getSequence());
        itemSummary.setSize(this.getSize());
        itemSummary.setSystemState(this.getSystemState());
        itemSummary.setMenuIdentifier(this.getMenuIdentifier());
        itemSummary.setTaxCodes(this.getTaxCodes());
        itemSummary.setPlusGroup(this.getPlusGroup(itemSummary.getSize()));
        for (InventoryOptionGroup group : this.getOptionGroups(itemSummary.getSize())) {
            itemSummary.addOptionGroup(group);
        }
        return itemSummary;
    }

    public void setIterator(CsvIterator iterator) {
        this.iterator = iterator;
    }

    private InventoryItemPortion getPortion() {
        InventoryItemPortion retValue = null;
        String value = this.iterator.get("Portion");
        if (value != null && !value.isEmpty() && (retValue = InventoryItemPortion.findPortion(value)) == null) {
            retValue = new InventoryItemPortion();
            retValue.setLabel(value);
        }
        return retValue;
    }

    private InventoryAddGroup getPlusGroup(InventoryItemSize size) throws ItemSummaryException {
        InventoryAddGroup retValue = null;
        String value = this.iterator.get("Plus Group");
        if (value != null && !value.isEmpty()) {
            if (!size.isPersistent()) {
                throw new ItemSummaryException("Plus group " + value + " cannot be used while creating a new size in row " + this.iterator.getRowNumber());
            }
            retValue = InventoryAddGroup.findModificationGroup(value, size);
            if (retValue == null) {
                for (InventoryAddGroup group : InventoryAddGroup.getAllAddGroups()) {
                    if (!group.getLabel().equals(value)) continue;
                    return group;
                }
                throw new ItemSummaryException("Plus group " + value + " could not be found for size " + size.getLabel() + " in row " + this.iterator.getRowNumber());
            }
        }
        return retValue;
    }

    private List<InventoryOptionGroup> getOptionGroups(InventoryItemSize size) throws ItemSummaryException {
        ArrayList<InventoryOptionGroup> retValue = new ArrayList<InventoryOptionGroup>();
        String value = this.iterator.get("Option Groups");
        if (value != null && !value.isEmpty()) {
            if (!size.isPersistent()) {
                throw new ItemSummaryException("Option Groups " + value + " cannot be used while creating a new size in row " + this.iterator.getRowNumber());
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                String groupName = st.nextToken().trim();
                if (groupName.isEmpty()) continue;
                InventoryOptionGroup group = InventoryOptionGroup.findModificationGroup(groupName, size);
                if (group == null) {
                    for (InventoryOptionGroup currentGroup : InventoryOptionGroup.getOptionGroups()) {
                        if (!currentGroup.getLabel().equals(groupName)) continue;
                        group = currentGroup;
                        break;
                    }
                    if (group == null) {
                        throw new ItemSummaryException("Option group " + groupName + " on row " + this.iterator.getRowNumber() + " could not be found for size " + size.getLabel());
                    }
                }
                retValue.add(group);
            }
        }
        return retValue;
    }

    private List getBarcodes() throws ItemSummaryException {
        HashMap<String, InventoryBarcode> retValue = new HashMap<String, InventoryBarcode>();
        String value = this.iterator.get("Barcode");
        if (value == null || value.isEmpty()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String string = st.nextToken().trim();
            if (string.isEmpty()) continue;
            if (!string.isEmpty() && !BarcodeUtils.isBarcodeString(string)) {
                throw new ItemSummaryException("Barcode " + string + " is not a valid barcode. in row " + this.iterator.getRowNumber());
            }
            String barcode = BarcodeUtils.stripBarcodeDelimiter(string);
            InventoryBarcode inventoryBarcode = (InventoryBarcode)retValue.get(barcode);
            if (inventoryBarcode == null) {
                inventoryBarcode = InventoryBarcode.getBarcode(barcode);
            }
            if (inventoryBarcode == null) {
                inventoryBarcode = new InventoryBarcode();
                inventoryBarcode.setBarcode(barcode);
            }
            retValue.put(barcode, inventoryBarcode);
        }
        return new ArrayList(retValue.values());
    }

    private List getMinuses() throws ItemSummaryException {
        HashMap<String, InventoryRemove> retValue = new HashMap<String, InventoryRemove>();
        String value = this.iterator.get("Minuses");
        if (value == null || value.isEmpty()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String removeName;
            Price price = null;
            String token = st.nextToken().trim();
            StringTokenizer priceSt = new StringTokenizer(token, "()");
            if (priceSt.countTokens() == 2) {
                removeName = priceSt.nextToken().trim();
                try {
                    price = new Price(priceSt.nextToken().trim(), 0.01);
                }
                catch (Exception e) {
                    throw new ItemSummaryException("Minus price in " + value + "could not be parsed in row " + this.iterator.getRowNumber(), e);
                }
            } else {
                removeName = token;
            }
            InventoryRemove itemRemove = new InventoryRemove();
            itemRemove.setLabel(removeName);
            if (price != null) {
                itemRemove.setPrice(price);
            } else {
                itemRemove.setPrice(Price.ZERO);
            }
            retValue.put(removeName, itemRemove);
        }
        return new ArrayList(retValue.values());
    }

    private String getSystemState() throws ItemSummaryException {
        String state = this.iterator.get("System State");
        if (state == null || state.isEmpty()) {
            return "ACTIVE";
        }
        SystemState myState = SystemState.parseSystemState(state);
        if ((state = myState.getSystemState()) == "ACTIVE" || state == "INACTIVE" || state == "DELETED") {
            return state;
        }
        throw new ItemSummaryException("Invalid system state [" + state + "] in row " + this.iterator.getRowNumber());
    }

    private InventoryItemSize getSize() throws ItemSummaryException {
        InventoryItemSize retValue = null;
        String value = this.iterator.get("Size");
        if (value == null || value.isEmpty()) {
            throw new ItemSummaryException("The size is empty in row " + this.iterator.getRowNumber());
        }
        retValue = InventoryItemSize.findSize(value);
        if (retValue == null) {
            retValue = new InventoryItemSize();
            retValue.setLabel(value);
        }
        return retValue;
    }

    private Integer getSequence() throws ItemSummaryException {
        Integer retValue = null;
        String value = this.iterator.get("Sequence");
        if (value != null && !value.isEmpty()) {
            try {
                return new Integer(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new ItemSummaryException("Cannot parse sequence [" + value + "] in row " + this.iterator.getRowNumber());
            }
        }
        return retValue;
    }

    private PrinterGroup getPrinterGroup() {
        PrinterGroup retValue = null;
        String name = this.iterator.get("Printer Group");
        if (name != null && !name.isEmpty() && (retValue = PrinterGroup.getPrinterGroup(name)) == null) {
            retValue = new PrinterGroup(name);
        }
        return retValue;
    }

    private Price getPrice() throws ItemSummaryException {
        String toProcess = this.iterator.get("Price");
        double priceDouble = 0.0;
        if (toProcess == null) {
            return null;
        }
        try {
            toProcess = toProcess.replaceAll(",", "");
            priceDouble = toProcess.startsWith(Internationalization.getLiteralFor("DOLLAR_SIGN")) ? Double.parseDouble(toProcess.substring(1)) : Double.valueOf(toProcess);
        }
        catch (NumberFormatException n) {
            throw new ItemSummaryException("Cannot parse price [" + toProcess + "] in row " + this.iterator.getRowNumber());
        }
        return new Price(priceDouble, 0.01);
    }

    private InventoryGroup getGroup() throws ItemSummaryException {
        String name = this.iterator.get("Group");
        if (name == null || name.isEmpty()) {
            throw new ItemSummaryException("Empty group name in row " + this.iterator.getRowNumber());
        }
        InventoryGroup upperGroup = InventoryGroup.parseInventoryGroup(name, this.profile);
        return upperGroup;
    }

    private Color getForeground() {
        return GuiUtils.makeColor(this.iterator.get("Foreground"));
    }

    private InventoryCategory getCategory() {
        String name = this.iterator.get("Category");
        if (name == null || name.isEmpty()) {
            return null;
        }
        InventoryCategory toReturn = InventoryCategory.getCategoryForName(name);
        if (toReturn == null) {
            toReturn = new InventoryCategory();
            toReturn.setName(name);
        }
        return toReturn;
    }

    private Color getBackground() {
        return GuiUtils.makeColor(this.iterator.get("Background"));
    }

    private String getName() {
        return this.iterator.get("Name");
    }

    private String getShortName() {
        return this.iterator.get("Short Name");
    }

    private Integer getMenuIdentifier() throws ItemSummaryException {
        Integer retValue = null;
        String value = this.iterator.get("Menu Identifier");
        if (value != null && !value.isEmpty()) {
            try {
                retValue = new Integer(this.iterator.get("Menu Identifier"));
            }
            catch (NumberFormatException e) {
                throw new ItemSummaryException("Cannot parse identifier [" + value + "] in row " + this.iterator.getRowNumber());
            }
        }
        return retValue;
    }

    private List<TaxCode> getTaxCodes() throws ItemSummaryException {
        ArrayList<TaxCode> taxCodes = new ArrayList<TaxCode>();
        String value = this.iterator.get("Tax Code");
        if (value != null && !value.isEmpty()) {
            List<String> taxes = StringUtils.splitToList(value, "&");
            for (String nextTax : taxes) {
                TaxCode taxCode = TaxCode.getTaxCode(nextTax);
                if (nextTax == null) {
                    throw new ItemSummaryException("Tax code [" + value + "] unknown in row " + this.iterator.getRowNumber());
                }
                taxCodes.add(taxCode);
            }
        }
        return taxCodes;
    }
}

