/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.implementation.ContainsTextEventListFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.users.PermissionGroup;

public class ItemSummaryQueries {
    public ObjectQuery createBaseQuery() {
        return Query.select(InventoryItemUnit.Properties.ITEM).select(UnitPriceLevel.Properties.ID, "FK_unit_price_level").select(InventoryItemUnit.Properties.MASTER_ID).select(InventoryItem.Properties.MENU_GROUP).select(InventoryItem.Properties.LABEL).select(InventoryItem.Properties.SHORT_NAME).select(InventoryItem.Properties.DESCRIPTION).select(InventoryItemUnit.Properties.PORTION).select(InventoryItem.Properties.CATEGORY).select(InventoryItem.Properties.ICON).select(InventoryItem.Properties.INGREDIENT_ICON).select(InventoryItem.Properties.PRINTER_GROUP).select(InventoryItem.Properties.BACKGROUND_COLOR).select(InventoryItem.Properties.FOREGROUND_COLOR).select(InventoryItem.Properties.SEQUENCE).select(InventoryItemUnit.Properties.SYSTEM_STATE).select(UnitPriceLevel.Properties.PRICE).select(UnitPriceLevel.Properties.UNIT).select(InventoryItemUnit.Properties.SIZE).select(InventoryItemUnit.Properties.RECIPE).select(InventoryItemUnit.Properties.PLUS_GROUP).select(UnitPriceLevel.Properties.PRICE_LEVEL).select(InventoryGroup.Properties.PROFILE).select(InventoryItemUnit.Properties.MENU_IDENTIFIER).select(UnitPriceLevel.Properties.LOYALTY_ADD).select(UnitPriceLevel.Properties.LOYALTY_REDEEM).select(InventoryItem.Properties.INVENTORY_WEIGHT_UNIT).select(InventoryItemUnit.Properties.NUM_PATRONS).select(0.0, "mod_count").linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(InventoryItemUnit.Properties.PRICES).linkUsing(InventoryItem.Properties.MENU_GROUP).wherePropertyIn(InventoryItem.Properties.SYSTEM_STATE, new Object[]{"ACTIVE", "INACTIVE"}).wherePropertyIn(InventoryItemUnit.Properties.SYSTEM_STATE, new Object[]{"ACTIVE", "INACTIVE"}).orderBy(InventoryItem.Properties.SEQUENCE).orderBy(InventoryItem.Properties.LABEL);
    }

    public ObjectQuery getFilteredQuery() {
        return this.createBaseQuery().equalsParam(InventoryGroup.Properties.PROFILE).equalsParam(UnitPriceLevel.Properties.PRICE_LEVEL);
    }

    public ObjectQuery getQueryByGroup() {
        return this.getFilteredQuery().equalsParam(InventoryItem.Properties.MENU_GROUP);
    }

    public ObjectQuery getBaseUnitQuery() {
        return Query.select(InventoryItemUnit.class).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(InventoryItemUnit.Properties.PRICES).linkUsing(InventoryItem.Properties.MENU_GROUP).wherePropertyIn(InventoryItem.Properties.SYSTEM_STATE, new Object[]{"ACTIVE", "INACTIVE"}).wherePropertyIn(InventoryItemUnit.Properties.SYSTEM_STATE, new Object[]{"ACTIVE", "INACTIVE"}).equalsParam(InventoryGroup.Properties.PROFILE).equalsParam(UnitPriceLevel.Properties.PRICE_LEVEL);
    }

    public ObjectQuery getQueryUnitByGroup() {
        return this.getBaseUnitQuery().equalsParam(InventoryItem.Properties.MENU_GROUP);
    }

    public List<ItemSummary> getSummaries(InventoryProfile profile, PriceLevel priceLevel) {
        List<InventoryItemUnit> list = PersistenceManager.getObjectList(InventoryItemUnit.class, this.getBaseUnitQuery().toString(), new Object[]{profile.getID(), priceLevel.getID()});
        Iterator<InventoryItemUnit> it = list.iterator();
        while (it.hasNext()) {
            CacheManager.getInstance().cacheObject(((PersistentObject)it.next()).getLastSavedSnapshot());
        }
        List<ItemSummary> summaryList = PersistenceManager.getObjectList(ItemSummary.class, this.getFilteredQuery().toString(), new Object[]{profile.getID(), priceLevel.getID()});
        for (ItemSummary summary : summaryList) {
            summary.setCreateNewItemOnNameChange(false);
        }
        return summaryList;
    }

    public List getSummaries(InventoryProfile profile, PriceLevel priceLevel, InventoryGroup group) {
        List<PersistentObject> list = PersistenceManager.getObjectList(InventoryItemUnit.class, this.getQueryUnitByGroup().toString(), new Object[]{profile.getID(), priceLevel.getID(), group.getID()});
        list = PersistenceManager.getObjectList(ItemSummary.class, this.getQueryByGroup().toString(), new Object[]{profile.getID(), priceLevel.getID(), group.getID()});
        for (ItemSummary itemSummary : list) {
            itemSummary.setCreateNewItemOnNameChange(false);
        }
        return list;
    }

    public ObjectQuerySearcher<ItemSummary> createSearcher() {
        return new ItemSummarySearcher();
    }

    public class ItemSummarySearcher
    extends PropertySearcher<ItemSummary> {
        private ISingleValueSearchFilter<InventoryGroup> menuSectionFilter;
        private ISingleValueSearchFilter<InventoryProfile> profileFilter;
        private ISingleValueSearchFilter<PriceLevel> priceLevelFilter;
        private ISingleValueSearchFilter<InventoryCategory> categoryFilter;
        private ISingleValueSearchFilter<PrinterGroup> printerGroupFilter;
        private ISingleValueSearchFilter<PermissionGroup> permissionFilter;
        private ISingleValueSearchFilter<InventoryItemSize> sizeFilter;
        private ISingleValueSearchFilter itemNameFilter;

        public ItemSummarySearcher() {
            super(ItemSummary.class);
            this.menuSectionFilter = new ObjectSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
            this.profileFilter = new ObjectSearchFilter<InventoryProfile>(InventoryGroup.Properties.PROFILE);
            this.priceLevelFilter = new ObjectSearchFilter<PriceLevel>(UnitPriceLevel.Properties.PRICE_LEVEL);
            this.categoryFilter = new ObjectSearchFilter<InventoryCategory>(InventoryItem.Properties.CATEGORY);
            this.printerGroupFilter = new ObjectSearchFilter<PrinterGroup>(InventoryItem.Properties.PRINTER_GROUP);
            this.permissionFilter = new ObjectSearchFilter<PermissionGroup>(InventoryGroup.Properties.PERMISSION_GROUP);
            this.sizeFilter = new ObjectSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
            this.itemNameFilter = new ContainsTextEventListFilter(ItemSummary.Properties.NAME);
            this.addSearchFilter(this.menuSectionFilter);
            this.addSearchFilter(this.profileFilter);
            this.addSearchFilter(this.priceLevelFilter);
            this.addSearchFilter(this.categoryFilter);
            this.addSearchFilter(this.printerGroupFilter);
            this.addSearchFilter(this.sizeFilter);
            this.addSearchFilter(this.itemNameFilter);
        }

        @Override
        protected ObjectQuery getBaseQuery() {
            return ItemSummaryQueries.this.createBaseQuery();
        }

        public ISingleValueSearchFilter<InventoryGroup> getMenuSectionFilter() {
            return this.menuSectionFilter;
        }

        public ISingleValueSearchFilter<InventoryProfile> getProfileFilter() {
            return this.profileFilter;
        }

        public ISingleValueSearchFilter<PriceLevel> getPriceLevelFilter() {
            return this.priceLevelFilter;
        }

        public ISingleValueSearchFilter<InventoryCategory> getCategoryFilter() {
            return this.categoryFilter;
        }

        public ISingleValueSearchFilter<PrinterGroup> getPrinterGroupFilter() {
            return this.printerGroupFilter;
        }

        public ISingleValueSearchFilter<InventoryItemSize> getSizeFilter() {
            return this.sizeFilter;
        }

        public ISingleValueSearchFilter<String> getItemNameFilter() {
            return this.itemNameFilter;
        }

        public ISingleValueSearchFilter<PermissionGroup> getPermissionFilter() {
            return this.permissionFilter;
        }

        @Override
        public ObjectQuery getObjectQuery() {
            ObjectQuery query = super.getObjectQuery();
            this.appendGroupRestriction(query, this.profileFilter.getSearchValue(), this.permissionFilter.getSearchValue());
            return query;
        }

        private ObjectQuery appendGroupRestriction(ObjectQuery query, InventoryProfile profile, PermissionGroup permission) {
            if (profile == null || permission == null) {
                return query;
            }
            HashSet<InventoryGroup> forbiddenGroups = new HashSet<InventoryGroup>(profile.getProfileGroups(true));
            forbiddenGroups.removeAll(profile.getModifiableProfileGroups(permission));
            if (!forbiddenGroups.isEmpty()) {
                query.not().wherePropertyIn(InventoryItem.Properties.MENU_GROUP, forbiddenGroups);
            }
            return query;
        }
    }
}

