/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.misc.SystemProperty;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@MappedSuperclass
@AccessType(value="property")
public abstract class Modification
extends PersistentDisplayableObject
implements Sequenced {
    public static final Props Properties = new Props();
    private Price price = Price.ZERO_DOLLAR;
    private Integer sequence;

    public Modification() {
    }

    public Modification(Modification copy) {
        super(copy);
        this.price = copy.price;
    }

    @Transient
    public Price getModificationPrice() {
        double thePrice = this.getPrice().doubleValue();
        double mod = this.getModificationSize().getMultiplier();
        return new Price(thePrice * mod, 0.01);
    }

    @Transient
    public Price getTaxAmount() {
        return new Price(FinanceUtils.getTaxValue(this.getModificationPrice(), SystemProperty.getInstance().getBaseTaxRate()), 0.0);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="Price")
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price thePrice) {
        this.price = thePrice;
    }

    @Transient
    public abstract ModificationSize getModificationSize();

    public abstract void setModificationSize(ModificationSize var1);

    public boolean isEquivalentTo(Modification mod) {
        return this.equals(mod);
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_background")
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_foreground")
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<Price> PRICE;
        public PropertiedObject.Property SEQUENCE;
    }
}

