/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.ModificationSizeType;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_add_remove_type")
@AccessType(value="property")
public class ModificationSize
extends PersistentObject
implements Inventory,
Saveable,
Displayable,
ExportableObject {
    private static final String ADD_TYPE = "ADD";
    private static final String REMOVE_TYPE = "REMOVE";
    private static final String ALL_TYPES = "ALL";
    public static final Props Properties = new Props();
    private String name;
    private String abbreviatedName = "";
    private double multiplier;
    private ModificationSizeType type;
    private String systemState = "ACTIVE";
    private Long masterId;
    private int sequence = 0;
    private static Reference<ModificationSize> defaultType = new LocalCachedReference<ModificationSize>(new QueryReference<ModificationSize>(ModificationSize.class, Query.select(ModificationSize.class).equals(ModificationSize.Properties.NAME, "Single").equals(ModificationSize.Properties.MULTIPLIER, 1.0)));
    private static final LocalCacheListManager<ModificationSize> allAddTypes = new LocalCacheListManager<ModificationSize>(Query.createQueryList(ModificationSize.class, Query.select(ModificationSize.class).equals(ModificationSize.Properties.SYSTEM_STATE, "ACTIVE").group().equals(ModificationSize.Properties.TYPE, "ADD").or().equals(ModificationSize.Properties.TYPE, "ALL").endGroup()));
    private static final LocalCacheListManager<ModificationSize> allRemoveTypes = new LocalCacheListManager<ModificationSize>(Query.createQueryList(ModificationSize.class, Query.select(ModificationSize.class).equals(ModificationSize.Properties.SYSTEM_STATE, "ACTIVE").group().equals(ModificationSize.Properties.TYPE, "REMOVE").or().equals(ModificationSize.Properties.TYPE, "ALL").endGroup()));

    public ModificationSize() {
    }

    public ModificationSize(String newName, ModificationSizeType type) {
        this(newName, type, 1.0);
    }

    public ModificationSize(String newName, ModificationSizeType newType, double newMultiplier) {
        this.name = newName;
        this.type = newType;
        this.multiplier = newMultiplier;
    }

    @Override
    public String toString() {
        return this.getName() != null ? this.getName() : "No Modification Size Name, ID :" + this.getID();
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Column(name="abbreviated_name")
    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    @Column(name="multiplier")
    public double getMultiplier() {
        return this.multiplier;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    public ModificationSizeType getType() {
        return this.type;
    }

    public static List<ModificationSize> getAllAddTypes() {
        return allAddTypes.getList();
    }

    public static List<ModificationSize> getAllRemoveTypes() {
        return allRemoveTypes.getList();
    }

    public static List<ModificationSize> getAll() {
        ArrayList<ModificationSize> all = new ArrayList<ModificationSize>(ModificationSize.getAllAddTypes());
        all.addAll(ModificationSize.getAllRemoveTypes());
        return all;
    }

    public static ModificationSize getDefaultSize() {
        return defaultType.get();
    }

    @Override
    public void delete() {
        if (!this.equals(defaultType.get())) {
            this.systemState = "DELETED";
            this.save();
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getName() != null ? this.getName() : "";
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String aState) {
        this.systemState = aState;
    }

    public void setMultiplier(double theMultiplier) {
        this.multiplier = theMultiplier;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setAbbreviatedName(String newAbbreviatedName) {
        this.abbreviatedName = newAbbreviatedName;
    }

    public void setType(ModificationSizeType newType) {
        this.type = newType;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> ABBREVIATED_NAME;
        public PropertiedObject.Property MULTIPLIER;
        public PropertiedObject.Property<ModificationSizeType> TYPE;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property SEQUENCE;
    }
}

