/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;

public class OrderedQuantity {
    private HashMap<InventoryItem, SalesQuantity> itemQuantity = new HashMap();
    private HashMap<InventoryCombo, SalesQuantity> comboQuantity = new HashMap();

    public OrderedQuantity() {
    }

    public OrderedQuantity(List items, boolean useUncommited) {
        if (items == null) {
            return;
        }
        for (SalesLineItem toAdd : items) {
            if (toAdd instanceof SalesItem) {
                if (useUncommited) {
                    this.addQuantity((SalesItem)toAdd, toAdd.getUnsavedQuantity());
                    continue;
                }
                this.addQuantity((SalesItem)toAdd, toAdd.getQuantity());
                continue;
            }
            if (!(toAdd instanceof SalesCombo)) continue;
            SalesCombo combo = (SalesCombo)toAdd;
            for (SalesItem item : combo.getSalesItems()) {
                if (useUncommited) {
                    this.addQuantity(item, item.getUnsavedQuantity());
                    continue;
                }
                this.addQuantity(item, item.getQuantity());
            }
            if (useUncommited) {
                this.addQuantity(combo.getCombo(), toAdd.getUnsavedQuantity());
                continue;
            }
            this.addQuantity(combo.getCombo(), toAdd.getQuantity());
        }
    }

    public SalesQuantity getQuantity(InventoryItem toCheck) {
        return this.itemQuantity.containsKey(toCheck) ? this.itemQuantity.get(toCheck) : SalesQuantity.ZERO;
    }

    public SalesQuantity getQuantity(InventoryCombo toCheck) {
        return this.comboQuantity.containsKey(toCheck) ? this.comboQuantity.get(toCheck) : SalesQuantity.ZERO;
    }

    public SalesQuantity getTotalQuantity() {
        SalesQuantity totalQuantity = SalesQuantity.ZERO;
        Iterator<SalesQuantity> it = this.itemQuantity.values().iterator();
        while (it.hasNext()) {
            totalQuantity = totalQuantity.add(it.next());
        }
        return totalQuantity;
    }

    public Iterator entryIterator() {
        return this.itemQuantity.entrySet().iterator();
    }

    public Collection getItemKeys() {
        return Collections.unmodifiableSet(this.itemQuantity.keySet());
    }

    public Collection getComboKeys() {
        return Collections.unmodifiableSet(this.comboQuantity.keySet());
    }

    private void addQuantity(SalesItem toAdd, SalesQuantity newQuantity) {
        for (SalesComponent component : toAdd.getComponentList()) {
            SalesQuantity quantity = newQuantity.multiply(new SalesQuantity(BigDecimal.valueOf(component.getUnit().getPortion().getSize())));
            this.addQuantity(component.getInventoryItem(), quantity);
        }
    }

    private void addQuantity(InventoryItem toAdd, SalesQuantity addAmount) {
        this.addQuantity(toAdd, this.itemQuantity, addAmount);
    }

    private void addQuantity(InventoryCombo toAddCombo, SalesQuantity addAmount) {
        this.addQuantity(toAddCombo, this.comboQuantity, addAmount);
    }

    private <T extends Inventory> void addQuantity(T keyToAdd, Map<T, SalesQuantity> quantityMap, SalesQuantity addAmount) {
        if (quantityMap.containsKey(keyToAdd)) {
            SalesQuantity currentAmount = quantityMap.remove(keyToAdd);
            SalesQuantity newAmount = currentAmount.add(addAmount);
            if (newAmount.notEquals(0)) {
                quantityMap.put(keyToAdd, newAmount);
            } else if (newAmount.equals(0L)) {
                quantityMap.remove(keyToAdd);
            }
        } else if (addAmount.notEquals(0)) {
            quantityMap.put(keyToAdd, addAmount);
        } else {
            quantityMap.remove(keyToAdd);
        }
    }

    public boolean isEmpty() {
        return this.itemQuantity.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[');
        Iterator<Map.Entry<InventoryItem, SalesQuantity>> i = this.itemQuantity.entrySet().iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            Map.Entry<InventoryItem, SalesQuantity> entry = i.next();
            Displayable obj = entry.getKey();
            buffer.append(obj.getLabel());
            buffer.append(" * ");
            buffer.append(entry.getValue());
            isFirst = false;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

