/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Sequenced;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevelRule;
import ordermate.database.inventory.TriggerPriceLevelLink;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.CompositeTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_price_level")
@AccessType(value="property")
public class PriceLevel
extends PersistentDisplayableObject
implements Saveable,
Inventory,
TriggerActivated,
ExportableObject {
    public static final Props Properties = new Props();
    private static final LocalCacheListManager<PriceLevel> allPriceLevels = new LocalCacheListManager<PriceLevel>(Query.createQueryList(PriceLevel.class, Query.select(PriceLevel.class).equals(PriceLevel.Properties.SYSTEM_STATE, "ACTIVE").orderByDesc(PriceLevel.Properties.SEQUENCE)));
    private static final LocalCachedReference<PriceLevel> theDefaultLevel = new LocalCachedReference<PriceLevel>(new QueryReference<PriceLevel>(PriceLevel.class, Query.select(PriceLevel.class).active(PriceLevel.class).equals(PriceLevel.Properties.DEFAULT_LEVEL, 1.0)));
    private Integer sequence = null;
    private boolean showOnReceipt;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
    private String systemState = "ACTIVE";
    private Reference<PriceLevel> referencePriceLevel;
    private Price dollarToApply;
    private double percentageToApply;
    private PriceLevelRule ruleToApply;
    private PersistentWriteableList<TriggerPriceLevelLink> triggerLinks;
    private PersistentWriteableList<UnitPriceLevel> unitPriceLevels;
    private Long masterId;
    private boolean defaultLevel;
    private double loyaltyEarnFactor;
    private double loyaltyRedeemFactor;
    private boolean forceLoyaltyFactor;

    public PriceLevel() {
        this.referencePriceLevel = this.createReference(PriceLevel.Properties.REFERENCE_PRICE_LEVEL);
        this.ruleToApply = PriceLevelRule.NULL_RULE;
        this.triggerLinks = (PersistentWriteableList)this.createList(PriceLevel.Properties.TRIGGER_LINKS);
        this.unitPriceLevels = (PersistentWriteableList)this.createList(PriceLevel.Properties.UNIT_PRICE_LEVELS);
        this.defaultLevel = false;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.getTriggerActivationStrategy().isActive(this, context);
    }

    public int getQuantityAllowed(TriggerActivationContext context) {
        if (this.triggerLinks.isEmpty()) {
            return 0;
        }
        int qty = this.triggerActivationStrategy.equals(TriggerActivationStrategy.ALL_TRIGGERS) ? Integer.MAX_VALUE : 0;
        for (AbstractTrigger trigger : this.getTriggers()) {
            int triggerQty = trigger.getQuantityAllowed(context);
            if (this.triggerActivationStrategy.equals(TriggerActivationStrategy.ALL_TRIGGERS)) {
                if ((qty = Math.min(qty, triggerQty)) != 0) continue;
                return 0;
            }
            qty = Math.max(qty, triggerQty);
        }
        return qty;
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> trigs = new ArrayList<AbstractTrigger>();
        for (TriggerPriceLevelLink link : this.triggerLinks) {
            AbstractTrigger trigger = link.getTrigger();
            if (trigger == null) continue;
            trigs.add(trigger);
        }
        return trigs;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger toAdd) {
        if (!this.getTriggers().contains(toAdd)) {
            TriggerPriceLevelLink link = new TriggerPriceLevelLink(this, toAdd);
            this.triggerLinks.add(link);
            return link;
        }
        return null;
    }

    public void setTriggers(List<AbstractTrigger> triggersToSet) {
        List<AbstractTrigger> removeList = this.getTriggers();
        removeList.removeAll(triggersToSet);
        ArrayList<AbstractTrigger> insertList = new ArrayList<AbstractTrigger>(triggersToSet);
        insertList.removeAll(this.getTriggers());
        HashSet<TriggerPriceLevelLink> linksToRemove = new HashSet<TriggerPriceLevelLink>();
        for (AbstractTrigger trigger : removeList) {
            for (TriggerPriceLevelLink link : this.triggerLinks) {
                if (!link.getTrigger().equals(trigger)) continue;
                linksToRemove.add(link);
            }
        }
        this.triggerLinks.removeAll(linksToRemove);
        for (AbstractTrigger trigger : insertList) {
            this.triggerLinks.add(new TriggerPriceLevelLink(this, trigger));
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger toRemove) {
        boolean foundTrigger = false;
        ArrayList<TriggerPriceLevelLink> removeList = new ArrayList<TriggerPriceLevelLink>();
        for (TriggerPriceLevelLink link : this.triggerLinks) {
            if (!link.getTrigger().equals(toRemove)) continue;
            foundTrigger = true;
            removeList.add(link);
        }
        if (!foundTrigger) {
            throw new IllegalArgumentException(toRemove + " is not linked with price level " + this.getLabel());
        }
        this.triggerLinks.removeAll(removeList);
        return true;
    }

    @Transient
    public List<UnitPriceLevel> getUnitPriceLevels() {
        return this.unitPriceLevels.getUnmodifiable();
    }

    public void addUnitPriceLevel(UnitPriceLevel toAdd) {
        this.unitPriceLevels.add(toAdd);
    }

    public void removeUnitPriceLevel(UnitPriceLevel toRemove) {
        if (!this.unitPriceLevels.remove(toRemove)) {
            throw new IllegalArgumentException("There is no unit price for price level " + this.getLabel());
        }
    }

    @Override
    @Column(name="Sequence")
    public int getSequence() {
        if (this.sequence == null) {
            this.sequence = 0;
        }
        return this.sequence;
    }

    public void setSequenceIfAvailable(int newSequence) {
        this.sequence = this.getNextSequenceAfter(newSequence);
    }

    public void setSequence() {
        this.sequence = PriceLevel.getNextSequence();
    }

    @Column(name="show_on_receipt")
    public boolean isShowOnReceipt() {
        return this.showOnReceipt;
    }

    public void setShowOnReceipt(boolean newShowOnReceipt) {
        this.showOnReceipt = newShowOnReceipt;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy newTriggerActivation) {
        this.triggerActivationStrategy = newTriggerActivation;
    }

    @ManyToOne
    @JoinColumn(name="FK_reference_price_level")
    public PriceLevel getReferencePriceLevel() {
        return this.referencePriceLevel.get();
    }

    public void setReferencePriceLevel(PriceLevel newRefLevel) {
        this.referencePriceLevel.set(newRefLevel);
    }

    @Column(name="dollar_to_apply")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getDollarToApply() {
        return this.dollarToApply;
    }

    public void setDollarToApply(Price newDollarToApply) {
        this.dollarToApply = newDollarToApply;
    }

    @Column(name="percentage_to_apply")
    public double getPercentageToApply() {
        return this.percentageToApply;
    }

    public void setPercentageToApply(double newPercentageToApply) {
        this.percentageToApply = newPercentageToApply;
    }

    @Column(name="rule_to_apply")
    @Enumerated(value=EnumType.STRING)
    public PriceLevelRule getRuleToApply() {
        return this.ruleToApply;
    }

    public void setRuleToApply(PriceLevelRule newRuleToApply) {
        this.ruleToApply = newRuleToApply;
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        this.sequence = null;
        Iterator it = this.unitPriceLevels.iterator();
        while (it != null && it.hasNext()) {
            ((UnitPriceLevel)it.next()).delete();
        }
        this.triggerLinks.deleteChild();
        this.save();
        allPriceLevels.clearCache();
        Iterator<PriceLevel> iteratorPriceLevels = PriceLevel.getAllPriceLevels().iterator();
        while (iteratorPriceLevels != null && iteratorPriceLevels.hasNext()) {
            PriceLevel priceLevel = iteratorPriceLevels.next();
            if (priceLevel.getReferencePriceLevel() == null || !priceLevel.getReferencePriceLevel().equals(this)) continue;
            priceLevel.setReferencePriceLevel(null);
            priceLevel.save();
        }
    }

    public void deleteSequence() {
        this.sequence = null;
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.setSequenceIfAvailable(this.getSequence());
        if (this.isDefaultLevel() && !PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            this.validateOtherDefaultLevelSettings();
        }
        PersistenceManager.save(this);
        this.triggerLinks.saveChild();
        allPriceLevels.clearCache();
        CacheManager.getInstance().clearCache(this.getClass());
    }

    public static List<PriceLevel> getAllPriceLevels() {
        return allPriceLevels.getList();
    }

    public static List<PriceLevel> getWithTriggerType(Class<? extends AbstractTrigger> type) {
        if (!AbstractTrigger.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type + " is not a subclass of AbstractTrigger");
        }
        ArrayList<PriceLevel> priceLevels = new ArrayList<PriceLevel>();
        block0: for (PriceLevel priceLevel : PriceLevel.getAllPriceLevels()) {
            block1: for (AbstractTrigger trigger : priceLevel.getTriggers()) {
                if (type.isAssignableFrom(trigger.getClass())) {
                    priceLevels.add(priceLevel);
                    continue block0;
                }
                if (!trigger.getClass().equals(CompositeTrigger.class)) continue;
                for (AbstractTrigger triggerFromComposite : ((CompositeTrigger)trigger).getTriggers()) {
                    if (!type.isAssignableFrom(triggerFromComposite.getClass())) continue;
                    priceLevels.add(priceLevel);
                    continue block1;
                }
            }
        }
        return priceLevels;
    }

    protected static int getMaxSequence() {
        String sql = Query.select(PriceLevel.class).orderByDesc(PriceLevel.Properties.SEQUENCE).limit(1).toString();
        List<PriceLevel> result = PersistenceManager.getObjectList(PriceLevel.class, sql);
        if (!result.isEmpty()) {
            return result.get(0).getSequence();
        }
        return 0;
    }

    public static int getNextSequence() {
        boolean SEQUENCE_STEPS = true;
        return PriceLevel.getMaxSequence() + 1;
    }

    private int getNextSequenceAfter(int thisSequence) {
        ObjectQuery query = new ObjectQuery();
        query.select(PriceLevel.Properties.SEQUENCE);
        query.greaterThan(PriceLevel.Properties.SEQUENCE, thisSequence);
        query.or();
        query.equals(PriceLevel.Properties.SEQUENCE, thisSequence);
        query.orderBy(PriceLevel.Properties.SEQUENCE).not().equals(PriceLevel.Properties.ID, this.getID());
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
        if (result.length <= 0) {
            return thisSequence;
        }
        int nextAvailableSequence = thisSequence;
        for (int rowIndex = 0; rowIndex < result.length; ++rowIndex) {
            if (result[0].length > 0 && (Integer)result[rowIndex][0] > nextAvailableSequence) {
                return nextAvailableSequence;
            }
            ++nextAvailableSequence;
        }
        return nextAvailableSequence;
    }

    public boolean hasHigherPriorityThan(PriceLevel levelToCompareTo) {
        return this.getSequence() > levelToCompareTo.getSequence();
    }

    public static PriceLevel findPriceLevel(String name) {
        return PersistenceManager.getObject(PriceLevel.class, Query.select(PriceLevel.class).active(PriceLevel.class).equalsParam(PriceLevel.Properties.LABEL).toString(), new Object[]{name});
    }

    public void autoFillOut(User user) {
        if (ExistingRule.INSTANCE == null || NullRule.INSTANCE == null || OverrideRule.INSTANCE == null || ReplicateRule.INSTANCE == null) {
            throw new IllegalStateException("Cannot register rule strategies.");
        }
        AutoFillOutStrategy strategy = AutoFillOutStrategy.autoFillOutStrategies.get((Object)this.getRuleToApply());
        if (strategy == null) {
            throw new IllegalStateException("The strategy is not registered for " + (Object)((Object)this.getRuleToApply()));
        }
        TerminalEventLog.logAutoFillPrice(user, this);
        if (ReplicateRule.INSTANCE.equals(strategy)) {
            ArrayList<UnitPriceLevel> toRemove = new ArrayList<UnitPriceLevel>();
            List<UnitPriceLevel> targetPrices = this.getReferencePriceLevel().getUnitPriceLevels();
            for (UnitPriceLevel myPrice : this.unitPriceLevels) {
                boolean found = false;
                if (myPrice.getUnit() != null) {
                    for (UnitPriceLevel targetPrice : targetPrices) {
                        if (!myPrice.getUnit().equals(targetPrice.getUnit())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                toRemove.add(myPrice);
            }
            for (UnitPriceLevel next : toRemove) {
                next.getUnit().removeUnitPriceLevel(next);
                this.removeUnitPriceLevel(next);
                next.delete();
            }
        }
        for (UnitPriceLevel sourceUnitPrice : this.getReferencePriceLevel().getUnitPriceLevels()) {
            if (sourceUnitPrice == null) {
                OrderMate.LOG.error("Integrity error: the price level " + this.getReferencePriceLevel() + " has a null UnitPriceLevel!");
                continue;
            }
            if (sourceUnitPrice.getUnit() == null) {
                OrderMate.LOG.error("Integrity error: the UnitPrice " + sourceUnitPrice + " has a null InventoryItemUnit!");
                continue;
            }
            InventoryItemUnit itemUnit = sourceUnitPrice.getUnit();
            UnitPriceLevel targetUnitPrice = itemUnit.getUnitPriceLevel(this);
            if (!strategy.canChangePrice(targetUnitPrice)) continue;
            this.applyNewPrice(sourceUnitPrice, itemUnit, targetUnitPrice);
        }
        this.unitPriceLevels.collapseUnsafe();
        this.getReferencePriceLevel().unitPriceLevels.collapseUnsafe();
    }

    private void applyNewPrice(UnitPriceLevel sourceUnitPrice, InventoryItemUnit itemUnit, UnitPriceLevel targetUnitPrice) {
        Price newPrice;
        if (this.getDollarToApply() != null && !this.getDollarToApply().isZero()) {
            newPrice = this.getDollarToApply().add(sourceUnitPrice.getPrice());
        } else {
            double toAdd = sourceUnitPrice.getPrice().doubleValue() * this.getPercentageToApply() / 100.0;
            newPrice = sourceUnitPrice.getPrice().add(new Price(toAdd, 0.01));
        }
        if (newPrice.doubleValue() < 0.0) {
            newPrice = Price.ZERO_DOLLAR;
        }
        if (targetUnitPrice == null) {
            targetUnitPrice = new UnitPriceLevel();
            itemUnit.addUnitPriceLevel(targetUnitPrice);
            this.addUnitPriceLevel(targetUnitPrice);
        }
        targetUnitPrice.setPrice(newPrice);
        targetUnitPrice.save();
    }

    public boolean canAutoFillOut() {
        boolean canDo = false;
        if (this.getReferencePriceLevel() != null && this.getReferencePriceLevel() != null && this.getDollarToApply() != null && this.getRuleToApply() != null) {
            canDo = true;
        }
        return canDo;
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    protected void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    protected void setUnitPriceLevels(List<UnitPriceLevel> newUnitPriceLevels) {
        this.unitPriceLevels = this.unitPriceLevels.clone();
        this.unitPriceLevels.set(newUnitPriceLevels);
    }

    @OneToMany(mappedBy="priceLevel", targetEntity=TriggerPriceLevelLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected List<TriggerPriceLevelLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    protected void setTriggerLinks(List<TriggerPriceLevelLink> newTriggerLinks) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(newTriggerLinks);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="default_level")
    public boolean isDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(boolean defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    private void validateOtherDefaultLevelSettings() {
        for (PriceLevel priceLevel : PersistenceManager.getObjectList(PriceLevel.class, Query.select(PriceLevel.class).toString())) {
            if (priceLevel.equals(this) || !priceLevel.isDefaultLevel()) continue;
            priceLevel.setDefaultLevel(false);
            priceLevel.save();
        }
    }

    public static PriceLevel getDefaultPriceLevel() throws IllegalStateException {
        PriceLevel priceLevel = theDefaultLevel.get();
        if (priceLevel == null) {
            priceLevel = PersistenceManager.getObject(PriceLevel.class, Query.select(PriceLevel.class).equals(PriceLevel.Properties.DEFAULT_LEVEL, 1.0).limit(1).toString(), null);
            if (priceLevel == null) {
                throw new IllegalStateException("A default price level must be set.");
            }
            priceLevel.activate();
            priceLevel.save();
        }
        return priceLevel;
    }

    public void activate() {
        this.setSystemState("ACTIVE");
    }

    @Column(name="loyalty_earn_factor")
    public double getLoyaltyEarnFactor() {
        return this.loyaltyEarnFactor;
    }

    public void setLoyaltyEarnFactor(double loyaltyEarnFactor) {
        this.loyaltyEarnFactor = loyaltyEarnFactor;
    }

    @Column(name="loyalty_redeem_factor")
    public double getLoyaltyRedeemFactor() {
        return this.loyaltyRedeemFactor;
    }

    public void setLoyaltyRedeemFactor(double loyaltyRedeemFactor) {
        this.loyaltyRedeemFactor = loyaltyRedeemFactor;
    }

    @Column(name="force_loyalty_factor")
    public boolean isForceLoyaltyFactor() {
        return this.forceLoyaltyFactor;
    }

    public void setForceLoyaltyFactor(boolean loyaltyFactorPriority) {
        this.forceLoyaltyFactor = loyaltyFactorPriority;
    }

    private static final class ReplicateRule
    implements AutoFillOutStrategy {
        static final ReplicateRule INSTANCE = new ReplicateRule();

        private ReplicateRule() {
            autoFillOutStrategies.put(PriceLevelRule.REPLICATE_RULE, this);
        }

        @Override
        public boolean canChangePrice(UnitPriceLevel targetUnitPrice) {
            return true;
        }
    }

    private static final class ExistingRule
    implements AutoFillOutStrategy {
        static final ExistingRule INSTANCE = new ExistingRule();

        private ExistingRule() {
            autoFillOutStrategies.put(PriceLevelRule.EXISTING_RULE, this);
        }

        @Override
        public boolean canChangePrice(UnitPriceLevel targetUnitPrice) {
            return targetUnitPrice != null && targetUnitPrice.getPrice() != null && !targetUnitPrice.getPrice().isZero();
        }
    }

    private static final class NullRule
    implements AutoFillOutStrategy {
        static final NullRule INSTANCE = new NullRule();

        private NullRule() {
            autoFillOutStrategies.put(PriceLevelRule.NULL_RULE, this);
        }

        @Override
        public boolean canChangePrice(UnitPriceLevel targetUnitPrice) {
            return targetUnitPrice == null || targetUnitPrice.getPrice() == null || targetUnitPrice.getPrice().isZero();
        }
    }

    private static final class OverrideRule
    implements AutoFillOutStrategy {
        static final OverrideRule INSTANCE = new OverrideRule();

        private OverrideRule() {
            autoFillOutStrategies.put(PriceLevelRule.OVERRIDE_RULE, this);
        }

        @Override
        public boolean canChangePrice(UnitPriceLevel targetUnitPrice) {
            return true;
        }
    }

    private static interface AutoFillOutStrategy {
        public static final Map<PriceLevelRule, AutoFillOutStrategy> autoFillOutStrategies = new HashMap<PriceLevelRule, AutoFillOutStrategy>();

        public boolean canChangePrice(UnitPriceLevel var1);
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property SHOW_ON_RECEIPT;
        public PropertiedObject.Property TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<TriggerPriceLevelLink> TRIGGER_LINKS;
        public PropertiedObject.Property<UnitPriceLevel> UNIT_PRICE_LEVELS;
        public PropertiedObject.Property<PriceLevel> REFERENCE_PRICE_LEVEL;
        public PropertiedObject.Property DOLLAR_TO_APPLY;
        public PropertiedObject.Property PERCENTAGE_TO_APPLY;
        public PropertiedObject.Property<PriceLevelRule> RULE_TO_APPLY;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property<Boolean> DEFAULT_LEVEL;
        public PropertiedObject.Property LOYALTY_EARN_FACTOR;
        public PropertiedObject.Property LOYALTY_REDEEM_FACTOR;
        public PropertiedObject.Property FORCE_LOYALTY_FACTOR;
    }
}

