/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;

public class PriceLevelHelper {
    public static void applyEarnFactorToUnitPriceLevels(PriceLevel toUse) {
        List<UnitPriceLevel> unitPriceLevels = toUse.getUnitPriceLevels();
        long time = System.currentTimeMillis();
        for (UnitPriceLevel UPL : unitPriceLevels) {
            UPL.setLoyaltyAdd(PriceLevelHelper.calculateEarnLoyalty(toUse, UPL));
            UPL.save();
        }
        OrderMate.LOG.info("SysCurTime = " + (System.currentTimeMillis() - time) + "\nsize = " + unitPriceLevels.size());
    }

    public static void applyRedeemFactorToUnitPriceLevels(PriceLevel toUse) {
        List<UnitPriceLevel> unitPriceLevels = toUse.getUnitPriceLevels();
        for (UnitPriceLevel UPL : unitPriceLevels) {
            UPL.setLoyaltyRedeem(PriceLevelHelper.calculateRedeemLoyalty(toUse, UPL));
            UPL.save();
        }
    }

    public static int calculateEarnLoyalty(PriceLevel priceLevel, UnitPriceLevel unit) {
        int toReturn = (int)(unit.getPrice().doubleValue() * priceLevel.getLoyaltyEarnFactor());
        return toReturn;
    }

    public static int calculateRedeemLoyalty(PriceLevel priceLevel, UnitPriceLevel unit) {
        int toReturn = (int)(unit.getPrice().doubleValue() * priceLevel.getLoyaltyRedeemFactor());
        return toReturn;
    }
}

