/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_trigger_price_level_link")
@AccessType(value="property")
public class TriggerPriceLevelLink
extends PersistentObject
implements SaveableChild,
TriggerLink {
    public static final Props Properties = new Props();
    private Reference<PriceLevel> priceLevel;
    private Reference<AbstractTrigger> trigger;

    public TriggerPriceLevelLink() {
        this.priceLevel = this.createReference(TriggerPriceLevelLink.Properties.PRICE_LEVEL);
        this.trigger = this.createReference(TriggerPriceLevelLink.Properties.TRIGGER);
    }

    public TriggerPriceLevelLink(PriceLevel level, AbstractTrigger newTrigger) {
        this.priceLevel = this.createReference(TriggerPriceLevelLink.Properties.PRICE_LEVEL);
        this.trigger = this.createReference(TriggerPriceLevelLink.Properties.TRIGGER);
        this.setPriceLevel(level);
        this.setTrigger(newTrigger);
    }

    @ManyToOne(targetEntity=PriceLevel.class)
    @JoinColumn(name="FK_inventory_price_level", referencedColumnName="ID")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    public void setPriceLevel(PriceLevel newPriceLevel) {
        this.priceLevel.set(newPriceLevel);
    }

    @Override
    @ManyToOne(targetEntity=AbstractTrigger.class)
    @JoinColumn(name="FK_inventory_trigger", referencedColumnName="ID")
    public AbstractTrigger getTrigger() {
        return this.trigger.get();
    }

    public void setTrigger(AbstractTrigger newTrigger) {
        this.trigger.set(newTrigger);
    }

    @Override
    public void deleteChild() {
        this.setPriceLevel(null);
        this.setTrigger(null);
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void saveChild() {
        if (this.getTrigger() == null || this.getPriceLevel() == null) {
            this.deleteChild();
        } else {
            PersistenceManager.saveChild(this);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
        public PropertiedObject.Property<AbstractTrigger> TRIGGER;
    }
}

